#include "emmaCode.h"

//init debug port
Serial DBG(PA_9, PA_10);    //tx, rx

//init wifi port
Serial _ESP(PA_2, PA_3);    //tx, rx
//init espduino - without ch_pd pin
ESP esp(&_ESP, &DBG, ESP_BAUD);
//init wifi mqtt
//ESPMQTT mqtt(&esp);
//init wifi rest
REST rest(&esp);

//init eth port
SPI spi(PB_15, PB_14, PB_13);               //mosi, miso, sck
EthernetInterface eth(&spi, PB_12, PC_6);   //spi, cs, reset
//MQTTEthernet ipstack(&spi, PB_12, PC_6);    //spi, cs, reset
//MQTT::Client<MQTTEthernet, Countdown, MQTT_MAX_PACKET_SIZE> client(ipstack);
TCPSocketConnection sock;

//init gprs
SoftSerial sim900(PC_10, PA_15); //tx, rx
DigitalOut pwrKey(PA_8);

//init sd card
SDFileSystem sd(PA_7, PA_6, PA_5, PB_3, "sd"); //mosi, miso, sck, cs

//init ade7758 - without cs pin
ADE7758 ADE(PB_6, PB_4, PB_5, PB_7);  //mosi, miso, sck, irq

//init tft lcd
SPI_TFT_ILI9341 TFT(PA_7, PA_6, PA_5, PA_4, PC_5, PC_4,"TFT");  //mosi, miso, sclk, cs, reset, dc
//init touch screen - without cs pin
TouchScreenADS7843 TP(PB_10, PB_0, PB_1, PB_2, &TFT);    //mosi, miso, sclk, irq, tft
InterruptIn tpIRQ(PB_2);

//init dht sensor
DHT11 d(PD_2);

//emma settings
string emmaUID;
string hmac;
string appNAME;
string mqttDOMAIN;
string mqttKEY;
string mqttSECRET;
string mqttSERVER;
int mqttPORT;
string restSERVER;
int restPORT;
string wifiSSID;
string wifiPASS;
string gprsAPN;
string proxySERVER;
int proxyPORT;
string proxyAUTH;
int powerPHASE;
//threshold default values
int vrmsTHL = 176;
int vrmsTHH = 264;
int wattTHL = 1760;
int wattTHH = 2640;

//nodes settings
class NODES {
public:
    REST *restConn;
    NODES(REST *r);
    int type;
    string macAddr;
    string ipAddr;
};
NODES::NODES(REST *r) {
    restConn = r;    
}
REST restObj[NODES_MAX] = {REST(&esp),REST(&esp),REST(&esp),REST(&esp),REST(&esp)};
NODES nodes[NODES_MAX] = {NODES(&restObj[0]),NODES(&restObj[1]),NODES(&restObj[2]),NODES(&restObj[3]),NODES(&restObj[4])};

//mode box class    //need to be deleted
class modeBox {
public:
    int xTL;    //TopLeft
    int yTL;
    int xBR;    //BottomRight
    int yBR;
    string text;
    string name;
};

//mode circle class
class modeCircle {
public:
    void drawCircle(string textLeft, string textRight) {
        TFT.fillarc(80, 120, 70, 5, 0, 360, White);
        TFT.locate(65 - ((textLeft.length()*9)/2),110);
        TFT.printf("%s",textLeft.c_str());
        
        TFT.fillarc(240, 120, 70, 5, 0, 360, White);
        TFT.locate(225 - ((textRight.length()*9)/2),110);
        TFT.printf("%s",textRight.c_str());    
    }
    
    void animateCircle(int circleId) {  //leftCirle=0 , rightCirle=1
        int _x=0;
        
        if(circleId == leftCircle) {
            _x=80;
        } else {
            _x=240;    
        }
        
        for(int i=0; i<1440; i+=4) {
            TFT.fillarc(_x, 120, 70, 5, 1440-i-45, 1440-i+45, Black);
            TFT.fillarc(_x, 120, 70, 5, 1440-i+45, 1440-i+45+4, White);    
        }
    }
};

//ade7758 variables
uint32_t AWattHrValue, BWattHrValue, CWattHrValue;
uint32_t AVAHrValue, BVAHrValue, CVAHrValue;
uint32_t AWattHrSum = 0;
uint32_t BWattHrSum = 0;
uint32_t CWattHrSum = 0;
float AWattHr, BWattHr, CWattHr;
float AVrms, BVrms, CVrms;
float AIrms, BIrms, CIrms;
float AWatt, BWatt, CWatt;
float XWattHr,XVrms,XWatt;
int panelTemp = 25; //default

//alert variables
bool allowAlertAVrms = true;
bool allowAlertAWatt = true;
bool allowAlertBVrms = true;
bool allowAlertBWatt = true;
bool allowAlertCVrms = true;
bool allowAlertCWatt = true;

//variables
bool ethAvailable = false;
bool wifiAvailable = false;
bool gprsAvailable = false;
bool ethConnected = false;
bool wifiConnected = false;
bool gprsConnected = false;
bool useProxy = false;
bool newCommand = false;
bool espFreeMemory = false;
bool espDHCPClientStart = false;
bool newEnergyData = false;
string globalCommand;
string rxBuf;
string gprsRxBuf;
string rxLog;
string rxLogA;

//color of lcd
uint16_t colorLightGray = TFT.color565(192,192,192);
uint16_t colorGray = TFT.color565(127,127,127);
uint16_t colorDarkGray = TFT.color565(64,64,64);
uint16_t colorLightGreen = TFT.color565(50,255,150);

/*start lcd and touch*/
int emmaModeSelection(void) {   //circle
    bool modeSelected = false;
    int idx=0;
    int md=0;
    int TPx;
    int TPy;
    Timer t;
    
    TFT.background(Blue);
    TFT.foreground(White);
    
    TFT.set_font((unsigned char*) Lato27x27);
    TFT.set_orientation(3);
    TFT.cls();
    
    TFT.locate(40,25);
    TFT.printf("Loading Emma...");
    
    TFT.locate(0,0);
    TFT.fillarc(159,149,20,10,0,360, colorLightGray);
    
    for(int i=0; i<2880; i+=4) {
        TFT.fillarc(159, 149, 20, 10, (i>>1)-45, (i>>1)+45,colorDarkGray);
        TFT.fillarc(159, 149, 20, 10, (i >> 1)-45-4, (i >> 1)-45, colorLightGray);
        
        TFT.fillarc(159, 149, 40, 10, 1440-i-45, 1440-i+45, colorDarkGray);
        TFT.fillarc(159, 149, 40, 10, 1440-i+45, 1440-i+45+4, colorLightGray);    
    }
    
    TFT.cls();
    
    Matrix matrix;
    Coordinate ScreenSample[3];
    
    //lcd type 1
    matrix.An = 580;
    matrix.Bn = 75980;
    matrix.Cn = -3410580;
    matrix.Dn = 57855;
    matrix.En = -2465;
    matrix.Fn = -3483515;
    matrix.Divider = 209144;
    
    ScreenSample[0].x = 230;
    ScreenSample[0].y = 167;
    ScreenSample[1].x = 754;
    ScreenSample[1].y = 163;
    ScreenSample[2].x = 771;
    ScreenSample[2].y = 562;
    
    //lcd type 2
    //matrix.An = 1305;
    //matrix.Bn = -77430;
    //matrix.Cn = 75296670;
    //matrix.Dn = -57275;
    //matrix.En = -1160;
    //matrix.Fn = 55285220;
    //matrix.Divider = 211002;
    
    //ScreenSample[0].x = 782;
    //ScreenSample[0].y = 863;
    //ScreenSample[1].x = 248;
    //ScreenSample[1].y = 854;
    //ScreenSample[2].x = 256;
    //ScreenSample[2].y = 459;
    
    TP.SetCalibration(&matrix, &ScreenSample[0]);
    
    TFT.locate(5,5);
    TFT.set_font((unsigned char*) Lato19x19);
    TFT.printf("Hi, kamu mau apa?");
    wait(2);
    
    //menu
    //1. make two options, operasi or pengaturan
    //2. registrasi or lanjut
    //3. controller or lanjut
    //4. wifi or update firmware
    string menuText[8] = {"Jalan","Pengaturan","Daftar","Lanjut","P. EMMA","Lanjut","P. WiFi","Update"};
    
    //init main menu
    modeCircle menu;
    
    menu.drawCircle(menuText[idx],menuText[idx+1]);
            
    //read emma settings
    emmaReadSettings();
    
    //mqttDOMAIN is not empty -> has been registered
    if(!mqttDOMAIN.empty()) {
        TFT.locate(0,200);
        TFT.printf(" auto selection");
        t.start();
    }
    
    while(!modeSelected) {
        if(!TP._tp_irq) {
            if(TP.Read_Ads7843()) {
                TP.getDisplayPoint();
                TPx = TP.display.x;
                TPy = TP.display.y;
                TP.TP_DrawPoint(TPx,TPy, Blue);
                if((20 < TPx && TPx < 150) && (55 < TPy && TPy < 190)) {            //pick leftCircle
                    if(idx==0) {
                        md = MODE_OPERATION;    
                    } else if(idx==2) {
                        md = MODE_REGISTER;    
                    } else if(idx==4) {
                        md = MODE_SETTINGS;    
                    } else if(idx==6) {
                        md = MODE_WIFI_CONFIG;    
                    }
                    modeSelected = true;
                    menu.animateCircle(leftCircle);    
                } else if((180 < TPx && TPx < 310) && (55 < TPy && TPy < 190)) {    //pick rightCircle
                    if(idx == 6) {
                        md = MODE_FIRMWARE_DOWNLOAD;
                        modeSelected = true;
                        menu.animateCircle(rightCircle);    
                    } else {
                        idx = idx+2;
                        menu.animateCircle(rightCircle);
                        wait(0.5);
                        TFT.cls();
                        TFT.locate(5,5);
                        TFT.printf("Hi, kamu mau apa?");
                        menu.drawCircle(menuText[idx],menuText[idx+1]);    
                    }
                }
            }
        } else if(t.read()>60) {
            md = MODE_OPERATION;
            modeSelected = true;
            t.stop();
            t.reset();    
        }
    }
    
    //TFT.locate(0,200);
    //TFT.printf("                         ");
    //TFT.locate(10,200);
    //TFT.printf("mode: %d is selected",md);
    //wait(2);
    TFT.cls();
    
    return md;
}
/*
int emmaModeSelection(void) {   //box
    bool modeSelected = false;
    int md=0;
    int TPx;
    int TPy;
    Timer t;
    
    TFT.background(Black);
    TFT.foreground(White);
    
    TFT.set_font((unsigned char*) Arial12x12);
    TFT.set_orientation(1);
    TFT.cls();
    TFT.locate(0,0);
    TFT.printf("Hello, I'm Emma!");
    wait(2);
    TFT.cls();
    
    Matrix matrix;
    Coordinate ScreenSample[3];
    
    //lcd type 1
    //matrix.An = 580;
    //matrix.Bn = 75980;
    //matrix.Cn = -3410580;
    //matrix.Dn = 57855;
    //matrix.En = -2465;
    //matrix.Fn = -3483515;
    //matrix.Divider = 209144;
    
    //ScreenSample[0].x = 230;
    //ScreenSample[0].y = 167;
    //ScreenSample[1].x = 754;
    //ScreenSample[1].y = 163;
    //ScreenSample[2].x = 771;
    //ScreenSample[2].y = 562;
    
    //lcd type 2
    matrix.An = 1305;
    matrix.Bn = -77430;
    matrix.Cn = 75296670;
    matrix.Dn = -57275;
    matrix.En = -1160;
    matrix.Fn = 55285220;
    matrix.Divider = 211002;
    
    ScreenSample[0].x = 782;
    ScreenSample[0].y = 863;
    ScreenSample[1].x = 248;
    ScreenSample[1].y = 854;
    ScreenSample[2].x = 256;
    ScreenSample[2].y = 459;
    
    TP.SetCalibration(&matrix, &ScreenSample[0]);
    
    //draw border
    TFT.line(15,15,310,15,Orange);
    TFT.line(310,15,310,250,Orange);
    TFT.line(310,250,15,250,Orange);
    TFT.line(15,250,15,15,Orange);
    
    //init main menu
    modeBox menu[6];
    
    //wifi config mode
    menu[MODE_WIFI_CONFIG].xTL = 25;
    menu[MODE_WIFI_CONFIG].yTL = 25;
    menu[MODE_WIFI_CONFIG].xBR = 110;
    menu[MODE_WIFI_CONFIG].yBR = 90;
    menu[MODE_WIFI_CONFIG].text = "1.wifi config";
    menu[MODE_WIFI_CONFIG].name = "wifi config";
    
    //setting mode
    menu[MODE_SETTINGS].xTL = 25;
    menu[MODE_SETTINGS].yTL = 100;
    menu[MODE_SETTINGS].xBR = 110;
    menu[MODE_SETTINGS].yBR = 165;
    menu[MODE_SETTINGS].text = "2.settings   ";
    menu[MODE_SETTINGS].name = "settings";
    
    //register mode
    menu[MODE_REGISTER].xTL = 120;
    menu[MODE_REGISTER].yTL = 25;
    menu[MODE_REGISTER].xBR = 205;
    menu[MODE_REGISTER].yBR = 90;
    menu[MODE_REGISTER].text = "3.register   ";
    menu[MODE_REGISTER].name = "register";
    
    //operational mode
    menu[MODE_OPERATION].xTL = 120;
    menu[MODE_OPERATION].yTL = 100;
    menu[MODE_OPERATION].xBR = 205;
    menu[MODE_OPERATION].yBR = 165;
    menu[MODE_OPERATION].text = "4.operation  ";
    menu[MODE_OPERATION].name = "operation";
    
    //firmware download mode
    menu[MODE_FIRMWARE_DOWNLOAD].xTL = 215;
    menu[MODE_FIRMWARE_DOWNLOAD].yTL = 25;
    menu[MODE_FIRMWARE_DOWNLOAD].xBR = 300;
    menu[MODE_FIRMWARE_DOWNLOAD].yBR = 90;
    menu[MODE_FIRMWARE_DOWNLOAD].text = "5.fw dwld  ";
    menu[MODE_FIRMWARE_DOWNLOAD].name = "fw dwld";
    
    //reserved mode
    menu[MODE_RESERVED].xTL = 215;
    menu[MODE_RESERVED].yTL = 100;
    menu[MODE_RESERVED].xBR = 300;
    menu[MODE_RESERVED].yBR = 165;
    menu[MODE_RESERVED].text = "6.reserved  ";
    menu[MODE_RESERVED].name = "reserved";
    
    //draw main menu
    for(int i=0; i<6; i++) {
        TFT.fillrect(menu[i].xTL,menu[i].yTL,menu[i].xBR,menu[i].yBR,Orange);    
    }
    
    //add text to main menu
    for(int i=0; i<6; i++) {
        TFT.locate(menu[i].xTL,menu[i].yTL);
        TFT.printf("%s",menu[i].text.c_str());
    }
    
    //read emma settings
    emmaReadSettings();
    
    //mqttDOMAIN is not empty -> has been registered
    if(!mqttDOMAIN.empty()) {
        TFT.locate(25,170);
        TFT.printf(" auto select enabled");
        t.start();
    }
    
    while(!modeSelected) {
        if(!TP._tp_irq) {
            if(TP.Read_Ads7843()) {
                TP.getDisplayPoint();
                TPx = TP.display.x;
                TPy = TP.display.y;
                TP.TP_DrawPoint(TPx,TPy, Blue);
                
                for(int i=0; i<6; i++) {
                    if((menu[i].xTL < TPx && TPx < menu[i].xBR) && (menu[i].yTL < TPy && TPy < menu[i].yBR)) {
                        md = i;
                        modeSelected = true;
                    }
                }
            }
        }
        
        //auto select (to emmaModeOperation) after some times
        if(!mqttDOMAIN.empty()) {
            if(t.read()>20) {
                md = MODE_OPERATION;
                modeSelected = true;
                t.stop();
                t.reset();    
            }
        }
        
    }
    
    TFT.locate(25,170);
    TFT.printf("                         ");
    TFT.locate(25,170);
    TFT.printf("mode: %s is selected",menu[md].name.c_str());
    wait(2);
    TFT.cls();
    
    return md;
}
*/
/*end lcd and touch*/

/*start emma read settings*/
void emmaReadSettings(void) {
    char s[64];
    string str;
    DBG.baud(19200);
    DBG.printf("\r\nemmaReadSettings\r\n");
    
    //read settings
    emmaUID = readSetting("emmaUID");
    DBG.printf("emmaUID:%s\r\n",emmaUID.c_str());
    
    //calculate hmac
    for(int i=0; i<sizeof(s); i++) {
        s[i]=0; }
    sprintf(s,"emma-%s",emmaUID.c_str());   
    hmac = calculateMD5(s);
    DBG.printf("hmac:%s\r\n",hmac.c_str());
    
    appNAME = readSetting("appNAME");
    DBG.printf("appNAME:%s\r\n",appNAME.c_str());
    
    mqttDOMAIN = readSetting("mqttDOMAIN");
    DBG.printf("mqttDOMAIN:%s\r\n",mqttDOMAIN.c_str());
    mqttKEY = readSetting("mqttKEY");
    DBG.printf("mqttKEY:%s\r\n",mqttKEY.c_str());
    mqttSECRET = readSetting("mqttSECRET");
    DBG.printf("mqttSECRET:%s\r\n",mqttSECRET.c_str());
    mqttSERVER = readSetting("mqttSERVER");
    DBG.printf("mqttSERVER:%s\r\n",mqttSERVER.c_str());
    str = readSetting("mqttPORT");
    sscanf(str.c_str(),"%d",&mqttPORT);
    DBG.printf("mqttPORT:%d\r\n",mqttPORT);
    
    restSERVER = readSetting("restSERVER");
    DBG.printf("restSERVER:%s\r\n",restSERVER.c_str());
    str = readSetting("restPORT");
    sscanf(str.c_str(),"%d",&restPORT);
    DBG.printf("restPORT:%d\r\n",restPORT);
    
    gprsAPN = readSetting("gprsAPN");
    DBG.printf("gprsAPN:%s\r\n",gprsAPN.c_str());
    
    proxySERVER = readSetting("proxySERVER");
    DBG.printf("proxySERVER:%s\r\n",proxySERVER.c_str());
    str = readSetting("proxyPORT");
    sscanf(str.c_str(),"%d",&proxyPORT);
    DBG.printf("proxyPORT:%s\r\n",proxyPORT);
    proxyAUTH = readSetting("proxyAUTH");
    DBG.printf("proxyAUTH:%s\r\n",proxyAUTH.c_str());
    wifiSSID = readSetting("wifiSSID");
    DBG.printf("wifiSSID:%s\r\n",wifiSSID.c_str());
    wifiPASS = readSetting("wifiPASS");
    DBG.printf("wifiPASS:%s\r\n",wifiPASS.c_str());
    str = readSetting("powerPHASE");
    sscanf(str.c_str(),"%d",&powerPHASE);
    DBG.printf("powerPHASE:%d\r\n",powerPHASE);
}
/*end emma read settings*/

/*start emma mode*/
void emmaInit(int mode) {
    DBG.printf("\r\nemmaInit\r\n");
    DBG.printf("mode:%d\r\n",mode);
    
    //check proxy
    if(!proxySERVER.empty() && !proxyAUTH.empty()) {
        useProxy = true;
    } else {
        useProxy = false;    
    }
    //testing purpose
    //useProxy = false;
    DBG.printf("proxy:%d\r\n",useProxy);
    
    //check available interface
    isEthAvailable();           //check whether cable is connected
    wifiAvailable = true;       //wifi module will always on the board
    gprsAvailable = true;       //gprs module will always on the board
    
    DBG.printf("eth:%d\r\n",ethAvailable);
    DBG.printf("wifi:%d\r\n",wifiAvailable);
    DBG.printf("gprs:%d\r\n",gprsAvailable);
}
void emmaModeWiFiConfig(void) {
    bool findCh;
    bool waitAnimation = false;
    string str;
    Timer t;
        
    DBG.printf("emmaModeWiFiConfig\r\n");
    
    //waiting
    _ESP.attach(&rxInterrupt,Serial::RxIrq);
        
    //set wifi module to configuration
    _ESP.printf("MODE=C");
    waitAnimation = true;
    
    t.start();
    while(waitAnimation) {
        for(int i=0; i<2880; i+=4) {
            TFT.fillarc(160, 130, 92, 4, (i >> 1)-45, (i >> 1)+45, colorDarkGray);
            TFT.fillarc(160, 130, 92, 4, (i >> 1)-45-4, (i >> 1)-45, Blue);
            TFT.fillarc(160, 130, 95, 4, 1440-i-45, 1440-i+45, colorDarkGray);
            TFT.fillarc(160, 130, 95, 4, 1440-i+45, 1440-i+45+4, colorLightGray);
            
            if(rxBuf.find("SC_STATUS_FIND_CHANNEL") != std::string::npos) {
                findCh = true;
                waitAnimation = false;
            }
            if(t.read() > 60.0f) {
                t.stop();
                t.reset();
                findCh = false;
                waitAnimation = false;
            }
        }
    }
    //disable UART2 IRQ
    NVIC_DisableIRQ(USART2_IRQn);
    
    TFT.cls();
    if(findCh) {
        TFT.locate(10,200);
        TFT.printf("Silakan sambungkan dg App");
        
        DBG.printf("enter wifi configuration mode\r\n");
        while(1) {
            char rcv[128] = {};
            wifiRcvReply(rcv,3000);
            str = rcv;
            if(str.find("MODE=C OK") != std::string::npos) {
                TFT.locate(0,200);
                TFT.printf("                              ");
                //save wifiSSID and wifiPASS
                if(str.find("[") != std::string::npos && str.find("]") != std::string::npos) {
                    str.erase(str.begin(),str.begin()+str.find("[")+1);
                    str.erase(str.begin()+str.find("]"),str.end());
                            
                    MbedJSONValue jsonValue;
                    parse(jsonValue,str.c_str());
                        
                    char *parameter[2] = {"wifiSSID","wifiPASS"};
                        
                    for(int i=0; i<2; i++) {
                        if(jsonValue.hasMember(parameter[i])) {
                            string val = jsonValue[parameter[i]].get<std::string>();
                            int st = writeSetting(parameter[i],val.c_str());
                            if(st) {
                                DBG.printf("%s is saved\r\n",parameter[i]);
                                TFT.locate(10,200);
                                TFT.printf(" %s tersimpan",parameter[i]);
                                wait(1);
                                TFT.locate(0,200);
                                TFT.printf("                              ");
                            } else {
                                DBG.printf("%s is not saved\r\n",parameter[i]);
                                TFT.locate(10,200);
                                TFT.printf(" %s tak tersimpan",parameter[i]);
                                wait(1);
                                TFT.locate(0,200);
                                TFT.printf("                              ");
                            }
                        }
                    }
                    
                    //wificonfig finish
                    lcdDrawSmile();
                    TFT.locate(0,200);
                    TFT.printf("                              ");
                    TFT.locate(10,200);
                    TFT.printf("Sukses! Tolong restart EMMA");
                } 
            } else if(str.find("SC_STATUS_GETTING_SSID_PSWD") != std::string::npos){
                DBG.printf("app connected\r\n");
                TFT.locate(0,200);
                TFT.printf("                              ");
                TFT.locate(10,200);
                TFT.printf("App tersambung");
            }
        }
    } else {
        lcdDrawFrown();
        TFT.locate(0,200);
        TFT.printf("                              ");
        TFT.locate(10,200);
        TFT.printf("Gagal! Tolong restart EMMA");
    }
}
void emmaModeSettings(void) {
    bool clientIsConnected = false;
    bool serverIsListened = false;
    bool waitAnimation = false;
    char s[32];
    string str;
    
    //create settings dir
    mkdir("/sd/settings",0777);
    
    //get and write emmaUID
    string uid = getUID();
    sprintf(s,"(%s)",uid.c_str());
    uid = s;
    writeSetting("emmaUID",uid);
    
    if(ethAvailable) {  //might not be used in the future as not supported in current mobile app
        DBG.printf("emmaModeSettings - eth\r\n");
        eth.init();
        eth.connect();
        wait(2);
        TFT.locate(0,0);
        TFT.printf("                                             ");
        TFT.locate(0,0);
        TFT.printf(" emmaModeSettings");
        
        TCPSocketServer svr;
        TCPSocketConnection clientSock;
    
        if(svr.bind(SERVER_PORT) < 0) {
            DBG.printf("tcp server bind failed\r\n");    
        } else {
            DBG.printf("tcp server bind success\r\n");
            serverIsListened = true;    
        }
    
        //DBG.printf("please connect to %s\r\n",ipstack.getEth().getIPAddress());
        DBG.printf("please connect to %s\r\n",eth.getIPAddress());
        
        if(svr.listen(1) < 0) {
            DBG.printf("tcp server listen failed\r\n");
            TFT.locate(0,20);
            TFT.printf(" settings error. please restart.");
            while(1);
        } else {
            DBG.printf("tcp server is listening...\r\n");
            TFT.locate(0,20);
            TFT.printf(" connect with emma app now!");
        }
    
        clientSock.set_blocking(false,30000);   //timeout after 30sec
    
        //listening
        while (serverIsListened) {
            if(svr.accept(clientSock) < 0) {
                DBG.printf("failed to accept connection\r\n");
                TFT.locate(0,20);
                TFT.printf("                                        ");
                TFT.locate(0,20);
                TFT.printf("failed to accept connection");
            } else {
                DBG.printf("connection success!\r\nIP: %s\r\n",clientSock.get_address());
                TFT.locate(0,20);
                TFT.printf("                                        ");
                TFT.locate(0,20);
                //TFT.printf(" connection success! IP: %s",clientSock.get_address());
                TFT.printf(" connection success!");
                clientIsConnected = true;
            
                while(clientIsConnected) {
                    char buffer[1024] = {};
                    switch(clientSock.receive(buffer,1023)) {
                        case 0:
                            DBG.printf("received buffer is empty\r\n");
                            clientIsConnected = false;
                            break;
                        case -1:
                            DBG.printf("failed to read data from client\r\n");
                            clientIsConnected = false;
                            break;
                        default:
                            //DBG.printf("received data: %d\r\n%s\r\n",strlen(buffer),buffer);
                            DBG.printf("\r\n");
                        
                            str = buffer;
                            if(str.find("[") != std::string::npos && str.find("]") != std::string::npos) {
                                str.erase(str.begin(),str.begin()+str.find("[")+1);
                                str.erase(str.begin()+str.find("]"),str.end());
                            
                                MbedJSONValue jsonValue;
                                parse(jsonValue,str.c_str());
                        
                                char *parameter[5] = {"gprsAPN","proxySERVER","proxyPORT","proxyAUTH","epochTime"};
                        
                                for(int i=0; i<4; i++) {
                                    if(jsonValue.hasMember(parameter[i])) {
                                        string val = jsonValue[parameter[i]].get<std::string>();
                                        int st = writeSetting(parameter[i],val.c_str());
                                        if(st) {
                                            DBG.printf("%s: %s is saved\r\n",parameter[i],val.c_str());
                                            TFT.locate(0,40);
                                            TFT.printf(" %s: %s is saved",parameter[i],val.c_str());
                                            wait(1);
                                            TFT.locate(0,40);
                                            TFT.printf("                                             ");
                                        } else {
                                            DBG.printf("%s is not saved\r\n",parameter[i]);
                                            TFT.locate(0,40);
                                            TFT.printf(" %s is not saved",parameter[i]);
                                            wait(1);
                                            TFT.locate(0,40);
                                            TFT.printf("                                             ");
                                        }
                                    }
                                }
                                
                                //set time
                                if(jsonValue.hasMember(parameter[4])) {
                                    string epTime = jsonValue[parameter[4]].get<std::string>();
                                    time_t seconds;
                                    sscanf(epTime.c_str(),"%d",&seconds);
                                    set_time(seconds);
                                    DBG.printf("time is set\r\n");
                                    TFT.locate(0,40);
                                    TFT.printf(" time is set");
                                    wait(1);
                                    TFT.locate(0,40);
                                    TFT.printf("                                             ");
                                }
                            }
                            break;     
                    }    
                }
                DBG.printf("close connection\r\n");
                TFT.locate(0,20);
                TFT.printf("                                             ");
                TFT.locate(0,20);
                TFT.printf(" settings finish. please restart.");
                clientSock.close();
            }
        }
    } else if(wifiAvailable) {
        DBG.printf("emmaModeSettings - wifi\r\n");
        
        _ESP.attach(&rxInterrupt,Serial::RxIrq);
        
        _ESP.printf("MODE=S");
        waitAnimation = true;
        
        while(waitAnimation) {
            for(int i=0; i<2880; i+=4) {
                TFT.fillarc(160, 130, 92, 4, (i >> 1)-45, (i >> 1)+45, colorDarkGray);
                TFT.fillarc(160, 130, 92, 4, (i >> 1)-45-4, (i >> 1)-45, Blue);
                TFT.fillarc(160, 130, 95, 4, 1440-i-45, 1440-i+45, colorDarkGray);
                TFT.fillarc(160, 130, 95, 4, 1440-i+45, 1440-i+45+4, colorLightGray);
                
                if(rxBuf.find("MODE=S_OK") != std::string::npos) {
                    waitAnimation = false;
                }
            }
        }
        //disable UART2 IRQ
        NVIC_DisableIRQ(USART2_IRQn);
        
        TFT.cls();
        TFT.locate(10,200);
        TFT.printf(" Silakan sambungkan dg App");
        DBG.printf("enter EMMA settings mode\r\n");
        
        while(1) {
            char rcv[512] = {};
            wifiRcvReply(rcv,3000);
            str = rcv;
            if(str.find("MODE=S_Config") != std::string::npos) {
                TFT.locate(0,200);
                TFT.printf("                              ");
                //save gprs and proxy setting
                if(str.find("[") != std::string::npos && str.find("]") != std::string::npos) {
                    str.erase(str.begin(),str.begin()+str.find("[")+1);
                    str.erase(str.begin()+str.find("]"),str.end());
                            
                    MbedJSONValue jsonValue;
                    parse(jsonValue,str.c_str());
                        
                    char *parameter[5] = {"gprsAPN","proxySERVER","proxyPORT","proxyAUTH","epochTime"};
                        
                    for(int i=0; i<4; i++) {
                        if(jsonValue.hasMember(parameter[i])) {
                            string val = jsonValue[parameter[i]].get<std::string>();
                            int st = writeSetting(parameter[i],val.c_str());
                            if(st) {
                                DBG.printf("%s: %s is saved\r\n",parameter[i],val.c_str());
                                TFT.locate(10,200);
                                TFT.printf(" %s tersimpan",parameter[i]);
                                wait(1);
                                TFT.locate(0,200);
                                TFT.printf("                                             ");
                            } else {
                                DBG.printf("%s is not saved\r\n",parameter[i]);
                                TFT.locate(10,200);
                                TFT.printf(" %s tak tersimpan",parameter[i]);
                                wait(1);
                                TFT.locate(0,200);
                                TFT.printf("                                             ");
                            }
                        }
                    }
                    
                    //set time
                    if(jsonValue.hasMember(parameter[4])) {
                        string epTime = jsonValue[parameter[4]].get<std::string>();
                        time_t seconds;
                        sscanf(epTime.c_str(),"%d",&seconds);
                        set_time(seconds);
                        DBG.printf("time is set\r\n");
                        TFT.locate(10,200);
                        TFT.printf(" waktu sudah diset");
                        wait(1);
                        TFT.locate(0,200);
                        TFT.printf("                                             ");
                    }
                    
                    //setting finish
                    lcdDrawSmile();
                    TFT.locate(0,200);
                    TFT.printf("                                             ");
                    TFT.locate(10,200);
                    TFT.printf("Sukses! Tolong restart EMMA");    
                }    
            } else if(str.find("connect") != std::string::npos) {
                DBG.printf("connection success!\r\n");
                TFT.locate(0,200);
                TFT.printf("                                             ");
                TFT.locate(10,200);
                TFT.printf("App tersambung!");
            }
        }
    } else {
        lcdDrawFrown();
        DBG.printf("no eth or wifi is available\r\n");
        TFT.locate(0,200);
        TFT.printf("                              ");
        TFT.locate(10,200);
        TFT.printf("Gagal! Tolong restart EMMA");
    }
}
void emmaModeRegister(void) {
    bool emmaGetRegKey = false;
    bool emmaRegistered = false;
    char connBody[256];
    char s[512];
    char r[256];
    int connBodyLen;
    int connPort;
    int loop = 0;
    string connData;
    string connHost;
    string str;
    string regKey;
    Timer t;
    
    TFT.locate(0,0);
    TFT.printf(" Mohon tunggu...");
    
    //check connected interface
    isEthConnected();
    if(!ethConnected) {
        isWiFiConnected();
    }
    if(!ethConnected && !wifiConnected) {
        isGprsConnected();
    }
    
    DBG.printf("ethConnected:%d\r\n",ethConnected);
    DBG.printf("wifiConnected:%d\r\n",wifiConnected);
    DBG.printf("gprsConnected:%d\r\n",gprsConnected);
    
    if(ethConnected) {
        DBG.printf("emmaModeRegister - eth\r\n");
        wait(2);
        //TFT.locate(0,0);
        //TFT.printf("                                             ");
        //TFT.locate(0,0);
        //TFT.printf(" emmaModeRegister");
        
        //set connBody, connHost, connPort, connData
        connBodyLen = sprintf(connBody,"{\"uid\":\"%s\",\"hmac\":\"%s\"}",emmaUID.c_str(),hmac.c_str());
        
        if(useProxy) {
            DBG.printf("use proxy\r\n");
            connHost = proxySERVER;
            connPort = proxyPORT;
            for(int i=0; i<sizeof(s); i++) {
                s[i]=0; }
            sprintf(s,"POST http://%s:%d/%s/api/controller/register HTTP/1.0\nHost: %s\nContent-Length: %d\n\n%s\r\n\r\n",restSERVER.c_str(),restPORT,appNAME.c_str(),restSERVER.c_str(),connBodyLen,connBody);
            connData = s;
        } else {
            DBG.printf("no proxy\r\n");
            connHost = restSERVER;
            connPort = restPORT;
            for(int i=0; i<sizeof(s); i++) {
                s[i]=0; }
            //sprintf(s,"GET /emma/api/controller/register?uid=%s&hmac=%s HTTP/1.0\nHost: %s\r\n\r\n",emmaUID.c_str(),hmac.c_str(),restSERVER.c_str());
            //sprintf(s,"POST /emma/api/controller/register HTTP/1.0\nHost: %s\nContent-Length: 76\n\n{\"uid\":\"%s\",\"hmac\":\"%s\"}\r\n\r\n",restSERVER.c_str(),emmaUID.c_str(),hmac.c_str());
            sprintf(s,"POST /%s/api/controller/register HTTP/1.0\nHost: %s\nContent-Length: %d\n\n%s\r\n\r\n",appNAME.c_str(),restSERVER.c_str(),connBodyLen,connBody);
            connData = s;
        }
        
        //register
        while(!emmaGetRegKey) {
            //DBG.printf("post:%s\r\n",s);
            str.clear();
            str = ethREST(connHost,connPort,connData);
            DBG.printf("rsp reg:%s\r\n",str.c_str());

            //check and save settings
            if(str.find("[") != std::string::npos && str.find("]") != std::string::npos) {
                str.erase(str.begin(),str.begin()+str.find("[")+1);
                str.erase(str.begin()+str.find("]"),str.end());
        
                MbedJSONValue jsonValue;
                parse(jsonValue,str.c_str());
    
                char *parameter[4] = {"mqttDOMAIN","mqttKEY","mqttSECRET","registrationKey"};
    
                //save mqtt parameter
                writeSetting(parameter[0],"()");    //sd card need to be initialized
                for(int i=0; i<3; i++) {
                    if(jsonValue.hasMember(parameter[i])) {
                        string val = jsonValue[parameter[i]].get<std::string>();
                        int st = writeSetting(parameter[i],val.c_str());
                        if(st) {
                            DBG.printf("%s: %s is saved\r\n",parameter[i],val.c_str());
                        } else {
                            DBG.printf("%s is not saved\r\n",parameter[i]);
                        }
                    }
                }
        
                //get registrationKey
                if(jsonValue.hasMember(parameter[3])) {
                    string val = jsonValue[parameter[3]].get<std::string>();
                    if(val.find("(") != std::string::npos && val.find(")") != std::string::npos) {
                        val.erase(val.begin(),val.begin()+val.find("(")+1);
                        val.erase(val.begin()+val.find(")"),val.end());
                        regKey = val;
                        DBG.printf("%s: %s\r\n",parameter[3],regKey.c_str());
                        
                        //TFT.locate(0,20);
                        //TFT.printf(" %s: %s\r\n",parameter[3],regKey.c_str());
                        TFT.cls();
                        TFT.locate(5,5);
                        TFT.set_font((unsigned char*) Lato19x19);
                        TFT.printf(" Input kode & tunggu ya...");
                        TFT.locate(100,100);
                        TFT.set_font((unsigned char*) LatoBlack39x38);
                        TFT.printf("%s",regKey.c_str());
                        TFT.fillarc(165,120,90,10,0,360,Green);
                        
                        emmaGetRegKey = true;
                    }
                }
            }
        }
        
        //calculate hmac
        //for(int i=0; i<sizeof(r); i++) {
        //    r[i]=0; }
        sprintf(r,"emma-%s-%s",emmaUID.c_str(),regKey.c_str());
        hmac = calculateMD5(r);
        DBG.printf("hmac:%s\r\n",hmac.c_str());
        
        //set connBody and connData
        connBodyLen = sprintf(connBody,"{\"uid\":\"%s\",\"registrationKey\":\"%s\",\"hmac\":\"%s\"}",emmaUID.c_str(),regKey.c_str(),hmac.c_str());
        
        if(useProxy) {
            DBG.printf("use proxy\r\n");
            for(int i=0; i<sizeof(s); i++) {
                s[i]=0; }
            sprintf(s,"POST http://%s:%d/%s/api/controller/verify HTTP/1.0\nHost: %s\nContent-Length: %d\n\n%s\r\n\r\n",restSERVER.c_str(),restPORT,appNAME.c_str(),restSERVER.c_str(),connBodyLen,connBody);
            connData = s;
        } else {
            DBG.printf("no proxy\r\n");
            for(int i=0; i<sizeof(s); i++) {
                s[i]=0; }
            //sprintf(s,"GET /emma/api/controller/verify?uid=%s&registrationKey=%s&hmac=%s HTTP/1.0\nHost: %s\r\n\r\n",emmaUID.c_str(),regKey.c_str(),hmac.c_str(),restSERVER.c_str());
            sprintf(s,"POST /%s/api/controller/verify HTTP/1.0\nHost: %s\nContent-Length: %d\n\n%s\r\n\r\n",appNAME.c_str(),restSERVER.c_str(),connBodyLen,connBody);
            connData = s;
        }
        
        //verify registration
        TFT.set_font((unsigned char*) Lato19x19);
        while(!emmaRegistered && loop < 12){
            str.clear();
            str = ethREST(connHost,connPort,connData);
            DBG.printf("rsp vrf:%s\r\n",str.c_str());
            
            //TFT.locate(0,200);
            //TFT.printf("                              ");
            //TFT.locate(10,200);
            //TFT.printf(" wait:%d\r\n",loop);
            TFT.fillarc(165,120,90,10,0,(loop*30)+30,colorDarkGray);
                
            //check verification
            if(str.find("[") != std::string::npos && str.find("]") != std::string::npos) {
                str.erase(str.begin(),str.begin()+str.find("[")+1);
                str.erase(str.begin()+str.find("]"),str.end());
                    
                MbedJSONValue jsonValue;
                parse(jsonValue,str.c_str());
                if(jsonValue.hasMember("user")) {
                    string val = jsonValue["user"].get<std::string>();
                    DBG.printf("%s is registered\r\n",val.c_str());
                    TFT.cls();
                    TFT.locate(5,5);
                    TFT.printf(" %s is registered\r\n",val.c_str());
                    emmaRegistered = true;
                }
            }
            wait(5);
            loop++;
        }
            
        //check whether registration success
        TFT.cls();
        if(emmaRegistered) {
            DBG.printf("registration successful\r\n");
            lcdDrawSmile();
            TFT.locate(0,200);
            TFT.printf("                              ");
            TFT.locate(10,200);
            TFT.printf("Sukses! Tolong restart EMMA");
        } else {
            DBG.printf("registration unsuccessful\r\n");
            lcdDrawFrown();
            TFT.locate(0,200);
            TFT.printf("                              ");
            TFT.locate(10,200);
            TFT.printf("Gagal! Tolong restart EMMA");
        }
        while(1);
        
    } else if(wifiConnected) {
        DBG.printf("emmaModeRegister - wifi\r\n");
        
        _ESP.printf("MODE=B");
        wait(1);
        while(!esp.ready());
        
        //set connHost, connPort
        if(useProxy) {
            connHost = proxySERVER;
            connPort = proxyPORT;
        } else {
            connHost = restSERVER;
            connPort = restPORT;
        }
        //TFT.locate(0,0);
        //TFT.printf(" emmaModeRegister");
        
        //rest begin
        if(!rest.begin(connHost.c_str(),connPort,false)) {
            DBG.printf("EMMA: fail to setup rest");
            TFT.locate(0,20);
            TFT.printf(" fail setup connection");
            TFT.locate(0,40);
            TFT.printf(" check your wifi connection or");
            TFT.locate(0,60);
            TFT.printf(" you should setup proxy!");
            while(1);    
        }
        //wifiConnected = true;   //with custom firmware, wifi module should connect automatically
        
        //esp.process();
        //check proxy
        if(useProxy) {
            sprintf(r,"http://%s:%d/%s/api/controller/register",restSERVER.c_str(),restPORT,appNAME.c_str());
        } else {
            sprintf(r,"/%s/api/controller/register",appNAME.c_str());
        }
         
        //register
        while(!emmaGetRegKey) {
            sprintf(s,"{\"uid\":\"%s\",\"hmac\":\"%s\"}",emmaUID.c_str(),hmac.c_str());

            rest.post(r,s);
            //for(int i=0; i<sizeof(s); i++) {
            //    s[i]=0; }
            rest.getResponse(s,sizeof(s));
            DBG.printf("rsp reg:%s\r\n",s);

            //check and save settings
            str = s;
            if(str.find("[") != std::string::npos && str.find("]") != std::string::npos) {
                str.erase(str.begin(),str.begin()+str.find("[")+1);
                str.erase(str.begin()+str.find("]"),str.end());
        
                MbedJSONValue jsonValue;
                parse(jsonValue,str.c_str());
    
                char *parameter[4] = {"mqttDOMAIN","mqttKEY","mqttSECRET","registrationKey"};
    
                //save mqtt parameter
                writeSetting(parameter[0],"()");    //sd card need to be initialized
                for(int i=0; i<3; i++) {
                    if(jsonValue.hasMember(parameter[i])) {
                        string val = jsonValue[parameter[i]].get<std::string>();
                        int st = writeSetting(parameter[i],val.c_str());
                        if(st) {
                            DBG.printf("%s: %s is saved\r\n",parameter[i],val.c_str());
                        } else {
                            DBG.printf("%s is not saved\r\n",parameter[i]);
                        }
                    }
                }
        
                //get registrationKey
                if(jsonValue.hasMember(parameter[3])) {
                    string val = jsonValue[parameter[3]].get<std::string>();
                    if(val.find("(") != std::string::npos && val.find(")") != std::string::npos) {
                        val.erase(val.begin(),val.begin()+val.find("(")+1);
                        val.erase(val.begin()+val.find(")"),val.end());
                        regKey = val;
                        DBG.printf("%s: %s\r\n",parameter[3],regKey.c_str());
                            
                        //TFT.locate(0,20);
                        //TFT.printf(" %s: %s\r\n",parameter[3],regKey.c_str());
                        TFT.cls();
                        TFT.locate(5,5);
                        TFT.set_font((unsigned char*) Lato19x19);
                        TFT.printf(" Input kode & tunggu ya...");
                        TFT.locate(100,100);
                        TFT.set_font((unsigned char*) LatoBlack39x38);
                        TFT.printf("%s",regKey.c_str());
                        TFT.fillarc(165,120,90,10,0,360,Green);
                            
                        emmaGetRegKey = true;
                    }
                }
            }
            wait(1);
        }
                
        //calculate hmac
        //for(int i=0; i<sizeof(r); i++) {
        //    r[i]=0; }
        sprintf(r,"emma-%s-%s",emmaUID.c_str(),regKey.c_str());
        hmac = calculateMD5(r);
        DBG.printf("hmac:%s\r\n",hmac.c_str());
            
        //check proxy
        if(useProxy) {
            sprintf(r,"http://%s:%d/%s/api/controller/verify",restSERVER.c_str(),restPORT,appNAME.c_str());
        } else {
            sprintf(r,"/%s/api/controller/verify",appNAME.c_str());
        }
                
        //verify registration
        TFT.set_font((unsigned char*) Lato19x19);
        while(!emmaRegistered && loop < 12){
            sprintf(s,"{\"uid\":\"%s\",\"registrationKey\":\"%s\",\"hmac\":\"%s\"}",emmaUID.c_str(),regKey.c_str(),hmac.c_str());
            rest.post(r,s);
            rest.getResponse(s,sizeof(s));
            DBG.printf("rsp vrf:%s\r\n",s);
            //TFT.locate(0,200);
            //TFT.printf("                              ");
            //TFT.locate(10,200);
            //TFT.printf(" wait:%d\r\n",loop);
            TFT.fillarc(165,120,90,10,0,(loop*30)+30,colorDarkGray);
                
            //check verification
            str = s;
            if(str.find("[") != std::string::npos && str.find("]") != std::string::npos) {
                str.erase(str.begin(),str.begin()+str.find("[")+1);
                str.erase(str.begin()+str.find("]"),str.end());
                    
                MbedJSONValue jsonValue;
                parse(jsonValue,str.c_str());
                if(jsonValue.hasMember("user")) {
                    string val = jsonValue["user"].get<std::string>();
                    DBG.printf(" %s is registered\r\n",val.c_str());
                    TFT.cls();
                    TFT.locate(5,5);
                    TFT.printf(" %s is registered\r\n",val.c_str());
                    emmaRegistered = true;
                }
            }
            wait(5);
            loop++;
        }
            
        //check whether registration success
        TFT.cls();
        if(emmaRegistered) {
            DBG.printf("registration successful\r\n");
            lcdDrawSmile();
            TFT.locate(0,200);
            TFT.printf("                              ");
            TFT.locate(10,200);
            TFT.printf("Sukses! Tolong restart EMMA");
        } else {
            DBG.printf("registration unsuccessful\r\n");
            lcdDrawFrown();
            TFT.locate(0,200);
            TFT.printf("                              ");
            TFT.locate(10,200);
            TFT.printf("Gagal! Tolong restart EMMA");
        }
        while(1);
            
    } else if(gprsConnected) {
        DBG.printf("emmaModeRegister - gprs\r\n");
        
        //register
        connPort = restPORT;
        connBodyLen = sprintf(connBody,"{\"uid\":\"%s\",\"hmac\":\"%s\"}",emmaUID.c_str(),hmac.c_str());
        sprintf(s,"POST /%s/api/controller/register HTTP/1.1\nHost: %s:%d\nContent-Length: %d\n\n%s\n\n%c",appNAME.c_str(),restSERVER.c_str(),connPort,connBodyLen,connBody,26);
        
        while(!emmaGetRegKey) {
            //str = gprsREST(restSERVER,connPort,s);
            str = gprsRESTAnimate(restSERVER,connPort,s);
            DBG.printf("emmaGetRegKey:%s\r\n",str.c_str());
            
            //check and save settings
            if(str.find("[") != std::string::npos && str.find("]") != std::string::npos) {
                str.erase(str.begin(),str.begin()+str.find("[")+1);
                str.erase(str.begin()+str.find("]"),str.end());
        
                MbedJSONValue jsonValue;
                parse(jsonValue,str.c_str());
    
                char *parameter[4] = {"mqttDOMAIN","mqttKEY","mqttSECRET","registrationKey"};
    
                //save mqtt parameter
                writeSetting(parameter[0],"()");    //sd card need to be initialized
                for(int i=0; i<3; i++) {
                    if(jsonValue.hasMember(parameter[i])) {
                        string val = jsonValue[parameter[i]].get<std::string>();
                        int st = writeSetting(parameter[i],val.c_str());
                        if(st) {
                            DBG.printf("%s: %s is saved\r\n",parameter[i],val.c_str());
                        } else {
                            DBG.printf("%s is not saved\r\n",parameter[i]);
                        }
                    }
                }
        
                //get registrationKey
                if(jsonValue.hasMember(parameter[3])) {
                    string val = jsonValue[parameter[3]].get<std::string>();
                    if(val.find("(") != std::string::npos && val.find(")") != std::string::npos) {
                        val.erase(val.begin(),val.begin()+val.find("(")+1);
                        val.erase(val.begin()+val.find(")"),val.end());
                        regKey = val;
                        DBG.printf("%s: %s\r\n",parameter[3],regKey.c_str());
                            
                        //TFT.locate(0,20);
                        //TFT.printf(" %s: %s\r\n",parameter[3],regKey.c_str());
                        TFT.cls();
                        TFT.locate(5,5);
                        TFT.set_font((unsigned char*) Lato19x19);
                        TFT.printf(" Input kode & tunggu ya...");
                        TFT.locate(100,100);
                        TFT.set_font((unsigned char*) LatoBlack39x38);
                        TFT.printf("%s",regKey.c_str());
                        TFT.fillarc(165,120,90,10,0,360,Green);
                            
                        emmaGetRegKey = true;
                    }
                }
            }
            wait(1);   
        }
        
        //calculate hmac
        sprintf(r,"emma-%s-%s",emmaUID.c_str(),regKey.c_str());
        hmac = calculateMD5(r);
        DBG.printf("hmac:%s\r\n",hmac.c_str());
        
        //verify registration
        TFT.set_font((unsigned char*) Lato19x19);
        connBodyLen = sprintf(connBody,"{\"uid\":\"%s\",\"registrationKey\":\"%s\",\"hmac\":\"%s\"}",emmaUID.c_str(),regKey.c_str(),hmac.c_str());
        sprintf(s,"POST /%s/api/controller/verify HTTP/1.1\nHost: %s:%d\nContent-Length: %d\n\n%s\n\n%c",appNAME.c_str(),restSERVER.c_str(),connPort,connBodyLen,connBody,26);
        while(!emmaRegistered && loop < 12) {
            str = gprsREST(restSERVER,connPort,s);
            DBG.printf("rsp vrf:%s\r\n",str.c_str());
            //TFT.locate(0,200);
            //TFT.printf("                              ");
            //TFT.locate(10,200);
            //TFT.printf(" wait:%d\r\n",loop);
            TFT.fillarc(165,120,90,10,0,(loop*30)+30,colorDarkGray);
            
            //check verification
            if(str.find("[") != std::string::npos && str.find("]") != std::string::npos) {
                str.erase(str.begin(),str.begin()+str.find("[")+1);
                str.erase(str.begin()+str.find("]"),str.end());
                    
                MbedJSONValue jsonValue;
                parse(jsonValue,str.c_str());
                if(jsonValue.hasMember("user")) {
                    string val = jsonValue["user"].get<std::string>();
                    DBG.printf(" %s is registered\r\n",val.c_str());
                    TFT.cls();
                    TFT.locate(5,5);
                    TFT.printf(" %s is registered\r\n",val.c_str());
                    emmaRegistered = true;
                }
            }
            wait(5);
            loop++;    
        }
        
        //check whether registration success
        TFT.cls();
        if(emmaRegistered) {
            DBG.printf("registration successful\r\n");
            lcdDrawSmile();
            TFT.locate(0,200);
            TFT.printf("                              ");
            TFT.locate(10,200);
            TFT.printf("Sukses! Tolong restart EMMA");
        } else {
            DBG.printf("registration unsuccessful\r\n");
            lcdDrawFrown();
            TFT.locate(0,200);
            TFT.printf("                              ");
            TFT.locate(10,200);
            TFT.printf("Gagal! Tolong restart EMMA");
        }
        while(1);
        
    } else {
        DBG.printf("no eth, wifi, or gprs is connected\r\n");
        //TFT.locate(0,60);
        //TFT.printf(" no iface connected. please restart.\r\n");
        TFT.cls();
        lcdDrawFrown();
        TFT.locate(10,170);
        TFT.printf("Tidak ada interface");
        TFT.locate(10,200);
        TFT.printf("Tolong restart EMMA");
    }
}

void emmaModeOperation(void) {
    //char mqttClientId[32];
    char connBody[256];
    char p[64];
    char q[32];
    char r[32];
    char s[4096];
    int connBodyLen;
    int connPort;
    int loop=0;
    int trial=0;
    string hmacTime;
    string hmacCmd;
    string str;
    time_t seconds;
    Timer t;
    Timer tAlert;
    Timer tPanelEnergy;
    Timer tPanel;
    Timer tNodes;
    
    TFT.locate(0,0);
    TFT.printf(" Mohon tunggu...");
    
    //check connected interface
    isEthConnected();
    if(!ethConnected) {
        isWiFiConnected();
    }
    if(!ethConnected && !wifiConnected) {
        isGprsConnected();
    }
    DBG.printf("ethConnected:%d\r\n",ethConnected);
    DBG.printf("wifiConnected:%d\r\n",wifiConnected);
    DBG.printf("gprsConnected:%d\r\n",gprsConnected);
    
    //TFT.locate(0,0);
    //TFT.printf(" emmaModeOperation");
    
    //TFT.locate(0,20);
    //TFT.printf(" Interface:");
    
    TFT.cls();
    TFT.locate(0,0);
    if(ethConnected) {
        TFT.printf(" ETH");       
    } else if(wifiConnected) {
        TFT.printf(" WiFi");
    } else if(gprsConnected) {
        TFT.printf(" GPRS");    
    } else {
        TFT.printf("N/A");    
    }
    
    //set ade7758 parameter
    ADE.begin();    
    ADE.writeRMSOffset(AIRMSOFFSET, BIRMSOFFSET, CIRMSOFFSET, AVRMSOFFSET, BVRMSOFFSET, CVRMSOFFSET);    
    ADE.write16bits(AWG, 0);
    ADE.write16bits(BWG, 0);
    ADE.write16bits(CWG, 0);
    ADE.write16bits(AVAG, 0);
    ADE.write16bits(BVAG, 0);
    ADE.write16bits(CVAG, 0);
    
    if(ethConnected) {
        DBG.printf("emmaModeOperation - eth\r\n");
        
        //new log indicator
        seconds = time(NULL);
        strftime(q, 32, "%Y-%m-%d %H:%M:%S",localtime(&seconds));
        DBG.printf("newLog:%d\r\n",writeLog(q,"++++++++++Ethernet++++++++++"));
        
        //check firmware update
        
        //execute last state of switches on board
        
        //get alert threshold from server
        connBodyLen = sprintf(connBody,"{\"uid\":\"%s\",\"hmac\":\"%s\"}",emmaUID.c_str(),hmac.c_str());
        sprintf(s,"POST /%s/api/controller/threshold HTTP/1.0\nHost: %s\nContent-Length:%d\n\n%s\r\n\r\n",appNAME.c_str(),restSERVER.c_str(),connBodyLen,connBody);
        connPort = restPORT;
        str.clear();
        str = ethREST(restSERVER,connPort,s);
        
        if(str.rfind("[{\"vrmsTHL\"") != std::string::npos) {
            DBG.printf("get threshold from server\r\n");
            str.erase(str.begin(),str.begin()+str.rfind("[{\"vrmsTHL\"")+1);
            str.erase(str.begin()+str.rfind("}]")+1,str.end());
            //DBG.printf("strCrop:%s\r\n",str.c_str());
            
            MbedJSONValue jsonValue;
            parse(jsonValue,str.c_str());
            char *parameter[4] = {"vrmsTHL","vrmsTHH","wattTHL","wattTHH"};
            
            //check whether threshold valid
            bool validTh = true;
            for(int i=0; i<4; i++) {
                validTh = validTh && jsonValue.hasMember(parameter[i]);
            }    
            DBG.printf("threshold validity:%d\r\n",validTh);
            
            if(validTh) {
                vrmsTHL = jsonValue[parameter[0]].get<int>();
                vrmsTHH = jsonValue[parameter[1]].get<int>();
                wattTHL = jsonValue[parameter[2]].get<int>();
                wattTHH = jsonValue[parameter[3]].get<int>();
                DBG.printf("vrmsTHL:%d - vrmsTHH:%d - wattTHL:%d - wattTHH:%d\r\n",vrmsTHL,vrmsTHH,wattTHL,wattTHH);
            }
            
        } else {
            DBG.printf("no threshold from server\r\n");    
        }
        
        //get list of nodes from server
        connBodyLen = sprintf(connBody,"{\"uid\":\"%s\",\"hmac\":\"%s\"}",emmaUID.c_str(),hmac.c_str());
        sprintf(s,"POST /%s/api/controller/wifinodes HTTP/1.0\nHost: %s\nContent-Length:%d\n\n%s\r\n\r\n",appNAME.c_str(),restSERVER.c_str(),connBodyLen,connBody);
        connPort = restPORT;
        str.clear();
        str = ethREST(restSERVER,connPort,s);
        //DBG.printf("str:%s\r\n",str.c_str());
        
        if(str.rfind("[{\"type\"") != std::string::npos) {
            DBG.printf("get nodes from server\r\n");
            str.erase(str.begin(),str.begin()+str.rfind("[{\"type\""));
            str.erase(str.begin()+str.rfind("}]")+2,str.end());
            
            MbedJSONValue jsonValue;
            parse(jsonValue,str.c_str());
            char *parameter[3] = {"type","mac","ip"};
            
            TFT.locate(0,40);
            TFT.printf("                                        ");
            TFT.locate(0,40);
            TFT.printf("get %d nodes from server",jsonValue.size());
            wait(0.5);
            TFT.locate(0,40);
            TFT.printf("                                        ");
            
            //check whether nodes valid
            bool validNodes = true;
            for(int i=0; i<jsonValue.size(); i++) {
                for(int j=0; j<3; j++) {
                    validNodes = validNodes && jsonValue[i].hasMember(parameter[j]);
                }    
            }
            DBG.printf("nodes validity:%d\r\n",validNodes);
            
            if(validNodes) {
                for(int i=0; i<jsonValue.size(); i++) {
                    int typeValue = jsonValue[i][parameter[0]].get<int>();
                    string macValue = jsonValue[i][parameter[1]].get<std::string>();
                    string ipValue = jsonValue[i][parameter[2]].get<std::string>();
                    nodes[i].type = typeValue;
                    nodes[i].macAddr = macValue;
                    nodes[i].ipAddr = ipValue;
                    DBG.printf("nodes[%d]type:%d\r\n",i,nodes[i].type);
                    DBG.printf("nodes[%d]mac:%s\r\n",i,nodes[i].macAddr.c_str());
                    DBG.printf("nodes[%d]ip:%s\r\n",i,nodes[i].ipAddr.c_str());
                }
            }
            
        } else {
            DBG.printf("no nodes from server\r\n");    
        }
        
        //define thread
        osThreadDef(energyThread, osPriorityBelowNormal, (8*DEFAULT_STACK_SIZE));
        //create thread
        osThreadCreate(osThread(energyThread),NULL);
        
        tAlert.start();
        tPanelEnergy.start();
        tPanel.start();
        tNodes.start();
        wait(1);
        while(1) {
            checkVoltagePower();
            
            //set allowAlertXxxx to enable controller send alert
            if(tAlert.read() > 900.0f) {    //900.0f is 15 minutes
                allowAlertAVrms = true;
                allowAlertAWatt = true;
                allowAlertBVrms = true;
                allowAlertBWatt = true;
                allowAlertCVrms = true;
                allowAlertCWatt = true;
                tAlert.reset();
            }
            
            //panelEnergy, panelVoltage, and panelPower
            if(tPanelEnergy.read() > 30.0f) {
                DBG.printf("[%d]WattHR for each phase: %.2f, %.2f, %.2f\r\n", loop, AWattHr, BWattHr, CWattHr);
                //TFT.locate(0,60);
                //TFT.printf("                                                  ");
                //TFT.locate(0,60);
                //TFT.printf("[%d]WHR: %.1f, %.1f, %.1f", loop, AWattHr, BWattHr, CWattHr);
                
                DBG.printf("VRMS for each phase: %.2f, %.2f, %.2f\r\n", AVrms, BVrms, CVrms);
                //TFT.locate(0,80);
                //TFT.printf("                                                  ");
                //TFT.locate(0,80);
                //TFT.printf("VRMS: %.1f, %.1f, %.1f", AVrms, BVrms, CVrms);
                
                DBG.printf("Watt for each phase: %.2f, %.2f, %.2f\r\n", AWatt, BWatt, CWatt);
                //TFT.locate(0,100);
                //TFT.printf("                                                  ");
                //TFT.locate(0,100);
                //TFT.printf("Watt: %.1f, %.1f, %.1f", AWatt, BWatt, CWatt);
                
                //display energy and temp
                TFT.locate(45,80);
                TFT.printf("Energy");
                TFT.fillarc(80, 120, 70, 10, 0, 360, colorLightGreen);
                TFT.fillarc(80, 120, 70, 10, (loop%12)*30, (loop%12)*30+30, colorDarkGray);
                TFT.locate(40,110);
                TFT.printf("%.1f kWh",AWattHr+BWattHr+CWattHr);
        
                TFT.locate(210,80);
                TFT.printf("Temp");
                TFT.fillarc(240, 120, 70, 10, 0, 360, colorLightGreen);
                TFT.locate(215,110);
                TFT.printf("%d C",panelTemp);
                
                if(newEnergyData) {
                    //for(int i=1; i<4; i++) {
                    for(int i=1; i<(powerPHASE+1); i++) {
                        DBG.printf("sending channel: %d\r\n",i);
                        if(i==1){
                            XWattHr = AWattHr;
                            XVrms = AVrms;
                            XWatt = AWatt;    
                        } else if(i==2) {
                            XWattHr = BWattHr;
                            XVrms = BVrms;
                            XWatt = BWatt;
                        } else {
                            XWattHr = CWattHr;
                            XVrms = CVrms;
                            XWatt = CWatt;
                        }
                        
                        if(XWattHr != 0.0f) {
                            seconds = time(NULL);
                            strftime(q, 32, "%Y-%m-%d %H:%M:%S",localtime(&seconds));
                        
                            sprintf(p,"emma-%s-%s",emmaUID.c_str(),q);   
                            hmacTime = calculateMD5(p);
                            
                            connBodyLen = sprintf(connBody,"{\"uid\":\"%s\",\"hmac\":\"%s\",\"time\":\"%s\",\"energy\":%.2f,\"voltage\":%.2f,\"power\":%.2f}",
                            emmaUID.c_str(),hmacTime.c_str(),q,XWattHr,XVrms,XWatt);
                            sprintf(s,"POST /%s/api/controller/energy/%d HTTP/1.0\nHost:%s\nContent-Length:%d\n\n%s\r\n\r\n",appNAME.c_str(),i,restSERVER.c_str(),connBodyLen,connBody);
                            
                            //DBG.printf("dataEnergy:\r\n%s\r\n",connBody);
                            
                            connPort = restPORT;
                            str.clear();
                            str = ethREST(restSERVER,connPort,s);
                            //DBG.printf("str:%s\r\n",str.c_str());
                            
                            if(str.find("\"status\":\"success\"") != std::string::npos) {
                                //logging purpose
                                seconds = time(NULL);
                                strftime(q, 32, "%Y-%m-%d %H:%M:%S",localtime(&seconds));
                                DBG.printf("logPE:%d\r\n",writeLog(q,"sendEnergyData success"));
                            
                                DBG.printf("send channel: %d success\r\n",i);
                                TFT.foreground(Green);
                                TFT.locate(0,200);
                                TFT.printf("                                        ");
                                TFT.locate(0,200);
                                TFT.printf(" send ch%d success",i);
                                wait(1);
                                TFT.locate(0,200);
                                TFT.printf("                                        ");
                                TFT.foreground(White);
                            } else {
                                //logging purpose
                                seconds = time(NULL);
                                strftime(q, 32, "%Y-%m-%d %H:%M:%S",localtime(&seconds));
                                DBG.printf("logPE:%d\r\n",writeLog(q,"sendEnergyData failed"));
                                
                                DBG.printf("send channel: %d failed\r\n",i);
                                TFT.foreground(Red);
                                TFT.locate(0,200);
                                TFT.printf("                                        ");
                                TFT.locate(0,200);
                                TFT.printf(" send ch%d failed",i);
                                wait(1);
                                TFT.locate(0,200);
                                TFT.printf("                                        ");
                                TFT.foreground(White);    
                            }
                        }
                    }
                    newEnergyData = false;
                }
                
                tPanelEnergy.reset();
                loop++;    
            }
            
            //panel environment
            if(tPanel.read() > 900.0f) {    //900.0f is 15 minutes
                int dTemp=0;
                int dHum=0;
                int dGas=0;
                
                DBG.printf("getPanelEnvironment\r\n");
                
                //get environment sensor
                trial=0;
                while(1) {
                    if(trial>=2) {  //two times trial
                        break;
                    }
                    if(d.readData() == DHT11::OK) {
                        dTemp = d.readTemperature();
                        panelTemp = dTemp;
                        dHum = d.readHumidity();
                        break;    
                    }
                    trial++;
                    wait(3);    
                }
                
                //send environment sensor
                if(dTemp!=0 && dHum!=0) {
                    seconds = time(NULL);
                    strftime(q, 32, "%Y-%m-%d %H:%M:%S",localtime(&seconds));
                
                    //calculate hmacTime
                    sprintf(p,"emma-%s-%s",emmaUID.c_str(),q);   
                    hmacTime = calculateMD5(p);
                
                    connBodyLen = sprintf(connBody,"{\"uid\":\"%s\",\"hmac\":\"%s\",\"time\":\"%s\",\"temp\":%d,\"hum\":%d,\"gas\":%d}",
                    emmaUID.c_str(),hmacTime.c_str(),q,dTemp,dHum,dGas);
                    sprintf(s,"POST /%s/api/controller/environment HTTP/1.0\nHost:%s\nContent-Length:%d\n\n%s\r\n\r\n",appNAME.c_str(),restSERVER.c_str(),connBodyLen,connBody);
                    
                    //DBG.printf("dataEnvironment:\r\n%s\r\n",s);
                    
                    connPort = restPORT;
                    str.clear();
                    str = ethREST(restSERVER,connPort,s);
                    //DBG.printf("str:%s\r\n",str.c_str());
                    
                    if(str.find("\"status\":\"success\"") != std::string::npos) {
                        //logging purpose
                        seconds = time(NULL);
                        strftime(q, 32, "%Y-%m-%d %H:%M:%S",localtime(&seconds));
                        DBG.printf("logPEnv:%d\r\n",writeLog(q,"sendPanelEnv success"));
                        DBG.printf("send panel environment success\r\n");
                    } else {
                        //logging purpose
                        seconds = time(NULL);
                        strftime(q, 32, "%Y-%m-%d %H:%M:%S",localtime(&seconds));
                        DBG.printf("logPEnv:%d\r\n",writeLog(q,"sendPanelEnv failed"));
                        DBG.printf("send panel environment failed\r\n");
                    }
                }
                tPanel.reset();
            }
            
            //node temp
            if(tNodes.read() > 60.0f) {    //900 is 15 minutes
                DBG.printf("getNodesTemperature\r\n");
                
                for(int i=0; i<NODES_MAX; i++) {
                    if(!nodes[i].ipAddr.empty() && nodes[i].type == 1) {
                        //get node's temp
                        string temp;
                        str.clear();
                        str = ethREST(nodes[i].ipAddr,REMOTE_TCP_PORT,"<?xml version=\"1.0\" encoding=\"utf-8\"?><app_cmd cmd=\"2\"/>\r\n");
                        //DBG.printf("str:%s\r\n",str.c_str());

                        if(str.find("200 OK")) {
                            if(str.rfind("temp=") != std::string::npos) {
                                str.erase(str.begin(),str.begin()+str.rfind("temp=")+6);
                                str.erase(str.begin()+str.find("\""),str.end());
                                temp = str;
                            } else {
                                temp = "0"; //connect to node, but receive none
                            }
                        } else {
                            temp = "0";     //not connected to node
                        }
                        DBG.printf("nodeTemp[%d]:%s\r\n",i,temp.c_str());
                        
                        //send node's temp
                        if(temp != "0") {
                            seconds = time(NULL);
                            strftime(q, 32, "%Y-%m-%d %H:%M:%S",localtime(&seconds));
                        
                            //calculate hmacTime
                            sprintf(p,"emma-%s-%s",emmaUID.c_str(),q);   
                            hmacTime = calculateMD5(p);
                            
                            connBodyLen = sprintf(connBody,"{\"uid\":\"%s\",\"hmac\":\"%s\",\"time\":\"%s\",\"mac\":%s,\"value\":%s}",
                            emmaUID.c_str(),hmacTime.c_str(),q,nodes[i].macAddr.c_str(),temp.c_str());
                            sprintf(s,"POST /%s/api/controller/nodetemp HTTP/1.0\nHost:%s\nContent-Length:%d\n\n%s\r\n\r\n",appNAME.c_str(),restSERVER.c_str(),connBodyLen,connBody);
                    
                            //DBG.printf("dataNodeTemp:\r\n%s\r\n",s);
                            
                            connPort = restPORT;
                            str.clear();
                            str = ethREST(restSERVER,connPort,s);
                            //DBG.printf("str:%s\r\n",str.c_str());
                            
                            if(str.find("\"status\":\"success\"") != std::string::npos) {
                                DBG.printf("send nodeTemp success\r\n");
                            } else {
                                DBG.printf("send nodeTemp failed\r\n");
                            }
                        }
                    }    
                }
                tNodes.reset();
            }
            
            //command
            connBodyLen = sprintf(connBody,"{\"uid\":\"%s\",\"hmac\":\"%s\"}",emmaUID.c_str(),hmac.c_str());
            sprintf(s,"POST /%s/api/controller/command HTTP/1.0\nHost: %s\nContent-Length:%d\n\n%s\r\n\r\n",appNAME.c_str(),restSERVER.c_str(),connBodyLen,connBody);
            connPort = restPORT;
            str = ethREST(restSERVER,connPort,s);
            //DBG.printf("str:%s\r\n",str.c_str());
            
            if(str.rfind("[{\"from\"") != std::string::npos) {
                str.erase(str.begin(),str.begin()+str.rfind("[{\"from\""));
                if(str.find("[{") != std::string::npos && str.rfind("}]") != std::string::npos) {
                    str.erase(str.begin(),str.begin()+str.find("[{"));
                    str.erase(str.begin()+str.rfind("}]")+2,str.end());
                }
                //DBG.printf("newCommand:\r\n%s\r\n",str.c_str());
                TFT.locate(0,200);
                TFT.printf("                                        ");
                TFT.locate(0,200);
                TFT.printf(" newCommand");
                
                MbedJSONValue jsonValue;
                parse(jsonValue,str.c_str());
                char *parameter[5] = {"from","nType","nAddr","dType","cmd"};
                
                DBG.printf("get %d command\r\n",jsonValue.size());
                
                //processing each command
                bool validCommand;
                for(int i=0; i<jsonValue.size(); i++) {
                    //check whether command is valid
                    DBG.printf("\r\nprocessing cmd[%d]\r\n",i);
                    validCommand = true;
                    for(int j=0; j<5; j++) {
                        validCommand = validCommand && jsonValue[i].hasMember(parameter[j]);
                    }
                    DBG.printf("command validity:%d\r\n",validCommand);
                    
                    if(validCommand) {
                        string commandFrom = jsonValue[i][parameter[0]].get<std::string>();
                        string commandNType = jsonValue[i][parameter[1]].get<std::string>();
                        string commandNAddr = jsonValue[i][parameter[2]].get<std::string>();
                        string commandDType = jsonValue[i][parameter[3]].get<std::string>();
                        string commandCmd = jsonValue[i][parameter[4]].get<std::string>();
                        
                        if(commandNType == "0") {       //switch on panel controller
                            DBG.printf("command for switch\r\n");
                        }
                        else if(commandNType == "1" || commandNType == "2") {  //ir&rf remote control or wifi smart plug
                            DBG.printf("command for rc or wifi plug\r\n");
                    
                            //get index of node list based on mac address
                            int idx = NODES_INVALID;
                            for(int i=0; i<NODES_MAX; i++) {
                                if(!nodes[i].macAddr.compare(commandNAddr)) {
                                    idx = i;
                                }
                            }
                    
                            //execution process
                            string execResult = "failed";
                            if(idx != NODES_INVALID) {
                                DBG.printf("index found at %d\r\n",idx);
                        
                                string nodeCmd;
                                if(commandNType == "1"){
                                    //get cmd string based on device type and command number
                                    nodeCmd = readNodeCmd(commandDType,commandCmd);
                                    sprintf(s,"<?xml version=\"1.0\" encoding=\"utf-8\"?><app_cmd cmd=\"5\" /><app_data code=\"%s\"/>\r\n",nodeCmd.c_str());
                                } else if(commandNType == "2") {
                                    sprintf(s,"<?xml version=\"1.0\" encoding=\"utf-8\"?><app_cmd cmd=\"13\"/><app_data on-off=\"%s\"/>\r\n",commandCmd.c_str());
                                }
                                
                                if((commandNType == "1" && !nodeCmd.empty()) || commandNType == "2") {
                                    //execute command
                                    DBG.printf("executing command\r\n");
                                
                                    trial=0;
                                    while(1) {
                                        if(trial>=2) {   //two times trial
                                            DBG.printf("cmd is not executed\r\n");
                                            TFT.foreground(Red);
                                            TFT.locate(0,200);
                                            TFT.printf("                                        ");
                                            TFT.locate(0,200);
                                            TFT.printf(" cmd is not executed");
                                            wait(1);
                                            TFT.locate(0,200);
                                            TFT.printf("                                        ");
                                            TFT.foreground(White);
                                            break;    
                                        }
                                        str = ethREST(nodes[idx].ipAddr,REMOTE_TCP_PORT,s);
                                        wait(2);
                                        if(str.find("200 OK") != std::string::npos) {
                                            DBG.printf("cmd is executed\r\n");
                                            TFT.foreground(Green);
                                            TFT.locate(0,200);
                                            TFT.printf("                                        ");
                                            TFT.locate(0,200);
                                            TFT.printf(" cmd is executed");
                                            wait(1);
                                            TFT.locate(0,200);
                                            TFT.printf("                                        ");
                                            TFT.foreground(White);
                                            execResult = "success";
                                            break;    
                                        }
                                        str.clear();
                                        trial++;
                                    }
                                
                                    wait(2);
                                    //send execution result
                                    sprintf(p,"emma-%s-%s",emmaUID.c_str(),commandCmd.c_str());   
                                    hmacCmd = calculateMD5(p);
                        
                                    connBodyLen = sprintf(connBody,"{\"uid\":\"%s\",\"nType\":\"%s\",\"nAddr\":\"%s\",\"dType\":\"%s\",\"cmd\":\"%s\",\"from\":\"%s\",\"result\":\"%s\",\"hmac\":\"%s\"}",
                                    emmaUID.c_str(), commandNType.c_str(),commandNAddr.c_str(),commandDType.c_str(),commandCmd.c_str(),commandFrom.c_str(),execResult.c_str(),hmacCmd.c_str());
                            
                                    sprintf(s,"POST /%s/api/controller/result HTTP/1.0\nHost: %s\nContent-Length:%d\n\n%s\r\n\r\n",appNAME.c_str(),restSERVER.c_str(),connBodyLen,connBody);
                                    connPort = restPORT;
                    
                                    trial=0;
                                    while(1) {
                                        if(trial>=2) {   //two times trial
                                            DBG.printf("failed to send execution result\r\n");
                                            break;    
                                        }
                                        str = ethREST(restSERVER,connPort,s);
                                        wait(2);
                                        if(str.rfind("[{\"status\"") != std::string::npos) {
                                            str.erase(str.begin(),str.begin()+str.rfind("[{\"status\""));
                                            if(str.find("\"status\":\"success\"") != std::string::npos) {
                                                DBG.printf("success to send execution result\r\n");
                                                break;
                                            }
                                        }
                                        str.clear();
                                        trial++;
                                    }
                                }
                            } else {
                                TFT.foreground(Red);
                                TFT.locate(0,200);
                                TFT.printf("                                        ");
                                TFT.locate(0,200);
                                TFT.printf(" node is invalid");
                                wait(1);
                                TFT.locate(0,200);
                                TFT.printf("                                        ");
                                TFT.foreground(White);    
                            }
                        }
                    }
                }
                //clear text on lcd
                TFT.locate(0,200);
                TFT.printf("                                        ");
            }
            osDelay(5000);   
        }
    } else if(wifiConnected) {
        DBG.printf("emmaModeOperation - wifi\r\n");
        
        //new log and dbg indicator
        seconds = time(NULL);
        strftime(q, 32, "%Y-%m-%d %H:%M:%S",localtime(&seconds));
        DBG.printf("newLog:%d\r\n",writeLog(q,"++++++++++WiFi++++++++++"));
        //DBG.printf("newDbg:%d\r\n",writeDbg(q,"++++++++++++++++++++"));
    
        //do not delete code below - indicator that esp need to MODE=B and esp.ready() to work
        //_ESP.printf("MODE=B");
        //wait(1);
        //while(!esp.ready());
        
        /*
        DBG.printf("emma: setup mqtt client\r\n");
        sprintf(mqttClientId,"emma/%s",emmaUID.c_str());
    
        if(mqtt.begin(mqttClientId, mqttKEY.c_str(), mqttSECRET.c_str(), 120, 1)) {
            mqtt.connectedCb.attach(&mqttConnected);
            mqtt.disconnectedCb.attach(&mqttDisconnected);
            mqtt.connect(mqttSERVER,mqttPORT,false);
            DBG.printf("emma: success to setup mqtt\r\n");
            TFT.locate(0,40);
            TFT.printf("emma: success to setup mqtt");    
        }
        DBG.printf("emma: system started\r\n");
        */
        
        //t.start();
        //while(t.read_ms() < 5000) {
        //    esp.process();    
        //}
        //t.stop();
        //t.reset();
        
        //set ade7758 parameter
        //start set beforehand
        /*
        ADE.begin();
        
        ADE.writeRMSOffset(AIRMSOFFSET, BIRMSOFFSET, CIRMSOFFSET, AVRMSOFFSET, BVRMSOFFSET, CVRMSOFFSET);
        
        ADE.write16bits(AWG, 0);
        ADE.write16bits(BWG, 0);
        ADE.write16bits(CWG, 0);
        ADE.write16bits(AVAG, 0);
        ADE.write16bits(BVAG, 0);
        ADE.write16bits(CVAG, 0);
        */
        //end start beforehand
        
        //init rest to server
        connPort = restPORT;
        if(rest.begin(restSERVER.c_str(),connPort,false)) {
            DBG.printf("rest to server is created\r\n");
            TFT.locate(0,40);
            TFT.printf("                                        ");
            TFT.locate(0,40);
            TFT.printf("rest to server is created");
        } else {
            DBG.printf("rest to server is NOT created\r\n");
            TFT.locate(0,40);
            TFT.printf("                                        ");
            TFT.locate(0,40);
            TFT.printf("rest to server is NOT created");
        }
        
        //check firmware update

        //execute last state of switches on board
        
        _ESP.attach(&rxInterrupt,Serial::RxIrq);
        
        //get alert threshold from server
        sprintf(p,"/%s/api/controller/threshold",appNAME.c_str());
        sprintf(s,"{\"uid\":\"%s\",\"hmac\":\"%s\"}",emmaUID.c_str(),hmac.c_str());
        rest.post(p,s);
        wait(2);
        str = rxBuf;
        if(str.rfind("[{\"vrmsTHL\"") != std::string::npos) {
            DBG.printf("get threshold from server\r\n");
            str.erase(str.begin(),str.begin()+str.rfind("[{\"vrmsTHL\"")+1);
            str.erase(str.begin()+str.rfind("}]")+1,str.end());
            //DBG.printf("strCrop:%s\r\n",str.c_str());
            
            MbedJSONValue jsonValue;
            parse(jsonValue,str.c_str());
            char *parameter[4] = {"vrmsTHL","vrmsTHH","wattTHL","wattTHH"};
            
            //check whether threshold valid
            bool validTh = true;
            for(int i=0; i<4; i++) {
                validTh = validTh && jsonValue.hasMember(parameter[i]);
            }    
            DBG.printf("threshold validity:%d\r\n",validTh);
            
            if(validTh) {
                vrmsTHL = jsonValue[parameter[0]].get<int>();
                vrmsTHH = jsonValue[parameter[1]].get<int>();
                wattTHL = jsonValue[parameter[2]].get<int>();
                wattTHH = jsonValue[parameter[3]].get<int>();
                DBG.printf("vrmsTHL:%d - vrmsTHH:%d - wattTHL:%d - wattTHH:%d\r\n",vrmsTHL,vrmsTHH,wattTHL,wattTHH);
            }
            
        } else {
            DBG.printf("no threshold from server\r\n");    
        }
        
        //get list of nodes from server
        sprintf(p,"/%s/api/controller/wifinodes",appNAME.c_str());
        sprintf(s,"{\"uid\":\"%s\",\"hmac\":\"%s\"}",emmaUID.c_str(),hmac.c_str());
        rest.post(p,s);
        wait(2);
        str = rxBuf;
        if(str.rfind("[{\"type\"") != std::string::npos) {
            DBG.printf("get nodes from server\r\n");
            str.erase(str.begin(),str.begin()+str.rfind("[{\"type\""));
            str.erase(str.begin()+str.rfind("}]")+2,str.end());
            //DBG.printf("strCrop:%s\r\n",str.c_str());
            
            //start special handler
            while(1){
                if(str.find("}],") != std::string::npos) {
                    str.erase(str.begin()+str.find("}],")+1,str.begin()+str.find("}],")+2);    
                } else {
                    break;
                }
            }
            //end special handler
            
            //DBG.printf("strCrop:%s\r\n",str.c_str());
            
            MbedJSONValue jsonValue;
            parse(jsonValue,str.c_str());
            char *parameter[3] = {"type","mac","ip"};
            
            TFT.locate(0,40);
            TFT.printf("                                        ");
            TFT.locate(0,40);
            TFT.printf("get %d nodes from server",jsonValue.size());
            wait(0.5);
            TFT.locate(0,40);
            TFT.printf("                                        ");
            
            //check whether nodes valid
            bool validNodes = true;
            for(int i=0; i<jsonValue.size(); i++) {
                for(int j=0; j<3; j++) {
                    validNodes = validNodes && jsonValue[i].hasMember(parameter[j]);
                }    
            }
            DBG.printf("nodes validity:%d\r\n",validNodes);
            
            if(validNodes) {
                for(int i=0; i<jsonValue.size(); i++) {
                    int typeValue = jsonValue[i][parameter[0]].get<int>();
                    string macValue = jsonValue[i][parameter[1]].get<std::string>();
                    string ipValue = jsonValue[i][parameter[2]].get<std::string>();
                    nodes[i].type = typeValue;
                    nodes[i].macAddr = macValue;
                    nodes[i].ipAddr = ipValue;
                    DBG.printf("nodes[%d]type:%d\r\n",i,nodes[i].type);
                    DBG.printf("nodes[%d]mac:%s\r\n",i,nodes[i].macAddr.c_str());
                    DBG.printf("nodes[%d]ip:%s\r\n",i,nodes[i].ipAddr.c_str());
                }
            }
            
        } else {
            DBG.printf("no nodes from server\r\n");    
        }
        
        //get dType from server
        sprintf(p,"/%s/api/controller/devicetypes",appNAME.c_str());
        sprintf(s,"{\"uid\":\"%s\",\"hmac\":\"%s\"}",emmaUID.c_str(),hmac.c_str());
        rest.post(p,s);
        wait(2);
        str = rxBuf;
        if(str.rfind("[{\"dtype\"") != std::string::npos) {
            DBG.printf("get dTypes from server\r\n");
            str.erase(str.begin(),str.begin()+str.rfind("[{\"dtype\""));
            str.erase(str.begin()+str.rfind("}]")+2,str.end());
            
            //start special handler
            while(1){
                if(str.find("}],") != std::string::npos) {
                    str.erase(str.begin()+str.find("}],")+1,str.begin()+str.find("}],")+2);    
                } else {
                    break;
                }
            }
            //end special handler
            
            //DBG.printf("strCrop:%s\r\n",str.c_str());
            
            MbedJSONValue jsonValue;
            parse(jsonValue,str.c_str());
            char *parameter[2] = {"dtype","command"};
            
            DBG.printf("get %d dTypes from server\r\n",jsonValue.size());
            
            //check whether dType valid
            bool validDType = true;
            for(int i=0; i<jsonValue.size(); i++) {
                for(int j=0; j<2; j++) {
                    validDType = validDType && jsonValue[i].hasMember(parameter[j]);
                }
            }    
            DBG.printf("dType validity:%d\r\n",validDType);
            
            if(validDType) {
                for(int i=0; i<jsonValue.size(); i++) {
                    string dTypeValue = jsonValue[i][parameter[0]].get<std::string>();
                    int cmdLen = jsonValue[i][parameter[1]].size();
                    
                    //create dType directory
                    sprintf(p,"/sd/nodeCode/%s",dTypeValue.c_str());
                    mkdir(p,0777);
                    
                    //check whether each of dType's cmd and "ok.txt" are found
                    bool cmdComplete = true;
                    for(int j=0; j<cmdLen; j++) {
                        string cmdKey = jsonValue[i][parameter[1]][j].get<std::string>();
                        cmdComplete = cmdComplete && isExistNodeCmd(dTypeValue,cmdKey);    
                    }
                    cmdComplete = cmdComplete && isExistNodeCmd(dTypeValue,"ok");
                    DBG.printf("isCmdComplete[%s]:%d\r\n",dTypeValue.c_str(),cmdComplete);
                    
                    
                    //get cmdCode based on dType and cmdKey if cmd are not complete
                    if(!cmdComplete) {
                        for(int j=0; j<cmdLen; j++) {
                            rxBuf.clear();
                            string cmdKey = jsonValue[i][parameter[1]][j].get<std::string>();
                            sprintf(p,"/%s/api/controller/code/%s/%s",appNAME.c_str(),dTypeValue.c_str(),cmdKey.c_str());
                            sprintf(s,"{\"uid\":\"%s\",\"hmac\":\"%s\"}",emmaUID.c_str(),hmac.c_str());
                            rest.post(p,s);
                            wait(2);
                            str = rxBuf;
                            if(str.rfind("[{\"code\"") != std::string::npos) {
                                DBG.printf("get cmdCode from server\r\n");
                                str.erase(str.begin(),str.begin()+str.rfind("[{\"code\"")+1);
                                str.erase(str.begin()+str.rfind("}]")+1,str.end());
                                //DBG.printf("strCrop:%s\r\n",str.c_str());
                            
                                MbedJSONValue jsonValueA;
                                parse(jsonValueA,str.c_str());
                            
                                if(jsonValueA.hasMember("code")) {
                                    string cmdCodeValue = jsonValueA["code"].get<std::string>();
                                
                                    //write cmdCode to SD card
                                    bool wrRslt = writeNodeCmd(dTypeValue,cmdKey,cmdCodeValue);
                                    DBG.printf("write cmdKey[%s]:%d\r\n",cmdKey.c_str(),wrRslt);
                                }
                            }
                        }
                    
                        //write "ok.txt" to SD card -> indicator that codes are complete and ok
                        bool wrRslt = writeNodeCmd(dTypeValue,"ok","(ok)");
                        DBG.printf("write \"ok\":%d\r\n",wrRslt);
                    }
                }
            }
        } else {
            DBG.printf("no dType from server\r\n");    
        }
        
        /*
        //working
        DBG.printf("emma: setup mqtt client\r\n");
        sprintf(mqttClientId,"emma/%s",emmaUID.c_str());
        if(mqtt.begin(mqttClientId, mqttKEY.c_str(), mqttSECRET.c_str(), 120, 1)) {
            mqtt.connectedCb.attach(&mqttConnected);
            mqtt.disconnectedCb.attach(&mqttDisconnected);
            mqtt.connect(mqttSERVER,mqttPORT,false);
            DBG.printf("emma: success to setup mqtt\r\n");
            TFT.locate(0,40);
            TFT.printf("emma: success to setup mqtt");    
        }
        DBG.printf("emma: system started\r\n");
        
        t.start();
        while(t.read_ms() < 5000) {
            esp.process();    
        }
        t.stop();
        t.reset();
        */
        
        //disable UART2 IRQ
        NVIC_DisableIRQ(USART2_IRQn);
        
        //init rest to remotes
        for(int i=0; i<NODES_MAX; i++) {
            if(!nodes[i].ipAddr.empty()) {
                DBG.printf("restConn nodes[%d] is created\r\n",i);
                nodes[i].restConn->begin(nodes[i].ipAddr.c_str(),REMOTE_TCP_PORT,false);
                wait(1);
            } else {
                DBG.printf("restConn nodes[%d] is NOT created\r\n",i);
                wait(1);
            }
        }
        
        //enable UART2 IRQ
        NVIC_EnableIRQ(USART2_IRQn);
        
        //_ESP.attach(&rxInterrupt,Serial::RxIrq);
        
        //define thread
        osThreadDef(energyThread, osPriorityBelowNormal, (8*DEFAULT_STACK_SIZE));
        //create thread
        osThreadCreate(osThread(energyThread),NULL);
        
        tAlert.start();
        tPanelEnergy.start();
        tPanel.start();
        tNodes.start();
        wait(1);
        while(1) {
            checkRxBuffer();
            if(loop>0) {
                checkVoltagePower();
            }
            
            //whether espFreeMemory occurs
            if(espFreeMemory) {
                //logging
                seconds = time(NULL);
                strftime(q, 32, "%Y-%m-%d %H:%M:%S",localtime(&seconds));
                DBG.printf("logFreeMemory:%d\r\n",writeLog(q,rxLog.c_str()));
                
                espFreeMemory = false;    
            }
            
            //whether espDHCPClientStart occurs
            if(espDHCPClientStart) {
                //logging
                seconds = time(NULL);
                strftime(q, 32, "%Y-%m-%d %H:%M:%S",localtime(&seconds));
                DBG.printf("logDHCPClientStart:%d\r\n",writeLog(q,rxLogA.c_str()));
                
                _ESP.printf("MODE=B");
                wait(2);
                espDHCPClientStart = false;    
            }
            
            //set allowAlertXxxx to enable controller send alert
            if(tAlert.read() > 900.0f) {    //300.0f is 15 minutes
                allowAlertAVrms = true;
                allowAlertAWatt = true;
                allowAlertBVrms = true;
                allowAlertBWatt = true;
                allowAlertCVrms = true;
                allowAlertCWatt = true;
                tAlert.reset();
            }
            
            //panelEnergy, panelVoltage, and panelPower
            if(tPanelEnergy.read() > 30.0f) {
                DBG.printf("[%d]WattHR for each phase: %.2f, %.2f, %.2f\r\n", loop, AWattHr, BWattHr, CWattHr);
                //TFT.locate(0,60);
                //TFT.printf("                                                  ");
                //TFT.locate(0,60);
                //TFT.printf("[%d]WHR: %.1f, %.1f, %.1f", loop, AWattHr, BWattHr, CWattHr);
                
                DBG.printf("VRMS for each phase: %.2f, %.2f, %.2f\r\n", AVrms, BVrms, CVrms);
                //TFT.locate(0,80);
                //TFT.printf("                                                  ");
                //TFT.locate(0,80);
                //TFT.printf("VRMS: %.1f, %.1f, %.1f", AVrms, BVrms, CVrms);
                
                DBG.printf("Watt for each phase: %.2f, %.2f, %.2f\r\n", AWatt, BWatt, CWatt);
                //TFT.locate(0,100);
                //TFT.printf("                                                  ");
                //TFT.locate(0,100);
                //TFT.printf("Watt: %.1f, %.1f, %.1f", AWatt, BWatt, CWatt);
                
                //display energy and temp
                TFT.locate(45,80);
                TFT.printf("Energy");
                TFT.fillarc(80, 120, 70, 10, 0, 360, colorLightGreen);
                TFT.fillarc(80, 120, 70, 10, (loop%12)*30, (loop%12)*30+30, colorDarkGray);
                TFT.locate(40,110);
                TFT.printf("%.1f kWh",AWattHr+BWattHr+CWattHr);
        
                TFT.locate(210,80);
                TFT.printf("Temp");
                TFT.fillarc(240, 120, 70, 10, 0, 360, colorLightGreen);
                TFT.locate(215,110);
                TFT.printf("%d C",panelTemp);
                
                if(newEnergyData) {
                    //for(int i=1; i<4; i++) {
                    for(int i=1; i<(powerPHASE+1); i++) {
                        DBG.printf("sending channel: %d\r\n",i);
                        if(i==1){
                            XWattHr = AWattHr;
                            XVrms = AVrms;
                            XWatt = AWatt;    
                        } else if(i==2) {
                            XWattHr = BWattHr;
                            XVrms = BVrms;
                            XWatt = BWatt;
                        } else {
                            XWattHr = CWattHr;
                            XVrms = CVrms;
                            XWatt = CWatt;
                        }
                        
                        if(XWattHr != 0.0f) {
                        
                            sprintf(r,"/%s/api/controller/energy/%d",appNAME.c_str(),i);
                            seconds = time(NULL);
                            //for(int j=0; j<sizeof(q); j++) {
                            //    q[j]=0; }
                            strftime(q, 32, "%Y-%m-%d %H:%M:%S",localtime(&seconds));
                        
                            //calculate hmacTime
                            for(int j=0; j<sizeof(p); j++) {
                                p[j]=0; }
                            sprintf(p,"emma-%s-%s",emmaUID.c_str(),q);   
                            hmacTime = calculateMD5(p);
                        
                            sprintf(s,"{\"uid\":\"%s\",\"hmac\":\"%s\",\"time\":\"%s\",\"energy\":%.2f,\"voltage\":%.2f,\"power\":%.2f}",
                            emmaUID.c_str(),hmacTime.c_str(),q,XWattHr,XVrms,XWatt);
                            //DBG.printf("dataEnergy:\r\n%s\r\n",s);
                            rest.post(r,s);
                            wait(2);
                            if(rxBuf.find("\"status\":\"success\"") != std::string::npos) {
                                //logging purpose
                                seconds = time(NULL);
                                strftime(q, 32, "%Y-%m-%d %H:%M:%S",localtime(&seconds));
                                DBG.printf("logPE:%d\r\n",writeLog(q,"sendEnergyData success"));
                            
                                DBG.printf("send channel: %d success\r\n",i);
                                TFT.foreground(Green);
                                TFT.locate(0,200);
                                TFT.printf("                                        ");
                                TFT.locate(0,200);
                                TFT.printf(" send ch%d success",i);
                                wait(1);
                                TFT.locate(0,200);
                                TFT.printf("                                        ");
                                TFT.foreground(White);    
                            } else {
                                //logging purpose
                                seconds = time(NULL);
                                strftime(q, 32, "%Y-%m-%d %H:%M:%S",localtime(&seconds));
                                DBG.printf("logPE:%d\r\n",writeLog(q,"sendEnergyData failed"));
                                
                                DBG.printf("send channel: %d failed\r\n",i);
                                TFT.foreground(Red);
                                TFT.locate(0,200);
                                TFT.printf("                                        ");
                                TFT.locate(0,200);
                                TFT.printf(" send ch%d failed",i);
                                wait(1);
                                TFT.locate(0,200);
                                TFT.printf("                                        ");
                                TFT.foreground(White);    
                            }
                        }
                    }
                    
                    newEnergyData = false;
                }
                
                tPanelEnergy.reset();
                loop++;    
            }
            
            //panel environment
            checkRxBuffer();
            if(tPanel.read() > 900.0f) {    //900.0f is 15 minutes
                int dTemp=0;
                int dHum=0;
                int dGas=0;
                
                DBG.printf("getPanelEnvironment\r\n");
                
                //get environment sensor
                trial=0;
                while(1) {
                    if(trial>=2) {  //two times trial
                        break;
                    }
                    if(d.readData() == DHT11::OK) {
                        dTemp = d.readTemperature();
                        panelTemp = dTemp;
                        dHum = d.readHumidity();
                        break;    
                    }
                    trial++;
                    wait(3);    
                }
                
                //send environment sensor
                if(dTemp!=0 && dHum!=0) {
                    seconds = time(NULL);
                    strftime(q, 32, "%Y-%m-%d %H:%M:%S",localtime(&seconds));
                
                    //calculate hmacTime
                    for(int j=0; j<sizeof(p); j++) {
                        p[j]=0; }
                    sprintf(p,"emma-%s-%s",emmaUID.c_str(),q);   
                    hmacTime = calculateMD5(p);
                
                    sprintf(s,"{\"uid\":\"%s\",\"hmac\":\"%s\",\"time\":\"%s\",\"temp\":%d,\"hum\":%d,\"gas\":%d}",
                    emmaUID.c_str(),hmacTime.c_str(),q,dTemp,dHum,dGas);
                    //DBG.printf("dataEnvironment:\r\n%s\r\n",s);
                    sprintf(p,"/%s/api/controller/environment",appNAME.c_str());
                    rest.post(p,s);
                    //rest.post("/emma/api/controller/environment",s);  //working
                    wait(2);
                    str = rxBuf;
                    if(str.rfind("/environment") != std::string::npos) {
                        str.erase(str.begin(),str.begin()+str.rfind("/environment"));
                        if(str.find("\"status\":\"success\"") != std::string::npos) {
                            //logging purpose
                            seconds = time(NULL);
                            strftime(q, 32, "%Y-%m-%d %H:%M:%S",localtime(&seconds));
                            DBG.printf("logPEnv:%d\r\n",writeLog(q,"sendPanelEnv success"));
                            DBG.printf("send panel environment success\r\n");
                        } else {
                            //logging purpose
                            seconds = time(NULL);
                            strftime(q, 32, "%Y-%m-%d %H:%M:%S",localtime(&seconds));
                            DBG.printf("logPEnv:%d\r\n",writeLog(q,"sendPanelEnv failed"));
                            DBG.printf("send panel environment failed\r\n");
                        }
                    }
                    checkRxBuffer();
                }
                tPanel.reset();
            }
            
            //nodeTemp
            checkRxBuffer();
            if(tNodes.read() > 900.0f) {    //900 is 15 minutes
                DBG.printf("getNodesTemperature\r\n");
                
                for(int i=0; i<NODES_MAX; i++) {
                    if(!nodes[i].ipAddr.empty() && nodes[i].type == 1) {
                        //get node's temp
                        string temp;
                        nodes[i].restConn->get("/","<?xml version=\"1.0\" encoding=\"utf-8\"?><app_cmd cmd=\"2\"/>\r\n");
                        wait(2);
                        temp = rxBuf;
                        if(temp.rfind(nodes[i].ipAddr) != std::string::npos) {
                            temp.erase(temp.begin(),temp.begin()+temp.rfind(nodes[i].ipAddr));
                            if(temp.rfind("temp=") != std::string::npos) {
                                temp.erase(temp.begin(),temp.begin()+temp.rfind("temp=")+6);
                                temp.erase(temp.begin()+temp.find("\""),temp.end());
                            } else {
                                temp = "0"; //connect to node, but receive none
                            }
                        } else {
                            temp = "0";     //not connected to node
                        }
                    
                        DBG.printf("nodeTemp[%d]:%s\r\n",i,temp.c_str());
                    
                        //send node's temp
                        if(temp != "0") {
                            seconds = time(NULL);
                            strftime(q, 32, "%Y-%m-%d %H:%M:%S",localtime(&seconds));
                        
                            //calculate hmacTime
                            for(int j=0; j<sizeof(p); j++) {
                                p[j]=0; }
                            sprintf(p,"emma-%s-%s",emmaUID.c_str(),q);   
                            hmacTime = calculateMD5(p);
                        
                            sprintf(s,"{\"uid\":\"%s\",\"hmac\":\"%s\",\"time\":\"%s\",\"mac\":\"%s\",\"value\":%s}",
                            emmaUID.c_str(),hmacTime.c_str(),q,nodes[i].macAddr.c_str(),temp.c_str());
                            //DBG.printf("dataNodeTemp:\r\n%s\r\n",s);
                            sprintf(p,"/%s/api/controller/nodetemp",appNAME.c_str());
                            rest.post(p,s);
                            //rest.post("/emma/api/controller/nodetemp",s); //working
                            wait(2);
                            str = rxBuf;
                            if(str.rfind("/nodetemp") != std::string::npos) {
                                str.erase(str.begin(),str.begin()+str.rfind("/nodetemp"));
                                if(str.find("\"status\":\"success\"") != std::string::npos) {
                                    DBG.printf("send nodeTemp success\r\n");
                                } else {
                                    DBG.printf("send nodeTemp failed\r\n");
                                }
                            }
                            checkRxBuffer();
                        }
                    }    
                }
                tNodes.reset();
            }
            
            //command
            sprintf(r,"/%s/api/controller/command",appNAME.c_str());
            sprintf(s,"{\"uid\":\"%s\",\"hmac\":\"%s\"}",
            emmaUID.c_str(),hmacTime.c_str());  //INI HARUSNYA HMAC BUKAN?
            //rest.get("/emma/api/controller/command");
            rest.post(r,s);
            
            checkRxBuffer();
            if(newCommand) {
                //DBG.printf("newCommand:\r\n%s\r\n",globalCommand.c_str());
                TFT.locate(0,200);
                TFT.printf("                                        ");
                TFT.locate(0,200);
                TFT.printf(" newCommand");
                
                MbedJSONValue jsonValue;
                parse(jsonValue,globalCommand.c_str());
                char *parameter[5] = {"from","nType","nAddr","dType","cmd"};
                
                DBG.printf("get %d command\r\n",jsonValue.size());
                
                //processing each command
                bool validCommand;
                for(int i=0; i<jsonValue.size(); i++) {
                    //check whether command is valid
                    DBG.printf("\r\nprocessing cmd[%d]\r\n",i);
                    validCommand = true;
                    for(int j=0; j<5; j++) {
                        validCommand = validCommand && jsonValue[i].hasMember(parameter[j]);
                    }
                    DBG.printf("command validity:%d\r\n",validCommand);
                    
                    if(validCommand) {
                        string commandFrom = jsonValue[i][parameter[0]].get<std::string>();
                        string commandNType = jsonValue[i][parameter[1]].get<std::string>();
                        string commandNAddr = jsonValue[i][parameter[2]].get<std::string>();
                        string commandDType = jsonValue[i][parameter[3]].get<std::string>();
                        string commandCmd = jsonValue[i][parameter[4]].get<std::string>();
                        
                        if(commandNType == "0") {       //switch on panel controller
                            DBG.printf("command for switch\r\n");
                        }
                        else if(commandNType == "1" || commandNType == "2") {  //ir&rf remote control or wifi smart plug
                            DBG.printf("command for rc or wifi plug\r\n");
                            //get node ip address based on node mac address
                            //string nodeIP;
                            //nodeIp = readNodeIP(commandNAddr);
                            //nodeIP = "192.168.2.15";
                            //DBG.printf("nodeIP: %s\r\n",nodeIP.c_str());
                    
                            //get index of node list based on mac address
                            int idx = NODES_INVALID;
                            for(int i=0; i<NODES_MAX; i++) {
                                if(!nodes[i].macAddr.compare(commandNAddr)) {
                                    idx = i;
                                }
                            }
                    
                            //execution process
                            string execResult = "failed";
                            if(idx != NODES_INVALID) {
                                DBG.printf("index found at %d\r\n",idx);
                        
                                string nodeCmd;
                                if(commandNType == "1") {
                                    //get cmd string based on device type and command number
                                    nodeCmd = readNodeCmd(commandDType,commandCmd);
                                    sprintf(s,"<?xml version=\"1.0\" encoding=\"utf-8\"?><app_cmd cmd=\"5\" /><app_data code=\"%s\"/>\r\n",nodeCmd.c_str());
                                } else if(commandNType == "2") {
                                    sprintf(s,"<?xml version=\"1.0\" encoding=\"utf-8\"?><app_cmd cmd=\"13\"/><app_data on-off=\"%s\"/>\r\n",commandCmd.c_str());    
                                }
                                
                                if((commandNType == "1" && !nodeCmd.empty()) || commandNType == "2") {
                                    //execute command
                                    DBG.printf("executing command\r\n");
                            
                                    trial=0;
                                    while(1) {
                                        rxBuf.clear();
                                        if(trial>=2) {   //two times trial
                                            DBG.printf("cmd is not executed\r\n");
                                            TFT.foreground(Red);
                                            TFT.locate(0,200);
                                            TFT.printf("                                        ");
                                            TFT.locate(0,200);
                                            TFT.printf(" cmd is not executed");
                                            wait(1);
                                            TFT.locate(0,180);
                                            TFT.printf("                                        ");
                                            TFT.foreground(White);
                                            break;    
                                        }
                                        nodes[idx].restConn->get("/",s);
                                        wait(2);
                                        if(rxBuf.find("REST: status = 200") != std::string::npos) {
                                            DBG.printf("cmd is executed\r\n");
                                            TFT.foreground(Green);
                                            TFT.locate(0,200);
                                            TFT.printf("                                        ");
                                            TFT.locate(0,200);
                                            TFT.printf(" cmd is executed");
                                            wait(1);
                                            TFT.locate(0,200);
                                            TFT.printf("                                        ");
                                            TFT.foreground(White);
                                            execResult = "success";
                                            break;    
                                        }
                                        trial++;
                                    }
                                
                                    wait(2);       
                                    //send execution result
                                    sprintf(p,"emma-%s-%s",emmaUID.c_str(),commandCmd.c_str());   
                                    hmacCmd = calculateMD5(p);
                        
                                    sprintf(s,"{\"uid\":\"%s\",\"nType\":\"%s\",\"nAddr\":\"%s\",\"dType\":\"%s\",\"cmd\":\"%s\",\"from\":\"%s\",\"result\":\"%s\",\"hmac\":\"%s\"}",
                                    emmaUID.c_str(), commandNType.c_str(),commandNAddr.c_str(),commandDType.c_str(),commandCmd.c_str(),commandFrom.c_str(),execResult.c_str(),hmacCmd.c_str());
                    
                                    trial=0;
                                    while(1) {
                                        if(trial>=2) {   //two times trial
                                            DBG.printf("failed to send execution result\r\n");
                                            break;    
                                        }
                                        sprintf(p,"/%s/api/controller/result",appNAME.c_str());
                                        rest.post(p,s);
                                        //rest.post("/emma/api/controller/result",s);   //working
                                        wait(2);
                                        str = rxBuf;
                                        if(str.rfind("/result") != std::string::npos) {
                                            str.erase(str.begin(),str.begin()+str.rfind("/result"));
                                            if(str.find("\"status\":\"success\"") != std::string::npos) {
                                                DBG.printf("success to send execution result\r\n");
                                                break;
                                            }
                                        }
                                        //checkRxBuffer();
                                        rxBuf.clear();
                                        trial++;
                                    }
                                }
                            } else {
                                TFT.foreground(Red);
                                TFT.locate(0,200);
                                TFT.printf("                                        ");
                                TFT.locate(0,200);
                                TFT.printf(" node is invalid");
                                wait(1);
                                TFT.locate(0,200);
                                TFT.printf("                                        ");
                                TFT.foreground(White);    
                            }
                        } 
                    }
                }
                //clear text on lcd
                TFT.locate(0,200);
                TFT.printf("                                        ");
                
                newCommand = false;
            }
            
            osDelay(5000);    
        }
    } else if(gprsConnected) {
        DBG.printf("emmaModeOperation - gprs\r\n");
        
        //new log indicator
        seconds = time(NULL);
        strftime(q, 32, "%Y-%m-%d %H:%M:%S",localtime(&seconds));
        DBG.printf("newLog:%d\r\n",writeLog(q,"++++++++++GPRS++++++++++"));
        
        //check firmware update
        
        //execute last state of switches on board
        
        //get alert threshold from server
        connBodyLen = sprintf(connBody,"{\"uid\":\"%s\",\"hmac\":\"%s\"}",emmaUID.c_str(),hmac.c_str());
        sprintf(s,"POST /%s/api/controller/threshold HTTP/1.0\nHost: %s\nContent-Length:%d\n\n%s\r\n\r\n",appNAME.c_str(),restSERVER.c_str(),connBodyLen,connBody);
        connPort = restPORT;
        str.clear();
        str = gprsREST(restSERVER,connPort,s);
        DBG.printf("str:%s\r\n",str.c_str());
        
        if(str.rfind("[{\"vrmsTHL\"") != std::string::npos) {
            DBG.printf("get threshold from server\r\n");
            str.erase(str.begin(),str.begin()+str.rfind("[{\"vrmsTHL\"")+1);
            str.erase(str.begin()+str.rfind("}]")+1,str.end());
            //DBG.printf("strCrop:%s\r\n",str.c_str());
            
            MbedJSONValue jsonValue;
            parse(jsonValue,str.c_str());
            char *parameter[4] = {"vrmsTHL","vrmsTHH","wattTHL","wattTHH"};
            
            //check whether threshold valid
            bool validTh = true;
            for(int i=0; i<4; i++) {
                validTh = validTh && jsonValue.hasMember(parameter[i]);
            }    
            DBG.printf("threshold validity:%d\r\n",validTh);
            
            if(validTh) {
                vrmsTHL = jsonValue[parameter[0]].get<int>();
                vrmsTHH = jsonValue[parameter[1]].get<int>();
                wattTHL = jsonValue[parameter[2]].get<int>();
                wattTHH = jsonValue[parameter[3]].get<int>();
                DBG.printf("vrmsTHL:%d - vrmsTHH:%d - wattTHL:%d - wattTHH:%d\r\n",vrmsTHL,vrmsTHH,wattTHL,wattTHH);
            }
            
        } else {
            DBG.printf("no threshold from server\r\n");    
        }
        
        //get list of nodes from server
        connBodyLen = sprintf(connBody,"{\"uid\":\"%s\",\"hmac\":\"%s\"}",emmaUID.c_str(),hmac.c_str());
        sprintf(s,"POST /%s/api/controller/wifinodes HTTP/1.0\nHost: %s\nContent-Length:%d\n\n%s\r\n\r\n",appNAME.c_str(),restSERVER.c_str(),connBodyLen,connBody);
        connPort = restPORT;
        str.clear();
        str = gprsREST(restSERVER,connPort,s);
        //DBG.printf("str:%s\r\n",str.c_str());
        
        if(str.rfind("[{\"type\"") != std::string::npos) {
            DBG.printf("get nodes from server\r\n");
            str.erase(str.begin(),str.begin()+str.rfind("[{\"type\""));
            str.erase(str.begin()+str.rfind("}]")+2,str.end());
            
            MbedJSONValue jsonValue;
            parse(jsonValue,str.c_str());
            char *parameter[3] = {"type","mac","ip"};
            
            TFT.locate(0,40);
            TFT.printf("                                        ");
            TFT.locate(0,40);
            TFT.printf("get %d nodes from server",jsonValue.size());
            wait(0.5);
            TFT.locate(0,40);
            TFT.printf("                                        ");
            
            //check whether nodes valid
            bool validNodes = true;
            for(int i=0; i<jsonValue.size(); i++) {
                for(int j=0; j<3; j++) {
                    validNodes = validNodes && jsonValue[i].hasMember(parameter[j]);
                }    
            }
            DBG.printf("nodes validity:%d\r\n",validNodes);
            
            if(validNodes) {
                for(int i=0; i<jsonValue.size(); i++) {
                    int typeValue = jsonValue[i][parameter[0]].get<int>();
                    string macValue = jsonValue[i][parameter[1]].get<std::string>();
                    string ipValue = jsonValue[i][parameter[2]].get<std::string>();
                    nodes[i].type = typeValue;
                    nodes[i].macAddr = macValue;
                    nodes[i].ipAddr = ipValue;
                    DBG.printf("nodes[%d]type:%d\r\n",i,nodes[i].type);
                    DBG.printf("nodes[%d]mac:%s\r\n",i,nodes[i].macAddr.c_str());
                    DBG.printf("nodes[%d]ip:%s\r\n",i,nodes[i].ipAddr.c_str());
                }
            }
            
        } else {
            DBG.printf("no nodes from server\r\n");    
        }
        
        //create nodes connection via wifi (we assume that when using gprs, user should provide wifi for node control)
        //init rest to remotes
        for(int i=0; i<NODES_MAX; i++) {
            if(!nodes[i].ipAddr.empty()) {
                DBG.printf("restConn nodes[%d] is created\r\n",i);
                nodes[i].restConn->begin(nodes[i].ipAddr.c_str(),REMOTE_TCP_PORT,false);
                wait(1);
            } else {
                DBG.printf("restConn nodes[%d] is NOT created\r\n",i);
                wait(1);
            }
        }
        
        _ESP.attach(&rxInterrupt,Serial::RxIrq);
        
        //define thread
        osThreadDef(energyThread, osPriorityBelowNormal, (8*DEFAULT_STACK_SIZE));
        //create thread
        osThreadCreate(osThread(energyThread),NULL);
        
        tAlert.start();
        tPanelEnergy.start();
        tPanel.start();
        tNodes.start();
        wait(1);
        while(1) {
            checkVoltagePower();  //need revision to support gprs
            
            //set allowAlertXxxx to enable controller send alert
            if(tAlert.read() > 900.0f) {    //300.0f is 15 minutes
                allowAlertAVrms = true;
                allowAlertAWatt = true;
                allowAlertBVrms = true;
                allowAlertBWatt = true;
                allowAlertCVrms = true;
                allowAlertCWatt = true;
                tAlert.reset();
            }
            
            //panelEnergy, panelVoltage, and panelPower
            if(tPanelEnergy.read() > 30.0f) {
                DBG.printf("[%d]WattHR for each phase: %.2f, %.2f, %.2f\r\n", loop, AWattHr, BWattHr, CWattHr);
                TFT.locate(0,60);
                TFT.printf("                                                  ");
                TFT.locate(0,60);
                TFT.printf("[%d]WHR: %.1f, %.1f, %.1f", loop, AWattHr, BWattHr, CWattHr);
                
                DBG.printf("VRMS for each phase: %.2f, %.2f, %.2f\r\n", AVrms, BVrms, CVrms);
                TFT.locate(0,80);
                TFT.printf("                                                  ");
                TFT.locate(0,80);
                TFT.printf("VRMS: %.1f, %.1f, %.1f", AVrms, BVrms, CVrms);
                
                DBG.printf("Watt for each phase: %.2f, %.2f, %.2f\r\n", AWatt, BWatt, CWatt);
                TFT.locate(0,100);
                TFT.printf("                                                  ");
                TFT.locate(0,100);
                TFT.printf("Watt: %.1f, %.1f, %.1f", AWatt, BWatt, CWatt);
                
                if(newEnergyData) {
                    for(int i=1; i<(powerPHASE+1); i++) {
                        DBG.printf("sending channel: %d\r\n",i);
                        if(i==1){
                            XWattHr = AWattHr;
                            XVrms = AVrms;
                            XWatt = AWatt;    
                        } else if(i==2) {
                            XWattHr = BWattHr;
                            XVrms = BVrms;
                            XWatt = BWatt;
                        } else {
                            XWattHr = CWattHr;
                            XVrms = CVrms;
                            XWatt = CWatt;
                        }
                        
                        if(XWattHr != 0.0f) {
                            seconds = time(NULL);
                            strftime(q, 32, "%Y-%m-%d %H:%M:%S",localtime(&seconds));
                        
                            sprintf(p,"emma-%s-%s",emmaUID.c_str(),q);   
                            hmacTime = calculateMD5(p);
                            
                            connBodyLen = sprintf(connBody,"{\"uid\":\"%s\",\"hmac\":\"%s\",\"time\":\"%s\",\"energy\":%.2f,\"voltage\":%.2f,\"power\":%.2f}",
                            emmaUID.c_str(),hmacTime.c_str(),q,XWattHr,XVrms,XWatt);
                            sprintf(s,"POST /%s/api/controller/energy/%d HTTP/1.0\nHost:%s\nContent-Length:%d\n\n%s\r\n\r\n",appNAME.c_str(),i,restSERVER.c_str(),connBodyLen,connBody);
                            
                            //DBG.printf("dataEnergy:\r\n%s\r\n",connBody);
                            
                            connPort = restPORT;
                            str.clear();
                            str = gprsREST(restSERVER,connPort,s);
                            //DBG.printf("str:%s\r\n",str.c_str());
                            
                            if(str.find("\"status\":\"success\"") != std::string::npos) {
                                //logging purpose
                                seconds = time(NULL);
                                strftime(q, 32, "%Y-%m-%d %H:%M:%S",localtime(&seconds));
                                DBG.printf("logPE:%d\r\n",writeLog(q,"sendEnergyData success"));
                            
                                DBG.printf("send channel: %d success\r\n",i);
                                TFT.foreground(Green);
                                TFT.locate(0,120);
                                TFT.printf("                                        ");
                                TFT.locate(0,120);
                                TFT.printf("send ch%d success",i);
                                wait(1);
                                TFT.locate(0,120);
                                TFT.printf("                                        ");
                                TFT.foreground(White);
                            } else {
                                //logging purpose
                                seconds = time(NULL);
                                strftime(q, 32, "%Y-%m-%d %H:%M:%S",localtime(&seconds));
                                DBG.printf("logPE:%d\r\n",writeLog(q,"sendEnergyData failed"));
                                
                                DBG.printf("send channel: %d failed\r\n",i);
                                TFT.foreground(Red);
                                TFT.locate(0,120);
                                TFT.printf("                                        ");
                                TFT.locate(0,120);
                                TFT.printf("send ch%d failed",i);
                                wait(1);
                                TFT.locate(0,120);
                                TFT.printf("                                        ");
                                TFT.foreground(White);    
                            }
                        }
                    }
                    newEnergyData = false;
                }
                
                tPanelEnergy.reset();
                loop++;    
            }
            
            //panel environment
            if(tPanel.read() > 900.0f) {    //900.0f is 15 minutes
                int dTemp=0;
                int dHum=0;
                int dGas=0;
                
                DBG.printf("getPanelEnvironment\r\n");
                
                //get environment sensor
                trial=0;
                while(1) {
                    if(trial>=2) {  //two times trial
                        break;
                    }
                    if(d.readData() == DHT11::OK) {
                        dTemp = d.readTemperature();
                        dHum = d.readHumidity();
                        break;    
                    }
                    trial++;
                    wait(3);    
                }
                
                //send environment sensor
                if(dTemp!=0 && dHum!=0) {
                    seconds = time(NULL);
                    strftime(q, 32, "%Y-%m-%d %H:%M:%S",localtime(&seconds));
                
                    //calculate hmacTime
                    sprintf(p,"emma-%s-%s",emmaUID.c_str(),q);   
                    hmacTime = calculateMD5(p);
                
                    connBodyLen = sprintf(connBody,"{\"uid\":\"%s\",\"hmac\":\"%s\",\"time\":\"%s\",\"temp\":%d,\"hum\":%d,\"gas\":%d}",
                    emmaUID.c_str(),hmacTime.c_str(),q,dTemp,dHum,dGas);
                    sprintf(s,"POST /%s/api/controller/environment HTTP/1.0\nHost:%s\nContent-Length:%d\n\n%s\r\n\r\n",appNAME.c_str(),restSERVER.c_str(),connBodyLen,connBody);
                    
                    //DBG.printf("dataEnvironment:\r\n%s\r\n",s);
                    
                    connPort = restPORT;
                    str.clear();
                    str = gprsREST(restSERVER,connPort,s);
                    //DBG.printf("str:%s\r\n",str.c_str());
                    
                    if(str.find("\"status\":\"success\"") != std::string::npos) {
                        //logging purpose
                        seconds = time(NULL);
                        strftime(q, 32, "%Y-%m-%d %H:%M:%S",localtime(&seconds));
                        DBG.printf("logPEnv:%d\r\n",writeLog(q,"sendPanelEnv success"));
                        DBG.printf("send panel environment success\r\n");
                    } else {
                        //logging purpose
                        seconds = time(NULL);
                        strftime(q, 32, "%Y-%m-%d %H:%M:%S",localtime(&seconds));
                        DBG.printf("logPEnv:%d\r\n",writeLog(q,"sendPanelEnv failed"));
                        DBG.printf("send panel environment failed\r\n");
                    }
                }
                tPanel.reset();
            }
            
            //nodeTemp
            checkRxBuffer();
            if(tNodes.read() > 900.0f) {    //900 is 15 minutes
                DBG.printf("getNodesTemperature\r\n");
                
                for(int i=0; i<NODES_MAX; i++) {
                    if(!nodes[i].ipAddr.empty() && nodes[i].type == 1) {
                        //get node's temp
                        string temp;
                        nodes[i].restConn->get("/","<?xml version=\"1.0\" encoding=\"utf-8\"?><app_cmd cmd=\"2\"/>\r\n");
                        wait(2);
                        temp = rxBuf;
                        if(temp.rfind(nodes[i].ipAddr) != std::string::npos) {
                            temp.erase(temp.begin(),temp.begin()+temp.rfind(nodes[i].ipAddr));
                            if(temp.rfind("temp=") != std::string::npos) {
                                temp.erase(temp.begin(),temp.begin()+temp.rfind("temp=")+6);
                                temp.erase(temp.begin()+temp.find("\""),temp.end());
                            } else {
                                temp = "0"; //connect to node, but receive none
                            }
                        } else {
                            temp = "0";     //not connected to node
                        }
                    
                        DBG.printf("nodeTemp[%d]:%s\r\n",i,temp.c_str());
                    
                        //send node's temp
                        if(temp != "0") {
                            seconds = time(NULL);
                            strftime(q, 32, "%Y-%m-%d %H:%M:%S",localtime(&seconds));
                        
                            //calculate hmacTime
                            sprintf(p,"emma-%s-%s",emmaUID.c_str(),q);   
                            hmacTime = calculateMD5(p);
                            
                            connBodyLen = sprintf(connBody,"{\"uid\":\"%s\",\"hmac\":\"%s\",\"time\":\"%s\",\"mac\":%s,\"value\":%s}",
                            emmaUID.c_str(),hmacTime.c_str(),q,nodes[i].macAddr.c_str(),temp.c_str());
                            sprintf(s,"POST /%s/api/controller/nodetemp HTTP/1.0\nHost:%s\nContent-Length:%d\n\n%s\r\n\r\n",appNAME.c_str(),restSERVER.c_str(),connBodyLen,connBody);
                    
                            //DBG.printf("dataNodeTemp:\r\n%s\r\n",s);
                            
                            connPort = restPORT;
                            str.clear();
                            str = gprsREST(restSERVER,connPort,s);
                            //DBG.printf("str:%s\r\n",str.c_str());
                            
                            if(str.find("\"status\":\"success\"") != std::string::npos) {
                                DBG.printf("send nodeTemp success\r\n");
                            } else {
                                DBG.printf("send nodeTemp failed\r\n");
                            }
                        }
                    }    
                }
                tNodes.reset();
            }
            
            //command
            connBodyLen = sprintf(connBody,"{\"uid\":\"%s\",\"hmac\":\"%s\"}",emmaUID.c_str(),hmac.c_str());
            sprintf(s,"POST /%s/api/controller/command HTTP/1.0\nHost: %s\nContent-Length:%d\n\n%s\r\n\r\n",appNAME.c_str(),restSERVER.c_str(),connBodyLen,connBody);
            connPort = restPORT;
            str = gprsREST(restSERVER,connPort,s);
            //DBG.printf("str:%s\r\n",str.c_str());
            
            if(str.rfind("[{\"from\"") != std::string::npos) {
                str.erase(str.begin(),str.begin()+str.rfind("[{\"from\""));
                if(str.find("[{") != std::string::npos && str.rfind("}]") != std::string::npos) {
                    str.erase(str.begin(),str.begin()+str.find("[{"));
                    str.erase(str.begin()+str.rfind("}]")+2,str.end());
                }
                //DBG.printf("newCommand:\r\n%s\r\n",str.c_str());
                TFT.locate(0,160);
                TFT.printf("                                        ");
                TFT.locate(0,160);
                TFT.printf("newCommand");
                
                MbedJSONValue jsonValue;
                parse(jsonValue,str.c_str());
                char *parameter[5] = {"from","nType","nAddr","dType","cmd"};
                
                DBG.printf("get %d command\r\n",jsonValue.size());
                
                //processing each command
                bool validCommand;
                for(int i=0; i<jsonValue.size(); i++) {
                    //check whether command is valid
                    DBG.printf("\r\nprocessing cmd[%d]\r\n",i);
                    validCommand = true;
                    for(int j=0; j<5; j++) {
                        validCommand = validCommand && jsonValue[i].hasMember(parameter[j]);
                    }
                    DBG.printf("command validity:%d\r\n",validCommand);
                    
                    if(validCommand) {
                        string commandFrom = jsonValue[i][parameter[0]].get<std::string>();
                        string commandNType = jsonValue[i][parameter[1]].get<std::string>();
                        string commandNAddr = jsonValue[i][parameter[2]].get<std::string>();
                        string commandDType = jsonValue[i][parameter[3]].get<std::string>();
                        string commandCmd = jsonValue[i][parameter[4]].get<std::string>();
                        
                        if(commandNType == "0") {       //switch on panel controller
                            DBG.printf("command for switch\r\n");
                        }
                        else if(commandNType == "1" || commandNType == "2") {  //ir&rf remote control or wifi smart plug
                            DBG.printf("command for rc or wifi plug\r\n");
                    
                            //get index of node list based on mac address
                            int idx = NODES_INVALID;
                            for(int i=0; i<NODES_MAX; i++) {
                                if(!nodes[i].macAddr.compare(commandNAddr)) {
                                    idx = i;
                                }
                            }
                    
                            //execution process
                            string execResult = "failed";
                            if(idx != NODES_INVALID) {
                                DBG.printf("index found at %d\r\n",idx);
                        
                                string nodeCmd;
                                if(commandNType == "1"){
                                    //get cmd string based on device type and command number
                                    nodeCmd = readNodeCmd(commandDType,commandCmd);
                                    sprintf(s,"<?xml version=\"1.0\" encoding=\"utf-8\"?><app_cmd cmd=\"5\" /><app_data code=\"%s\"/>\r\n",nodeCmd.c_str());
                                } else if(commandNType == "2") {
                                    sprintf(s,"<?xml version=\"1.0\" encoding=\"utf-8\"?><app_cmd cmd=\"13\"/><app_data on-off=\"%s\"/>\r\n",commandCmd.c_str());
                                }
                                
                                if((commandNType == "1" && !nodeCmd.empty()) || commandNType == "2") {
                                    //execute command
                                    DBG.printf("executing command\r\n");
                                
                                    trial=0;
                                    while(1) {
                                        rxBuf.clear();
                                        if(trial>=2) {   //two times trial
                                            DBG.printf("cmd is not executed\r\n");
                                            TFT.foreground(Red);
                                            TFT.locate(0,180);
                                            TFT.printf("                                        ");
                                            TFT.locate(0,180);
                                            TFT.printf("cmd is not executed");
                                            wait(1);
                                            TFT.locate(0,180);
                                            TFT.printf("                                        ");
                                            TFT.foreground(White);
                                            break;    
                                        }
                                        nodes[idx].restConn->get("/",s);
                                        wait(2);
                                        if(rxBuf.find("REST: status = 200") != std::string::npos) {
                                            DBG.printf("cmd is executed\r\n");
                                            TFT.foreground(Green);
                                            TFT.locate(0,180);
                                            TFT.printf("                                        ");
                                            TFT.locate(0,180);
                                            TFT.printf("cmd is executed");
                                            wait(1);
                                            TFT.locate(0,180);
                                            TFT.printf("                                        ");
                                            TFT.foreground(White);
                                            execResult = "success";
                                            break;    
                                        }
                                        trial++;
                                    }
                                
                                    wait(2);
                            
                                    //send execution result
                                    sprintf(p,"emma-%s-%s",emmaUID.c_str(),commandCmd.c_str());   
                                    hmacCmd = calculateMD5(p);
                        
                                    connBodyLen = sprintf(connBody,"{\"uid\":\"%s\",\"nType\":\"%s\",\"nAddr\":\"%s\",\"dType\":\"%s\",\"cmd\":\"%s\",\"from\":\"%s\",\"result\":\"%s\",\"hmac\":\"%s\"}",
                                    emmaUID.c_str(), commandNType.c_str(),commandNAddr.c_str(),commandDType.c_str(),commandCmd.c_str(),commandFrom.c_str(),execResult.c_str(),hmacCmd.c_str());
                            
                                    sprintf(s,"POST /%s/api/controller/result HTTP/1.0\nHost: %s\nContent-Length:%d\n\n%s\r\n\r\n",appNAME.c_str(),restSERVER.c_str(),connBodyLen,connBody);
                                    connPort = restPORT;
                    
                                    trial=0;
                                    while(1) {
                                        if(trial>=2) {   //two times trial
                                            DBG.printf("failed to send execution result\r\n");
                                            break;    
                                        }
                                        str = gprsREST(restSERVER,connPort,s);
                                        wait(2);
                                        if(str.rfind("[{\"status\"") != std::string::npos) {
                                            str.erase(str.begin(),str.begin()+str.rfind("[{\"status\""));
                                            if(str.find("\"status\":\"success\"") != std::string::npos) {
                                                DBG.printf("success to send execution result\r\n");
                                                break;
                                            }
                                        }
                                        str.clear();
                                        trial++;
                                    }
                                }    
                            } else {
                                TFT.foreground(Red);
                                TFT.locate(0,180);
                                TFT.printf("                                        ");
                                TFT.locate(0,180);
                                TFT.printf("node is invalid");
                                wait(1);
                                TFT.locate(0,180);
                                TFT.printf("                                        ");
                                TFT.foreground(White);    
                            }
                        }
                    }
                }
                //clear text on lcd
                TFT.locate(0,160);
                TFT.printf("                                        ");
            }
            osDelay(5000);
        }
    }
}
void emmaModeFirmwareDownload(void) {
    bool emmaGetFirmwareParam = false;
    
    DBG.printf("emmaModeFirmwareDownload\r\n");
    
    char s[384];
    string str;
    string connData;
    string chunk;
    
    //firmware parameter
    string firmwareVer;
    string firmwareName;
    int numPart;
    
    //downloading
    string firmwarePart;
    string calcMD5;
    string srvrMD5;
    bool nextPart;
    
    //set wifi to mode bridge
    _ESP.printf("MODE=B");
    DBG.printf("set mode bridge\r\n");
    while(1) {
        char rcv[128] = {};
        wifiRcvReply(rcv,3000);
        str = rcv;
        if(str.find("MODE=B_OK") != std::string::npos)
            break;
    }
    DBG.printf("MODE=B\r\n");
    
    esp.enable();
    wait(1);
    while(!esp.ready());
    
    if(!rest.begin("candra.tritronik.com",3128,false)) {
        DBG.printf("EMMA: fail to setup rest");
        while(1);    
    }
    
    //wifiConnected = true; //with custom firmware, panel should connect wifi automatically
    useProxy = true;
    
    esp.process();
    //set connData
    if(useProxy) {
        for(int i=0; i<sizeof(s); i++) {
            s[i]=0; }
        //sprintf(s,"http://%s:%d/emma/api/controller/register?uid=%s&hmac=%s",restSERVER,restPORT,emmaUID.c_str(),hmac.c_str());
        sprintf(s,"http://192.168.128.69/emmaController/firmware/firmwareParameter");
        connData = s;
    } else {
        for(int i=0; i<sizeof(s); i++) {
            s[i]=0; }
        //sprintf(s,"/emma/api/controller/register?uid=%s&hmac=%s",emmaUID.c_str(),hmac.c_str());
        sprintf(s,"/emmaController/firmware/firmwareParameter");
        connData = s;
    }
    
    //get parameter of firmware to be downloaded
    while(!emmaGetFirmwareParam) {
        rest.get(connData.c_str());
        for(int i=0; i<sizeof(s); i++) {
            s[i]=0; }
        rest.getResponse(s,sizeof(s));
        //DBG.printf("rsp param:%s\r\n",s);
        
        str = s;
        if(str.find("[") != std::string::npos && str.find("]") != std::string::npos) {
            str.erase(str.begin(),str.begin()+str.find("[")+1);
            str.erase(str.begin()+str.find("]"),str.end());
            
            MbedJSONValue jsonValue;
            parse(jsonValue,str.c_str());
            
            char *parameter[2] = {"firmwareVer","numPart"};
            
            for(int i=0; i<2; i++) {
                if(jsonValue.hasMember(parameter[i])) {
                    string val = jsonValue[parameter[i]].get<std::string>();
                    if(i==0) {
                        firmwareVer = val;    
                    } else if(i==1) {
                        sscanf(val.c_str(),"%d",&numPart);
                    }
                }
            }
            
            if(!firmwareVer.empty() && numPart!=0) {
                emmaGetFirmwareParam = true;    
            }
        }
    }
    DBG.printf("firmwareVer:%s\r\n",firmwareVer.c_str());
    DBG.printf("numPart:%d\r\n",numPart);
    
    //clear firmware file
    while(1) {
        if(clearFirmware()){
            DBG.printf("clear firmware on sd card\r\n\r\n");
            break;
        }
        wait(1);
    }
    
    //set connData
    if(useProxy) {
        for(int i=0; i<sizeof(s); i++) {
            s[i]=0; }
        sprintf(s,"http://192.168.128.69/emmaController/firmware/%s",firmwareVer.c_str());
        connData = s;
    } else {
        for(int i=0; i<sizeof(s); i++) {
            s[i]=0; }
        sprintf(s,"/emmaController/firmware/%s",firmwareVer.c_str());
        connData = s;
    }
    
    //download firmware
    for(int n=0; n<numPart; n++) {
        nextPart = false;
        while(!nextPart) {
            for(int i=0; i<sizeof(s); i++) {
                s[i]=0; }
            sprintf(s,"%s/firmware_Hex_%s_%d",connData.c_str(),firmwareVer.c_str(),n);
            rest.get(s);
            for(int i=0; i<sizeof(s); i++) {
                s[i]=0; }
            rest.getResponse(s,sizeof(s));
            //DBG.printf("rsp[%d]:%s\r\n",n,s);
        
            str = s;
            if(str.find("{") != std::string::npos && str.find("}") != std::string::npos) {
                str.erase(str.begin(),str.begin()+str.find("{")+1);
                str.erase(str.begin()+str.find("}"),str.end());
                //DBG.printf("firmwarePart[%d]:%s\r\n",n,str.c_str());
                firmwarePart = str;
            
                //calculated MD5
                calcMD5 = calculateMD5(firmwarePart);
                //DBG.printf("calcMD5[%d]:%s\r\n",n,calcMD5.c_str());
            
                //MD5 from server
                for(int i=0; i<sizeof(s); i++) {
                    s[i]=0; }
                sprintf(s,"%s/MD5/firmware_MD5_%s_%d",connData.c_str(),firmwareVer.c_str(),n);
                rest.get(s);
                for(int i=0; i<sizeof(s); i++) {
                    s[i]=0; }
                rest.getResponse(s,sizeof(s));
            
                str = s;
                if(str.find("{") != std::string::npos && str.find("}") != std::string::npos) {
                    str.erase(str.begin(),str.begin()+str.find("{")+1);
                    str.erase(str.begin()+str.find("}"),str.end());
                    srvrMD5 = str;
                    //DBG.printf("srvrMD5[%d]:%s\r\n",n,srvrMD5.c_str());
                
                    //compare original MD5 vs MD5 from server
                    if(strcmp(calcMD5.c_str(),srvrMD5.c_str()) == 0) {
                        //DBG.printf("MD5 correct\r\n");
                        
                        //save to sd card
                        int st = writeFirmwareHexToChar(firmwarePart);
                        if(st) {
                            DBG.printf("firmwarePart[%d/%d] written\r\n",n,numPart-1);
                            nextPart = true;    
                        }
                    
                    } else {
                        DBG.printf("MD5 incorrect\r\n");    
                    }
                }   
            } else {
                DBG.printf("retry to fetch firmwarePart[%d]\r\n",n);    
            }
            wait(0.5);
        }
    }
    DBG.printf("download finished\r\n");
}

void emmaModeReserved(void) {
    char connBody[128];
    char s[256];
    //char buf[1024];
    int connBodyLen;
    int i=0;
    //int ret=99;
    string str;
    Timer t;
    //TCPSocketConnection sock;
    
    eth.init();
    eth.connect();
    connBodyLen = sprintf(connBody,"{\"uid\":\"005e00553533510334313732\",\"hmac\":\"9424c60e708d8e3d3dff6d23fb104339\"}");
    sprintf(s,"POST /emma/api/controller/command HTTP/1.0\nHost: 36.80.35.8\nContent-Length:%d\n\n%s\r\n\r\n",connBodyLen,connBody);
    while(1) {
        //command
        str.clear();
        str = ethREST("36.80.35.8",8080,s);
        DBG.printf("[%d]str:%s\r\n",i,str.c_str());
        i++;
        wait(5);
    }
    
    /*
    //start working as expected
    eth.init();
    eth.connect();
    connBodyLen = sprintf(connBody,"{\"uid\":\"005e00553533510334313732\",\"hmac\":\"9424c60e708d8e3d3dff6d23fb104339\"}");
    sprintf(s,"POST /emma/api/controller/command HTTP/1.0\nHost: 36.80.35.8\nContent-Length:%d\n\n%s\r\n\r\n",connBodyLen,connBody);
    
    while(1) {
        //eth.connect();
        t.start();
        while(eth.linkstatus() && t.read() < 5 && ret !=0) {
            ret = sock.connect("36.80.35.8",8080);
        }
        t.stop();
        t.reset();
        
        memset(buf,0,sizeof(buf));
        if(sock.is_connected()) {
            DBG.printf("connect\r\n");
            sock.send_all(s,sizeof(s)-1);
            wait(2);
            //receive return
            t.start();
            while(1) {
                ret = sock.receive(buf, sizeof(buf));
                if(ret<=0 || t.read() > 5) {
                    t.stop();
                    t.reset();
                    break;
                }    
            }
            sock.close();    
        } else {
            DBG.printf("not connected\r\n");       
        }
        //eth.disconnect();
        DBG.printf("[%d]BUF:%s\r\n\r\n",i,buf);
        i++;
        wait(5);
    }
    //end working as expected
    */
}
/*end emma mode*/

/*start energy related*/
void energyThread(void const*) {
    Timer tEnergy;
    
    while(1) {
        tEnergy.start();
        DBG.printf("energyThread-start\r\n");
        
        AWattHrSum = 0;
        BWattHrSum = 0;
        CWattHrSum = 0;
        
        while(tEnergy.read() < 5*60.0) {
            AWattHrValue = ADE.getWattHR(PHASE_A);
            BWattHrValue = ADE.getWattHR(PHASE_B);
            CWattHrValue = ADE.getWattHR(PHASE_C); 
            
            AWattHrSum += AWattHrValue;
            BWattHrSum += BWattHrValue;
            CWattHrSum += CWattHrValue;
            
            
            //start check voltage and power
            AVrms = ADE.VRMS(PHASE_A) * 0.000124f;      //0.000158;     //constants are from calculateVRMS function
            BVrms = ADE.VRMS(PHASE_B) * 0.000123f;
            CVrms = ADE.VRMS(PHASE_C) * 0.000122f;
    
            AIrms = ADE.IRMS(PHASE_A) * 0.00001006f;    //0.0000125f;   //constants are from calculateIRMS function
            BIrms = ADE.IRMS(PHASE_B) * 0.00001005f;
            CIrms = ADE.IRMS(PHASE_C) * 0.00001004f;
    
            AWatt = AVrms * AIrms;
            BWatt = BVrms * BIrms;
            CWatt = CVrms * CIrms;
            //end check voltage and power
               
        }
        
        AWattHr = AWattHrSum * 0.000044169f;    //0.0000198f;
        BWattHr = BWattHrSum * 0.000044168f;    //0.0000197f;
        CWattHr = CWattHrSum * 0.000044167f;    //0.0000196f;
        
        newEnergyData = true;
        
        tEnergy.stop();
        tEnergy.reset();
        DBG.printf("energyThread-finish\r\n");
    }
}

void checkVoltagePower(void) {
    //check if voltage or power violates threshold
    char connBody[256];
    char p[64];
    char q[32];
    char s[256];
    int connBodyLen=0;
    int connPort=0;
    int alertType=0;
    string hmacTime;
    string str;
    time_t seconds;
    
    //DBG.printf("checkVoltagePower-start\r\n");
    
    //vrms and irms should be placed inside energy calculation routine
    
    //get time
    seconds = time(NULL);
    strftime(q, 32, "%Y-%m-%d %H:%M:%S",localtime(&seconds));
    
    //calculate hmacTime
    sprintf(p,"emma-%s-%s",emmaUID.c_str(),q);   
    hmacTime = calculateMD5(p);
    
    //read connPort
    connPort = restPORT;
    
    if(vrmsTHL > AVrms) {
        alertType = 1;
    } else if (AVrms > vrmsTHH) {
        alertType = 2;
    }
    
    connBodyLen = sprintf(connBody,"{\"uid\":\"%s\",\"hmac\":\"%s\",\"time\":\"%s\",\"value\":%.2f,\"type\":%d}",
    emmaUID.c_str(),hmacTime.c_str(),q,AVrms,alertType);
    
    if(alertType != 0 && ethConnected && allowAlertAVrms) {
        sprintf(s,"POST /%s/api/controller/alert/1 HTTP/1.0\nHost: %s\nContent-Length:%d\n\n%s\r\n\r\n",appNAME.c_str(),restSERVER.c_str(),connBodyLen,connBody);
        str.clear();
        str = ethREST(restSERVER,connPort,s);
        allowAlertAVrms = false;
        DBG.printf("[ph1]vrms:%s\r\n",str.c_str());
    } else if(alertType != 0 && wifiConnected && allowAlertAVrms) {
        sprintf(p,"/%s/api/controller/alert/1",appNAME.c_str());
        //DBG.printf("[ph1]:%s\r\n",connBody);
        
        rxBuf.clear();
        rest.post(p,connBody);
        wait(2);
        str = rxBuf;
        if(str.rfind("/alert/1") != std::string::npos) {
            str.erase(str.begin(),str.begin()+str.rfind("/alert/1"));
            if(str.find("\"status\":\"success\"") != std::string::npos) {
                DBG.printf("[ph1]vrms success\r\n");
            } else {
                DBG.printf("[ph1]vrms failed\r\n");
            }
        }
        allowAlertAVrms = false;    
    } else if(alertType != 0 && gprsConnected && allowAlertAVrms) {
        sprintf(s,"POST /%s/api/controller/alert/1 HTTP/1.0\nHost: %s\nContent-Length:%d\n\n%s\r\n\r\n",appNAME.c_str(),restSERVER.c_str(),connBodyLen,connBody);
        str.clear();
        str = gprsREST(restSERVER,connPort,s);
        if(str.rfind("/alert/1") != std::string::npos) {
            str.erase(str.begin(),str.begin()+str.rfind("/alert/1"));
            if(str.find("\"status\":\"success\"") != std::string::npos) {
                DBG.printf("[ph1]vrms success\r\n");
            } else {
                DBG.printf("[ph1]vrms failed\r\n");
            }
        }
        allowAlertAVrms = false;
    }
    
    alertType = 0;
    if(wattTHL > AWatt) {
        alertType = 3;
    } else if (AWatt > wattTHH) {
        alertType = 4;
    }
    
    connBodyLen = sprintf(connBody,"{\"uid\":\"%s\",\"hmac\":\"%s\",\"time\":\"%s\",\"value\":%.2f,\"type\":%d}",
    emmaUID.c_str(),hmacTime.c_str(),q,AWatt,alertType);
    
    if(alertType != 0 && ethConnected && allowAlertAWatt) {
        sprintf(s,"POST /%s/api/controller/alert/1 HTTP/1.0\nHost: %s\nContent-Length:%d\n\n%s\r\n\r\n",appNAME.c_str(),restSERVER.c_str(),connBodyLen,connBody);
        str.clear();
        str = ethREST(restSERVER,connPort,s);
        allowAlertAWatt = false;
        DBG.printf("[ph1]watt:%s\r\n",str.c_str());
    } else if(alertType != 0 && wifiConnected && allowAlertAWatt) {
        sprintf(p,"/%s/api/controller/alert/1",appNAME.c_str());
        //DBG.printf("[ph1]:%s\r\n",connBody);
        
        rxBuf.clear();
        rest.post(p,connBody);
        wait(2);
        str = rxBuf;
        if(str.rfind("/alert/1") != std::string::npos) {
            str.erase(str.begin(),str.begin()+str.rfind("/alert/1"));
            if(str.find("\"status\":\"success\"") != std::string::npos) {
                DBG.printf("[ph1]watt success\r\n");
            } else {
                DBG.printf("[ph1]watt failed\r\n");
            }
        }
        allowAlertAWatt = false;    
    } else if(alertType != 0 && gprsConnected && allowAlertAWatt) {
        sprintf(s,"POST /%s/api/controller/alert/1 HTTP/1.0\nHost: %s\nContent-Length:%d\n\n%s\r\n\r\n",appNAME.c_str(),restSERVER.c_str(),connBodyLen,connBody);
        str.clear();
        str = gprsREST(restSERVER,connPort,s);
        if(str.rfind("/alert/1") != std::string::npos) {
            str.erase(str.begin(),str.begin()+str.rfind("/alert/1"));
            if(str.find("\"status\":\"success\"") != std::string::npos) {
                DBG.printf("[ph1]watt success\r\n");
            } else {
                DBG.printf("[ph1]watt failed\r\n");
            }
        }
        allowAlertAWatt = false;
    }
    
    alertType = 0;
    if(vrmsTHL > BVrms) {
        alertType = 1;
    } else if (BVrms > vrmsTHH) {
        alertType = 2;
    }
    
    connBodyLen = sprintf(connBody,"{\"uid\":\"%s\",\"hmac\":\"%s\",\"time\":\"%s\",\"value\":%.2f,\"type\":%d}",
    emmaUID.c_str(),hmacTime.c_str(),q,BVrms,alertType);
    
    if(alertType != 0 && ethConnected && allowAlertBVrms) {
        sprintf(s,"POST /%s/api/controller/alert/2 HTTP/1.0\nHost: %s\nContent-Length:%d\n\n%s\r\n\r\n",appNAME.c_str(),restSERVER.c_str(),connBodyLen,connBody);
        str.clear();
        str = ethREST(restSERVER,connPort,s);
        allowAlertBVrms = false;
        DBG.printf("[ph2]vrms:%s\r\n",str.c_str());
    } else if(alertType != 0 && wifiConnected && allowAlertBVrms) {
        sprintf(p,"/%s/api/controller/alert/2",appNAME.c_str());
        //DBG.printf("[ph2]:%s\r\n",connBody);
        
        rxBuf.clear();
        rest.post(p,connBody);
        wait(2);
        str = rxBuf;
        if(str.rfind("/alert/2") != std::string::npos) {
            str.erase(str.begin(),str.begin()+str.rfind("/alert/2"));
            if(str.find("\"status\":\"success\"") != std::string::npos) {
                DBG.printf("[ph2]vrms success\r\n");
            } else {
                DBG.printf("[ph2]vrms failed\r\n");
            }
        }
        allowAlertBVrms = false;    
    } else if(alertType != 0 && gprsConnected && allowAlertBVrms) {
        sprintf(s,"POST /%s/api/controller/alert/2 HTTP/1.0\nHost: %s\nContent-Length:%d\n\n%s\r\n\r\n",appNAME.c_str(),restSERVER.c_str(),connBodyLen,connBody);
        str.clear();
        str = gprsREST(restSERVER,connPort,s);
        if(str.rfind("/alert/2") != std::string::npos) {
            str.erase(str.begin(),str.begin()+str.rfind("/alert/2"));
            if(str.find("\"status\":\"success\"") != std::string::npos) {
                DBG.printf("[ph2]vrms success\r\n");
            } else {
                DBG.printf("[ph2]vrms failed\r\n");
            }
        }
        allowAlertBVrms = false;
    }
    
    alertType = 0;
    if(wattTHL > BWatt) {
        alertType = 3;
    } else if (BWatt > wattTHH) {
        alertType = 4;
    }
    
    connBodyLen = sprintf(connBody,"{\"uid\":\"%s\",\"hmac\":\"%s\",\"time\":\"%s\",\"value\":%.2f,\"type\":%d}",
    emmaUID.c_str(),hmacTime.c_str(),q,BWatt,alertType);
    
    if(alertType != 0 && ethConnected && allowAlertBWatt) {
        sprintf(s,"POST /%s/api/controller/alert/2 HTTP/1.0\nHost: %s\nContent-Length:%d\n\n%s\r\n\r\n",appNAME.c_str(),restSERVER.c_str(),connBodyLen,connBody);
        str.clear();
        str = ethREST(restSERVER,connPort,s);
        allowAlertBWatt = false;
        DBG.printf("[ph2]watt:%s\r\n",str.c_str());
    } else if(alertType != 0 && wifiConnected && allowAlertBWatt) {
        sprintf(p,"/%s/api/controller/alert/2",appNAME.c_str());
        //DBG.printf("[ph2]:%s\r\n",connBody);
        
        rxBuf.clear();
        rest.post(p,connBody);
        wait(2);
        str = rxBuf;
        if(str.rfind("/alert/2") != std::string::npos) {
            str.erase(str.begin(),str.begin()+str.rfind("/alert/2"));
            if(str.find("\"status\":\"success\"") != std::string::npos) {
                DBG.printf("[ph2]watt success\r\n");
            } else {
                DBG.printf("[ph2]watt failed\r\n");
            }
        }
        allowAlertBWatt = false;    
    } else if(alertType != 0 && gprsConnected && allowAlertBWatt) {
        sprintf(s,"POST /%s/api/controller/alert/2 HTTP/1.0\nHost: %s\nContent-Length:%d\n\n%s\r\n\r\n",appNAME.c_str(),restSERVER.c_str(),connBodyLen,connBody);
        str.clear();
        str = gprsREST(restSERVER,connPort,s);
        if(str.rfind("/alert/2") != std::string::npos) {
            str.erase(str.begin(),str.begin()+str.rfind("/alert/2"));
            if(str.find("\"status\":\"success\"") != std::string::npos) {
                DBG.printf("[ph2]watt success\r\n");
            } else {
                DBG.printf("[ph2]watt failed\r\n");
            }
        }
        allowAlertBWatt = false;
    }
    
    alertType = 0;
    if(vrmsTHL > CVrms) {
        alertType = 1;
    } else if (CVrms > vrmsTHH) {
        alertType = 2;
    }
    
    connBodyLen = sprintf(connBody,"{\"uid\":\"%s\",\"hmac\":\"%s\",\"time\":\"%s\",\"value\":%.2f,\"type\":%d}",
    emmaUID.c_str(),hmacTime.c_str(),q,CVrms,alertType);
    
    if(alertType != 0 && ethConnected && allowAlertCVrms) {
        sprintf(s,"POST /%s/api/controller/alert/3 HTTP/1.0\nHost: %s\nContent-Length:%d\n\n%s\r\n\r\n",appNAME.c_str(),restSERVER.c_str(),connBodyLen,connBody);
        str.clear();
        str = ethREST(restSERVER,connPort,s);
        allowAlertCVrms = false;
        DBG.printf("[ph3]vrms:%s\r\n",str.c_str());
    } else if(alertType != 0 && wifiConnected && allowAlertCVrms) {
        sprintf(p,"/%s/api/controller/alert/3",appNAME.c_str());
        //DBG.printf("[ph3]:%s\r\n",connBody);
        
        rxBuf.clear();
        rest.post(p,connBody);
        wait(2);
        str = rxBuf;
        if(str.rfind("/alert/3") != std::string::npos) {
            str.erase(str.begin(),str.begin()+str.rfind("/alert/3"));
            if(str.find("\"status\":\"success\"") != std::string::npos) {
                DBG.printf("[ph3]vrms success\r\n");
            } else {
                DBG.printf("[ph3]vrms failed\r\n");
            }
        }
        allowAlertCVrms = false;    
    } else if(alertType != 0 && gprsConnected && allowAlertCVrms) {
        sprintf(s,"POST /%s/api/controller/alert/3 HTTP/1.0\nHost: %s\nContent-Length:%d\n\n%s\r\n\r\n",appNAME.c_str(),restSERVER.c_str(),connBodyLen,connBody);
        str.clear();
        str = gprsREST(restSERVER,connPort,s);
        if(str.rfind("/alert/3") != std::string::npos) {
            str.erase(str.begin(),str.begin()+str.rfind("/alert/3"));
            if(str.find("\"status\":\"success\"") != std::string::npos) {
                DBG.printf("[ph3]vrms success\r\n");
            } else {
                DBG.printf("[ph3]vrms failed\r\n");
            }
        }
        allowAlertCVrms = false;
    }
    
    alertType = 0;
    if(wattTHL > CWatt) {
        alertType = 3;
    } else if (CWatt > wattTHH) {
        alertType = 4;
    }
    
    connBodyLen = sprintf(connBody,"{\"uid\":\"%s\",\"hmac\":\"%s\",\"time\":\"%s\",\"value\":%.2f,\"type\":%d}",
    emmaUID.c_str(),hmacTime.c_str(),q,CWatt,alertType);
    
    if(alertType != 0 && ethConnected && allowAlertCWatt) {
        sprintf(s,"POST /%s/api/controller/alert/3 HTTP/1.0\nHost: %s\nContent-Length:%d\n\n%s\r\n\r\n",appNAME.c_str(),restSERVER.c_str(),connBodyLen,connBody);
        str.clear();
        str = ethREST(restSERVER,connPort,s);
        allowAlertCWatt = false;
        DBG.printf("[ph3]watt:%s\r\n",str.c_str());
    } else if(alertType != 0 && wifiConnected && allowAlertCWatt) {
        sprintf(p,"/%s/api/controller/alert/3",appNAME.c_str());
        //DBG.printf("[ph3]:%s\r\n",connBody);
        
        rxBuf.clear();
        rest.post(p,connBody);
        wait(2);
        str = rxBuf;
        if(str.rfind("/alert/3") != std::string::npos) {
            str.erase(str.begin(),str.begin()+str.rfind("/alert/3"));
            if(str.find("\"status\":\"success\"") != std::string::npos) {
                DBG.printf("[ph3]watt success\r\n");
            } else {
                DBG.printf("[ph3]watt failed\r\n");
            }
        }
        allowAlertCWatt = false;
    } else if(alertType != 0 && gprsConnected && allowAlertCWatt) {
        sprintf(s,"POST /%s/api/controller/alert/3 HTTP/1.0\nHost: %s\nContent-Length:%d\n\n%s\r\n\r\n",appNAME.c_str(),restSERVER.c_str(),connBodyLen,connBody);
        str.clear();
        str = gprsREST(restSERVER,connPort,s);
        if(str.rfind("/alert/3") != std::string::npos) {
            str.erase(str.begin(),str.begin()+str.rfind("/alert/3"));
            if(str.find("\"status\":\"success\"") != std::string::npos) {
                DBG.printf("[ph3]watt success\r\n");
            } else {
                DBG.printf("[ph3]watt failed\r\n");
            }
        }
        allowAlertCWatt = false;
    }
    //DBG.printf("checkVoltagePower-finish\r\n");
}
/*end energy related*/

/*start eth rest*/
string ethREST(string host, int port, string data) {
    char buf[1024];
    char s[256];
    int ret=99;
    Timer t;
    
    t.start();
    while(eth.linkstatus() && t.read() < 5 && ret !=0) {
        ret = sock.connect(host.c_str(),port);
    }
    t.stop();
    t.reset();
    
    memset(buf,0,sizeof(buf));
    if(sock.is_connected()) {
        DBG.printf("sockConnect\r\n");
        sprintf(s,"%s",data.c_str());
        sock.send_all(s,sizeof(s)-1);
        //wait(2);
        wait(0.5);
        
        //receive return
        t.start();
        while(1) {
            ret = sock.receive(buf, sizeof(buf));
            if(ret<=0 || t.read() > 5) {
                t.stop();
                t.reset();
                break;
            }    
        }
        sock.close();    
    } else {
        DBG.printf("sockNotConnect\r\n");       
    }
    return buf;
    
    /*
    //eth.init(); //use DHCP
    eth.connect();
    
    //TCPSocketConnection sock;
    Timer t;
    
    sprintf(s,"%s",data.c_str());
    sock.connect(host.c_str(),port);
    sock.send_all(s,sizeof(s)-1);
    wait(2);
    
    //receive return
    t.start();
    while(1) {
        ret = sock.receive(buf, sizeof(buf));
        if(ret<=0 || t.read_ms() > 10000) {
            t.stop();
            break;
        }    
    }
    sock.close();
    eth.disconnect();
    return buf;
    */
}
/*end eth rest*/

/*start wifi mqtt*/
void mqttConnected(void* response) {
    DBG.printf("MQTT Connected\r\n");
    char mqttTopic[64];
    sprintf(mqttTopic,"%s/%s/command",mqttDOMAIN.c_str(),emmaUID.c_str());
    //mqtt.subscribe(mqttTopic);
}
void mqttDisconnected(void* response) {
    DBG.printf("MQTT Disconnected\r\n");    
}
/*end wifi mqtt*/

/*start wifi rest*/
void wifiCb(void* response) {
    uint32_t status;
    RESPONSE res(response);
    
    if(res.getArgc() == 1) {
        res.popArgs((uint8_t*)&status,4);
        if(status == STATION_GOT_IP) {
            DBG.printf("WIFI Connected\r\n");
            //wifiConnected = true;
        }
        else {
            //wifiConnected = false;   
        }
    }
}

void rxInterrupt(void) {
    char c;
    
    while(_ESP.readable()) {
        c = _ESP.getc();
        if(c != 0) {    //char is not null
            rxBuf += c;
        }
    }
}
void checkRxBuffer(void) {
    //check new command
    if(rxBuf.rfind("/command") != std::string::npos) {
        rxBuf.erase(rxBuf.begin(),rxBuf.begin()+rxBuf.rfind("/command"));
        if(rxBuf.find("[{") != std::string::npos && rxBuf.rfind("}]") != std::string::npos) {
            rxBuf.erase(rxBuf.begin(),rxBuf.begin()+rxBuf.find("[{"));
            rxBuf.erase(rxBuf.begin()+rxBuf.rfind("}]")+2,rxBuf.end());
            
            //start special handler
            while(1){
                if(rxBuf.find("}],") != std::string::npos) {
                    rxBuf.erase(rxBuf.begin()+rxBuf.find("}],")+1,rxBuf.begin()+rxBuf.find("}],")+2);    
                } else {
                    break;
                }
            }
            //end special handler
            
            globalCommand = rxBuf;
            newCommand = true;
        }
    }
    
    //check free memory -> reinitialize mqtt connection
    if(rxBuf.rfind("Free memory") != std::string::npos) {
        rxLog = "Free memory-" + rxBuf;
        espFreeMemory = true;
    }
    
    //check dhcp client start -> initialize all connection
    if(rxBuf.rfind("dhcp client start") != std::string::npos) {
        rxLogA = "dhcp client start-" + rxBuf;
        espDHCPClientStart = true;
    }
    
    //clear rxBuf
    rxBuf.clear();
}
void wifiRcvReply(char *r, int to) {
    Timer t;
    bool ended = false;
    char c;
    
    strcpy(r,"");
    t.start();
    while(!ended) {
        if(_ESP.readable()) {
            c = _ESP.getc();
            addChar(r,c);
            t.start();
        }
        if(t.read_ms() > to) {
            ended = true;    
        }    
    }
    addChar(r, 0x00);    
}
/*end wifi rest*/

/*start gprs rest*/
void gprsReset(void) {
    pwrKey = 0;
    wait(1);
    pwrKey = 1;
    wait(2);
    pwrKey = 0;
    wait(2);    
}
void gprsRxInterrupt(void) {
    char c;
    
    while(sim900.readable()) {
        c = sim900.getc();
        if(c != 0) {    //char is not null
            gprsRxBuf += c;    
        }    
    }    
}
string gprsInit(string APN) {
    char r[128];
    char s[128];
    int n=0;
    string str;
    
    while(1) {
        sim900.printf("AT+CIPMUX=1\r\n");
        gprsRcvReply(r,3000);
        //DBG.printf("rspn[CIPMUX]:%s\r\n",r);
        DBG.printf("AT+CIPMUX\r\n");
        str = r;
        if(str.find("OK") != std::string::npos) {
            break;    
        }
        if(n>=3) {
            return "ERROR";    
        }
        n++;
    }
    
    if(!APN.compare("Telkomsel")) {
        strcpy(s,"AT+CSTT=\"telkomsel\",\"wap\",\"wap123\"\r\n");
    } else if(!APN.compare("Indosat")) {
        strcpy(s,"AT+CSTT=\"indosatgprs\",\"indosat\",\"indosat\"\r\n");
    } else if(!APN.compare("XL")) {
        strcpy(s,"AT+CSTT=\"www.xlgprs.net\",\"xlgprs\",\"proxl\"\r\n");
    } else if(!APN.compare("3")) {
        strcpy(s,"AT+CSTT=\"3gprs\",\"3gprs\",\"3gprs\"\r\n");
    } else {
        return "ERROR";    
    }
    
    n=0;
    while(1) {
        sim900.printf("%s",s);
        gprsRcvReply(r,5000);
        //DBG.printf("rspn[CSTT]:%s\r\n",r);
        DBG.printf("AT+CSTT\r\n");
        str = r;
        if(str.find("OK") != std::string::npos) {
            break;    
        }
        if(n>=3) {
            return "ERROR";    
        }
        n++;
    }
    
    n=0;
    while(1) {
        sim900.printf("AT+CIICR\r\n");
        gprsRcvReply(r,3000);
        //DBG.printf("rspn[CIICR]:%s\r\n",r);
        DBG.printf("AT+CIICR\r\n");
        str = r;
        if(str.find("OK") != std::string::npos) {
            break;    
        }
        if(n>=3) {
            return "ERROR";    
        }
        n++;
    }
    
    while(1) {
        sim900.printf("AT+CIFSR\r\n");
        gprsRcvReply(r,3000);
        //DBG.printf("rspn[CIFSR]:%s\r\n",r);
        DBG.printf("AT+CIFSR\r\n");
        str = r;
        if(str.find("ERROR") != std::string::npos) {
            return "ERROR";    
        } else {
            return str;    
        }
    }
}
string gprsInitAnimate(string APN) {
    bool waitAnimation = false;
    char s[128];
    int n=0;
    string str;
    Timer t;
    
    //initialization    //should be placed in main program
    sim900.attach(&gprsRxInterrupt,SoftSerial::RxIrq);
    
    //AT+CIPMUX
    waitAnimation = true;
    while(waitAnimation) {
        sim900.printf("AT+CIPMUX=1\r\n");
        for(int i=0; i<960; i+=4) {     //960 is ~3sec
            TFT.fillarc(160, 130, 92, 4, (i >> 1)-45, (i >> 1)+45, colorDarkGray);
            TFT.fillarc(160, 130, 92, 4, (i >> 1)-45-4, (i >> 1)-45, Blue);
            TFT.fillarc(160, 130, 95, 4, 1440-i-45, 1440-i+45, colorDarkGray);
            TFT.fillarc(160, 130, 95, 4, 1440-i+45, 1440-i+45+4, colorLightGray);

            if(gprsRxBuf.find("OK") != std::string::npos) {
                waitAnimation = false;        
            }
        }
        //DBG.printf("rxBuf:%s\r\n",gprsRxBuf.c_str());
        if(n>=3) {
            return "ERROR";
        }
        n++;
    }
    
    //APN
    if(!APN.compare("Telkomsel")) {
        strcpy(s,"AT+CSTT=\"telkomsel\",\"wap\",\"wap123\"\r\n");
    } else if(!APN.compare("Indosat")) {
        strcpy(s,"AT+CSTT=\"indosatgprs\",\"indosat\",\"indosat\"\r\n");
    } else if(!APN.compare("XL")) {
        strcpy(s,"AT+CSTT=\"www.xlgprs.net\",\"xlgprs\",\"proxl\"\r\n");
    } else if(!APN.compare("3")) {
        strcpy(s,"AT+CSTT=\"3gprs\",\"3gprs\",\"3gprs\"\r\n");
    } else {
        return "ERROR";    
    }
    
    //AT+CSTT
    waitAnimation = true;
    n=0;
    gprsRxBuf.clear();
    while(waitAnimation) {
        sim900.printf("%s",s);
        for(int i=0; i<1440; i+=4) {     //1440 is ~5sec
            TFT.fillarc(160, 130, 92, 4, (i >> 1)-45, (i >> 1)+45, colorDarkGray);
            TFT.fillarc(160, 130, 92, 4, (i >> 1)-45-4, (i >> 1)-45, Blue);
            TFT.fillarc(160, 130, 95, 4, 1440-i-45, 1440-i+45, colorDarkGray);
            TFT.fillarc(160, 130, 95, 4, 1440-i+45, 1440-i+45+4, colorLightGray);

            if(gprsRxBuf.find("OK") != std::string::npos) {
                waitAnimation = false;        
            }
        }
        if(n>=3) {
            return "ERROR";
        }
        n++;
    }
    
    //AT+CIICR
    waitAnimation = true;
    n=0;
    gprsRxBuf.clear();
    while(waitAnimation) {
        sim900.printf("AT+CIICR\r\n");
        for(int i=0; i<960; i+=4) {     //960 is ~3sec
            TFT.fillarc(160, 130, 92, 4, (i >> 1)-45, (i >> 1)+45, colorDarkGray);
            TFT.fillarc(160, 130, 92, 4, (i >> 1)-45-4, (i >> 1)-45, Blue);
            TFT.fillarc(160, 130, 95, 4, 1440-i-45, 1440-i+45, colorDarkGray);
            TFT.fillarc(160, 130, 95, 4, 1440-i+45, 1440-i+45+4, colorLightGray);

            if(gprsRxBuf.find("OK") != std::string::npos) {
                waitAnimation = false;        
            }
        }
        if(n>=3) {
            return "ERROR";
        }
        n++;
    }
    
    //AT+CIFSR
    gprsRxBuf.clear();
    sim900.printf("AT+CIFSR\r\n");
    for(int i=0; i<960; i+=4) {     //960 is ~3sec
        TFT.fillarc(160, 130, 92, 4, (i >> 1)-45, (i >> 1)+45, colorDarkGray);
        TFT.fillarc(160, 130, 92, 4, (i >> 1)-45-4, (i >> 1)-45, Blue);
        TFT.fillarc(160, 130, 95, 4, 1440-i-45, 1440-i+45, colorDarkGray);
        TFT.fillarc(160, 130, 95, 4, 1440-i+45, 1440-i+45+4, colorLightGray);
    }
    if(gprsRxBuf.find("ERROR") != std::string::npos) {
        return "ERROR";        
    } else {
        return gprsRxBuf;    
    }
}
string gprsREST(string host, int port, string data) {
    char r[128];
    char rLong[2048];
    int n=0;
    string str;
    
    //AT+CIPSTART
    while(1) {
        sim900.printf("AT+CIPSTART=1,\"TCP\",\"%s\",%d\r\n",host.c_str(),port);
        gprsRcvReply(r,3000);
        //DBG.printf("rspn[CIPSTART]:%s",r);
        DBG.printf("[CIPSTART]\r\n");
        str = r;
        if(str.find("CONNECT OK") != std::string::npos) {
            break;    
        }
        if(n>=3) {
            return "ERROR:CIPSTART"; //unable to start connection    
        }
        n++;
    }
    
    //AT+CIPSEND
    sim900.printf("AT+CIPSEND=1,%d\r\n",data.length());
    gprsRcvReply(r,1000);
    //DBG.printf("rspn[CIPSEND]:%s",r);
    DBG.printf("[CIPSEND]\r\n");
    
    str = r;
    if(str.find(">") != std::string::npos) {
        sim900.printf("%s",data.c_str());
        gprsRcvReply(rLong,10000);
        //DBG.printf("rspn[>]:%s\r\n",rLong);
        DBG.printf("[>]\r\n");
    }
    else {
        return "ERROR:>";   //unable to send data
    }
    
    //close connection (case for get request)
    str = rLong;
    if(str.find("CLOSED") != std::string::npos) {
        return rLong;
    }
    
    //close connection
    n=0;
    while(1) {
        sim900.printf("AT+CIPCLOSE=1,1\r\n");
        gprsRcvReply(r,3000);
        //DBG.printf("rspn[CIPCLOSE]:%s\r\n",r);
        DBG.printf("[CIPCLOSE]\r\n");
        str = r;
        if(str.find("CLOSE OK") != std::string::npos) {
            break;    
        }
        if(n>=3) {
            //return "ERROR:CIPCLOSE"; //unable to close connection
            return rLong;   //assumption if unable to close connection because it already been closed
        }
        n++;
    }
    return rLong;
}
string gprsRESTAnimate(string host, int port, string data) {
    bool waitAnimation = false;
    int n=0;
    string str;
    Timer t;
    
    //initialization
    //sim900.attach(&gprsRxInterrupt,SoftSerial::RxIrq);
    
    //AT+CIPSTART
    waitAnimation = true;
    while(waitAnimation) {
        sim900.printf("AT+CIPSTART=1,\"TCP\",\"%s\",%d\r\n",host.c_str(),port);
        for(int i=0; i<2880; i+=4) {
            TFT.fillarc(160, 130, 92, 4, (i >> 1)-45, (i >> 1)+45, colorDarkGray);
            TFT.fillarc(160, 130, 92, 4, (i >> 1)-45-4, (i >> 1)-45, Blue);
            TFT.fillarc(160, 130, 95, 4, 1440-i-45, 1440-i+45, colorDarkGray);
            TFT.fillarc(160, 130, 95, 4, 1440-i+45, 1440-i+45+4, colorLightGray);
            
            if(gprsRxBuf.find("CONNECT OK") != std::string::npos) {
                waitAnimation = false;        
            }
        }
        if(n>=3) {
            return "ERROR:CIPSTART"; //unable to start connection
        }
        n++;
    }
    
    //return "CONNECT OK";    //should be deleted
    
    //AT+CIPSEND
    gprsRxBuf.clear();
    sim900.printf("AT+CIPSEND=1,%d\r\n",data.length());
    for(int i=0; i<960; i+=4) {     //960 is ~3sec
        TFT.fillarc(160, 130, 92, 4, (i >> 1)-45, (i >> 1)+45, colorDarkGray);
        TFT.fillarc(160, 130, 92, 4, (i >> 1)-45-4, (i >> 1)-45, Blue);
        TFT.fillarc(160, 130, 95, 4, 1440-i-45, 1440-i+45, colorDarkGray);
        TFT.fillarc(160, 130, 95, 4, 1440-i+45, 1440-i+45+4, colorLightGray);
    }
    if(gprsRxBuf.find(">") != std::string::npos) {
        gprsRxBuf.clear();
        sim900.printf("%s",data.c_str());
        for(int i=0; i<2880; i+=4) {     //2880 is ~10sec
            TFT.fillarc(160, 130, 92, 4, (i >> 1)-45, (i >> 1)+45, colorDarkGray);
            TFT.fillarc(160, 130, 92, 4, (i >> 1)-45-4, (i >> 1)-45, Blue);
            TFT.fillarc(160, 130, 95, 4, 1440-i-45, 1440-i+45, colorDarkGray);
            TFT.fillarc(160, 130, 95, 4, 1440-i+45, 1440-i+45+4, colorLightGray);
        }
    } else {
        return "ERROR:>";   //unable to send data
    }
    
    //close connection (case for get request)
    if(gprsRxBuf.find("CLOSED") != std::string::npos) {
        return gprsRxBuf;
    }
    
    //close connection
    waitAnimation = true;
    n=0;
    gprsRxBuf.clear();
    while(waitAnimation) {
        sim900.printf("AT+CIPCLOSE=1,1\r\n");
        for(int i=0; i<960; i+=4) {     //960 is ~3sec
            TFT.fillarc(160, 130, 92, 4, (i >> 1)-45, (i >> 1)+45, colorDarkGray);
            TFT.fillarc(160, 130, 92, 4, (i >> 1)-45-4, (i >> 1)-45, Blue);
            TFT.fillarc(160, 130, 95, 4, 1440-i-45, 1440-i+45, colorDarkGray);
            TFT.fillarc(160, 130, 95, 4, 1440-i+45, 1440-i+45+4, colorLightGray);

            if(gprsRxBuf.find("CLOSE OK") != std::string::npos) {
                waitAnimation = false;        
            }
        }
        if(n>=3) {
            //return "ERROR:CIPCLOSE"; //unable to close connection
            return gprsRxBuf;   //assumption if unable to close connection because it already been closed
        }
        n++;
    }
    return gprsRxBuf;
    
    /*
    while(1) {
        //sim900.printf("AT+CIPSTART=1,\"TCP\",\"%s\",%d\r\n",host.c_str(),port);
        gprsRcvReply(r,3000);
        //DBG.printf("rspn[CIPSTART]:%s",r);
        DBG.printf("[CIPSTART]\r\n");
        str = r;
        if(str.find("CONNECT OK") != std::string::npos) {
            break;    
        }
        if(n>5) {
            return "ERROR:CIPSTART"; //unable to start connection
        }
        n++;
    }
    
    //AT+CIPSEND
    sim900.printf("AT+CIPSEND=1,%d\r\n",data.length());
    gprsRcvReply(r,1000);
    //DBG.printf("rspn[CIPSEND]:%s",r);
    DBG.printf("[CIPSEND]\r\n");
    
    str = r;
    if(str.find(">") != std::string::npos) {
        sim900.printf("%s",data.c_str());
        gprsRcvReply(rLong,10000);
        //DBG.printf("rspn[>]:%s\r\n",rLong);
        DBG.printf("[>]\r\n");
    }
    else {
        return "ERROR:>";   //unable to send data
    }
    
    //close connection (case for get request)
    str = rLong;
    if(str.find("CLOSED") != std::string::npos) {
        return rLong;
    }
    
    //close connection
    n=0;
    while(1) {
        sim900.printf("AT+CIPCLOSE=1,1\r\n");
        gprsRcvReply(r,3000);
        //DBG.printf("rspn[CIPCLOSE]:%s\r\n",r);
        DBG.printf("[CIPCLOSE]\r\n");
        str = r;
        if(str.find("CLOSE OK") != std::string::npos) {
            break;    
        }
        if(n>3) {
            //return "ERROR:CIPCLOSE"; //unable to close connection
            return rLong;   //assumption if unable to close connection because it already been closed
        }
        n++;
    }
    return rLong;
    */
}
void gprsRcvReply(char *r, int to) {
    Timer t;
    bool ended = false;
    char c;
    
    strcpy(r,"");
    t.start();
    while(!ended) {
        if(sim900.readable()) {
            c = sim900.getc();
            addChar(r,c);
            t.start();
        }
        if(t.read_ms() > to) {
            ended = true;    
        }    
    }
    addChar(r, 0x00);
}

/*end gprs rest*/

/*start emma settings*/
string getUID(void) {
    char s[32];
    unsigned long *unique = (unsigned long *)BASE_ADDR;
    sprintf(s,"%08x%08x%08x",unique[0], unique[1], unique[2]);
    return s;    
}

string readSetting(string parameter) {
    FILE *fp;
    signed char c;
    int i=0;
    char s[64];
    string strS;
    
    sprintf(s,"/sd/settings/%s.txt",parameter.c_str());
    
    fp = fopen(s,"r");
    memset(s,0,sizeof(s));
    if(fp != NULL) {
        while(1) {
            c = fgetc(fp);
            if(c == EOF){
                break;
            }
            s[i] = c;
            i++;
        }
        strS = s;
        if(strS.find("(") != std::string::npos && strS.find(")") != std::string::npos) {
            strS.erase(strS.begin(),strS.begin()+strS.find("(")+1);
            strS.erase(strS.begin()+strS.find(")"),strS.end());
        } else {
            strS = "";    
        }
        fclose(fp);
        free(fp);
    }
    return strS;    
}

bool writeSetting(string parameter, string value) {
    FILE *fp;
    char s[255];
    
    sprintf(s,"/sd/settings/%s.txt",parameter.c_str());
    fp = fopen(s,"w");
    if(fp != NULL) {
        fprintf(fp,value.c_str());
        fclose(fp);
        free(fp);
        return true;
    }
    return false;
}
/*end emma settings*/

/*start emma nodes*/
string readNodeIP(string macAddr) {
    FILE *fp;
    signed char c;
    int i=0;
    char s[64];
    string strS;
    
    sprintf(s,"/sd/nodeList/%s/nodeIP.txt",macAddr.c_str());
    
    fp = fopen(s,"r");
    memset(s,0,sizeof(s));
    if(fp != NULL) {
        while(1) {
            c = fgetc(fp);
            if(c == EOF){
                break;
            }
            s[i] = c;
            i++;
        }
        strS = s;
        if(strS.find("(") != std::string::npos && strS.find(")") != std::string::npos) {
            strS.erase(strS.begin(),strS.begin()+strS.find("(")+1);
            strS.erase(strS.begin()+strS.find(")"),strS.end());
        } else {
            strS = "";    
        }
        fclose(fp);
        free(fp);
    }
    return strS;
}

string readNodeCmd(string dType, string cmdKey) {
    FILE *fp;
    signed char c;
    int i=0;
    char s[2048];
    string strS;    //default value must be empty
    
    sprintf(s,"/sd/nodeCode/%s/%s.txt",dType.c_str(),cmdKey.c_str());
    
    fp = fopen(s,"r");
    memset(s,0,sizeof(s));
    if(fp != NULL) {
        while(1) {
            c = fgetc(fp);
            if(c == EOF){
                break;
            }
            s[i] = c;
            i++;
        }
        strS = s;
        if(strS.find("(") != std::string::npos && strS.find(")") != std::string::npos) {
            strS.erase(strS.begin(),strS.begin()+strS.find("(")+1);
            strS.erase(strS.begin()+strS.find(")"),strS.end());
        } else {
            strS = "";    
        }
        fclose(fp);
        free(fp);
    }
    return strS;    
}

bool writeNodeCmd(string dType, string cmdKey, string cmdCode) {
    FILE *fp;
    char s[255];
    
    sprintf(s,"/sd/nodeCode/%s/%s.txt",dType.c_str(),cmdKey.c_str());
    fp = fopen(s,"w");
    if(fp != NULL) {
        fprintf(fp,cmdCode.c_str());
        fclose(fp);
        free(fp);
        return true;
    }
    return false;
}

bool isExistNodeCmd(string dType, string cmdKey) {
    FILE *fp;
    char s[255];
    
    sprintf(s,"/sd/nodeCode/%s/%s.txt",dType.c_str(),cmdKey.c_str());
    fp = fopen(s,"r");
    if(fp != NULL) {
        fclose(fp);
        free(fp);
        return true;
    }
    return false;
}

string *readNodeList(void) {
    static string nd[10];   //max node
    DIR *d;
    struct dirent *p;
    string q;
    int i=0;
    
    d = opendir("/sd/nodeList");
    if(d != NULL) {
        while((p = readdir(d)) != NULL) {
            q = p->d_name;
            nd[i] = q;
            i++;    
        }
        closedir(d);
        free(d);    
    }
    return nd;
}

string wifiGetNodeTemp(string macAddr) {
    int trial=0;
    string nodeIP = readNodeIP(macAddr);
    string str;
    string temp = "0";
    
    if(rest.begin(nodeIP.c_str(),REMOTE_TCP_PORT,false)) {
        while(1) {
            char rcv[256] = {};
            rest.get("/","<?xml version=\"1.0\" encoding=\"utf-8\"?><app_cmd cmd=\"2\"/>\r\n");
            rest.getResponse(rcv,sizeof(rcv));
            str = rcv;
            if(str.find("temp=") != std::string::npos) {
                str.erase(str.begin(),str.begin()+str.find("temp=")+6);
                str.erase(str.begin()+str.find("\""),str.end());
                temp = str;
                break;
            }
            if(trial>1) {   //three times trial
                break;    
            }
            trial++;
            wait(2);
        }
    }
    return temp;
}
/*end emma nodes*/

/*start emma lcd*/
void lcdDrawSmile(void) {
    TFT.fillarc(120, 40, 20, 10, 290, 70, Green);   //left eye
    TFT.fillarc(200, 40, 20, 10, 290, 70, Green);   //right eye
    TFT.fillarc(160, 60, 85, 10, 120, 240, Green);  //mouth
}

void lcdDrawFrown(void) {
    TFT.fillarc(120, 40, 20, 10, 110, 250, colorDarkGray);    //left eye
    TFT.fillarc(200, 40, 20, 10, 110, 250, colorDarkGray);    //right eye
    TFT.fillarc(160, 200, 85, 10, 315, 45, colorDarkGray);     //mouth
}

//void lcdPrintRestart(void) {
//    
//}
/*end emma lcd*/

/*start emma private function*/
void isEthAvailable(void) {
    //if(ipstack.getEth().linkstatus()) {
    if(eth.linkstatus()) {
        ethAvailable = true;    
    } else {
        ethAvailable = false;    
    }
}

void isEthConnected(void) {
    char s[512];
    int connPort;
    string connHost;
    string str;
    Timer t;
    
    eth.init(); //init ethernet
    eth.connect();
    
    if(ethAvailable) {
        if(useProxy) {
            connHost = proxySERVER;
            connPort = proxyPORT;
            //for(int i=0; i<sizeof(s); i++) {
            //    s[i]=0; }
            sprintf(s,"GET http://%s:%d/%s/api/controller/test HTTP/1.0\nHost: %s\r\n\r\n",restSERVER.c_str(),restPORT,appNAME.c_str(),restSERVER.c_str());
        } else {
            connHost = restSERVER;
            connPort = restPORT;
            //for(int i=0; i<sizeof(s); i++) {
            //    s[i]=0; }
            sprintf(s,"GET /%s/api/controller/test HTTP/1.0\nHost: %s\r\n\r\n",appNAME.c_str(),restSERVER.c_str());
        }
        
        t.start();
        while(1) {
            str = ethREST(connHost,connPort,s);
            if(str.find("\"status\":\"OK\"") != std::string::npos) {
                t.stop();
                ethConnected = true;
                break;    
            }
            if(t.read_ms() > 5000) {
                t.stop();
                ethConnected = false;
                break;    
            }
        }
    } else {
        ethConnected = false;    
    }
}

void isWiFiConnected(void) {    //WARNING: should be run in emmaModeRegister and emmaModeOperation only - limitation with esp, after MODE=B, cannot go to MODE=S
    char s[512];
    int connPort;
    string connHost;
    string str;
    Timer t;
    
    /*
    esp.enable();
    wait(1);
    esp.reset();
    wait(1);
    while(!esp.ready());
    
    //rest begin
    if(!rest.begin(restSERVER,restPORT,false)) {
        DBG.printf("EMMA: fail to setup rest\r\n");
        TFT.locate(0,20);
        TFT.printf("EMMA: fail to setup rest");
        while(1);    
    }
    
    //setup wifi
    DBG.printf("EMMA: setup wifi\r\n");
    TFT.locate(0,20);
    TFT.printf("EMMA: setup wifi");
    wait(1);
    esp.wifiCb.attach(&wifiCb);
    //esp.wifiConnect("Tritronik Mobile","Tri12@11");
    esp.wifiConnect(wifiSSID.c_str(),wifiPASS.c_str());
    DBG.printf("EMMA: system started\r\n");
    TFT.locate(0,20);
    TFT.printf("EMMA: system started");
    t.start();
    while(t.read() < 20);
    t.stop();
    t.reset();
    TFT.locate(0,20);
    TFT.printf("                                        ");
    */
    
    if(wifiAvailable) {
        _ESP.printf("MODE=B");
        if(useProxy) {
            connHost = proxySERVER;
            connPort = proxyPORT;
            //for(int i=0; i<sizeof(s); i++) {
            //    s[i]=0; }
            sprintf(s,"http://%s:%d/%s/api/controller/test HTTP/1.0\nHost: %s\r\n\r\n",restSERVER.c_str(),restPORT,appNAME.c_str(),restSERVER.c_str());
        } else {
            connHost = restSERVER;
            connPort = restPORT;
            //for(int i=0; i<sizeof(s); i++) {
            //    s[i]=0; }
            sprintf(s,"/%s/api/controller/test",appNAME.c_str());
        }
        wait(2);
        t.start();
        while(!esp.ready() && t.read() < 20);
        t.stop();
        t.reset();
        if(rest.begin(connHost.c_str(),connPort,false)) {
            //DBG.printf("rest begin\r\n");
            esp.process();
            rest.get(s);
            //for(int i=0; i<sizeof(s); i++) {
            //    s[i]=0; }
            rest.getResponse(s,sizeof(s));
            str = s;
            DBG.printf("response:%s\r\n",s);
            if(str.find("\"status\":\"OK\"") != std::string::npos) {
                wifiConnected = true;
            }
        } else {
            wifiConnected = false;    
        }
    } else {
        wifiConnected = false;    
    }
}

void isGprsConnected(void) {
    char cmd[256];
    int connPort;
    string str;
    
    DBG.printf("isGprsConnected\r\n");
    gprsReset();
    //str = gprsInit(gprsAPN);
    str = gprsInitAnimate(gprsAPN);
    //DBG.printf("str:%s\r\n",str.c_str());
    if(str.find("ERROR") != std::string::npos) {
        gprsConnected = false;    
    } else {
        if(str.find("AT+CIFSR") != std::string::npos) {
            str.erase(str.begin(),str.begin()+str.find("AT+CIFSR")+10);
            str.erase(str.end()-2,str.end());
            DBG.printf("IP Addr:%s\r\n",str.c_str());
            //test connection
            connPort = restPORT;
            sprintf(cmd,"GET /%s/api/controller/test HTTP/1.0\nHost: %s:%d\n\n\n\n%c",appNAME.c_str(),restSERVER.c_str(),connPort,26);
            //str = gprsREST(restSERVER,connPort,cmd);
            str = gprsRESTAnimate(restSERVER,connPort,cmd);
            DBG.printf("str:%s\r\n",str.c_str());
            if(str.find("\"status\":\"OK\"") != std::string::npos) {
                gprsConnected = true;
            } else {
                gprsConnected = false;
            }
        } else {
            gprsConnected = false;    
        }
    }
}

void addChar(char *s, char c) {
    uint16_t k;     //customized for EMS
    k = strlen(s);
    s[k] = c;
    s[k + 1] = 0;
}

string calculateMD5(string text) {
    char s[64];
    memset(s,0,sizeof(s));  //for unknown reason, after reading UID, the 's' will contaion UID data
    uint8_t hash[16];
    MD5::computeHash(hash, (uint8_t*)text.c_str(), strlen(text.c_str()));
    for(int i=0; i<16; ++i) {
        sprintf(s,"%s%02x",s,hash[i]);
    }
    return s;
}

bool writeFirmwareHexToChar(string value) {
    FILE *fp;
    char s[32];
    int number;
    string chunk;
    
    sprintf(s,"/sd/newFirmware/firmware.bin");
    fp = fopen(s,"a");
    if(fp != NULL) {
        for(int ch=0; ch<value.size(); ch+=2) {
            chunk = value.substr(ch,2);
            sscanf(chunk.c_str(),"%x",&number);
            fprintf(fp,"%c",number);
        }
        fclose(fp);
        free(fp);
        return true;
    }
    return false;
}

bool clearFirmware(void) {
    FILE *fp;
    char s[32];
    
    sprintf(s,"/sd/newFirmware/firmware.bin");
    fp = fopen(s,"w");
    if(fp != NULL) {
        fprintf(fp,"");
        fclose(fp);
        free(fp);
        return true;
    }
    return false;
}

bool writeLog(string logTime, string logData) {
    FILE *fp;
    char s[255];
    string logAll;
    logAll = logTime + "\t" + logData + "\r\n";
    
    sprintf(s,"/sd/log.txt");
    fp = fopen(s,"a");
    if(fp != NULL) {
        fprintf(fp,logAll.c_str());
        fclose(fp);
        free(fp);
        return true;
    }
    return false;    
}

bool writeDbg(string dbgTime, string dbgData) {
    FILE *fp;
    char s[255];
    string dbgAll;
    dbgAll = dbgTime + "\t" + dbgData + "\r\n";
    
    sprintf(s,"/sd/dbg.txt");
    fp = fopen(s,"a");
    if(fp != NULL) {
        fprintf(fp,dbgAll.c_str());
        fclose(fp);
        free(fp);
        return true;
    }
    return false;    
}
/*end emma private function*/