#ifndef MBED_EMMACODE_H
#define MBED_EMMACODE_H

#include "mbed.h"
#include "espduino.h"           //wifi rest and mqtt
//#include "mqtt.h"               //wifi mqtt
#include "rest.h"               //wifi rest
//#include "MQTTClient.h"         //eth mqtt
//#include "MQTTEthernet.h"       //eth mqtt
#include "EthernetInterface.h"  //eth rest
#include "SoftSerial.h"         //gprs rest and other software serial
#include "MbedJSONValue.h"      //json
#include "SDFileSystem.h"       //sd card
#include "Crypto.h"             //hash calculation
#include "cmsis_os.h"           //threads
#include "ade7758.h"            //ade7758
#include "SPI_TFT_ILI9341.h"    //lcd
#include "Touch.h"              //touch
#include "Arial12x12.h"         //font
#include "Lato19x19.h"          //good
#include "Lato24x23.h"          //good
#include "Lato27x27.h"          //good
#include "LatoBlack34x32.h"     //good
#include "LatoBlack39x38.h"     //good
#include "SetRTC.h"             //rtc
#include "DHT11.h"              //dht11
#include <string>

//platform
#if defined TARGET_NUCLEO_F103RB
#define BASE_ADDR 0x1FFFF7E8
#elif defined TARGET_NUCLEO_F401RE
#define BASE_ADDR 0x1FFF7A10
#endif

//mode
#define MODE_WIFI_CONFIG        0x00    //wifi config
#define MODE_SETTINGS           0x01    //settings
#define MODE_REGISTER           0x02    //registration
#define MODE_OPERATION          0x03    //operational
#define MODE_FIRMWARE_DOWNLOAD  0x04    //firmware download
#define MODE_RESERVED           0x05    //reserved as sandbox

//interface
#define IF_WIFI         0x00
#define IF_ETH          0x01
#define IF_GPRS         0x02

//wifi
#define ESP_BAUD    19200

//mqtt
#define MQTT_MAX_PACKET_SIZE    250 //for eth
//#define MQTT_HOST               "36.80.35.8"
//#define MQTT_PORT               1883

//eth rest
#define SERVER_PORT             80

//nodes and remote
#define REMOTE_TCP_PORT         16038
#define NODES_MAX               5
#define NODES_INVALID           99

//emma server
//#define REST_SERVER_HOST        "36.80.35.8"
//#define REST_SERVER_PORT        8080

//ade7758 offset
#define AIRMSOFFSET     0xFB1
#define BIRMSOFFSET     0xFB0
#define CIRMSOFFSET     0xFB1
#define AVRMSOFFSET     0xFFB
#define BVRMSOFFSET     0x2
#define CVRMSOFFSET     0xFFF

//threshold //need to be deleted
#define _vrmsTHL         175
#define _vrmsTHH         200//265
#define _wattTHL         26400
#define _wattTHH         39600

//modeCircle
#define leftCircle      0
#define rightCircle     1

/*start lcd and touch*/
int emmaModeSelection(void);
/*end lcd and touch*/

/*start emma read settings*/
void emmaReadSettings(void);
/*end emma read settings*/

/*start emma mode*/
void emmaInit(int mode);
void emmaModeWiFiConfig(void);
void emmaModeSettings(void);
void emmaModeRegister(void);
void emmaModeOperation(void);
void emmaModeFirmwareDownload(void);
void emmaModeReserved(void);
/*end emma mode*/

/*start energy related*/
void energyThread(void const*);
void checkVoltagePower(void);
/*end energy related*/

/*start eth mqtt*/
//int publish(MQTT::Client<MQTTEthernet, Countdown, MQTT_MAX_PACKET_SIZE>* client, MQTTEthernet* ipstack);
//void ethMQTTMessageArrived(MQTT::MessageData& md);
//int ethMQTTConnect(MQTT::Client<MQTTEthernet, Countdown, MQTT_MAX_PACKET_SIZE>* client, MQTTEthernet* ipstack);
//void ethMQTTAttemptConnect(MQTT::Client<MQTTEthernet, Countdown, MQTT_MAX_PACKET_SIZE>* client, MQTTEthernet* ipstack);
/*end eth mqtt*/

/*start eth rest*/
string ethREST(string host, int port, string data);
/*end eth rest*/

/*start wifi mqtt*/
void mqttConnected(void* response);
void mqttDisconnected(void* response);
/*end wifi mqtt*/

/*start wifi rest*/
void wifiCb(void* response);
void rxInterrupt(void);
void checkRxBuffer(void);
void wifiRcvReply(char *r, int to);
/*end wifi rest*/

/*start gprs rest*/
void gprsReset(void);
void gprsRxInterrupt(void);
string gprsInit(string APN);
string gprsInitAnimate(string APN);
string gprsREST(string host, int port, string data);
string gprsRESTAnimate(string host, int port, string data);
void gprsRcvReply(char *r, int to);
/*end gprs rest*/

/*start emma settings*/
string getUID(void);
string readSetting(string parameter);
bool writeSetting(string parameter, string value);
/*end emma settings*/

/*start emma nodes*/
string readNodeIP(string macAddr);
string readNodeCmd(string dType, string cmdKey);
bool writeNodeCmd(string dType, string cmdKey, string cmdCode);
bool isExistNodeCmd(string dType, string cmdKey);
string *readNodeList(void);
string wifiGetNodeTemp(string macAddr);
/*end emma nodes*/

/*start emma lcd*/
void lcdDrawSmile(void);
void lcdDrawFrown(void);
//void lcdPrintRestart(void);
/*end emma lcd*/

/*start emma private function*/
void isEthAvailable(void);
void isEthConnected(void);
void isWiFiConnected(void);
void isGprsConnected(void);
void addChar(char *s, char c);
string calculateMD5(string text);
bool writeFirmwareHexToChar(string value);
bool clearFirmware(void);
bool writeLog(string logTime, string logData);
bool writeDbg(string dbgTime, string dbgData);
/*end emma private function*/

#endif