#include "mbed.h"

/*
    vrijeme DA pretvorbe iznosi 1.75us
    DA pretvorba LPC 1768 ima 10 bitnu rezoluciju i max frekvencija osvježenja je 1MHz
    
*/

AnalogOut Aout(p18);  //definira analogni izlaz na pinu 18
DigitalOut led(LED1);  //signalizacijska ledica

Timer t;
Serial pc(USBTX, USBRX);   // serijska komunikacija prema racunalu

const float ADCdata = 0.5;
const int broj_pretvorbi = 100000;

int main() {
    
    led = 1;
    wait(0.2);
    led = 0;
    wait(0.5);
    led = 1;
    wait(0.5);
    led = 0;
    wait(2);
    
    while(true) {
        
        led = 1;
        t.start();   //pokreni timer
        
        //zapocni pretvorbu i ponavljaj broj_pretvorbi puta
        for(int i = 0; i<broj_pretvorbi; i++) {
        
            Aout = ADCdata;   //pokreni DA pretvorbu, postavi vrijeme napona na analogni izlaz
                    
        }
        
        t.stop();   //zaustavi timer
        led = 0;
        
        pc.printf("Vrijeme jedne pretvorbe: %.2f us\n", (float)t.read_us()/broj_pretvorbi);
        t.reset();   //resetiraj timer na nulu
        
        //signalizacijske ledice
        wait(2);
        led = 1;
        wait(0.2);
        led = 0;
        wait(0.5);
        led = 1;
        wait(0.2);
        led = 0;
        wait(2);
    }
}
