#include "mbed.h"

/*
    vrijeme AD pretvorbe iznosi 20.85us
    AD pretvorba LPC 1768 ima 12 bitnu rezoluciju i max frekvencija osvježenja je 200Hz
    
    vrijeme AD pretvorbe bi trebala iznositi 5us, ali zbog funkcije read() radi tri puta uzorkovanje
    pa vraća srednju vrijednost, to uzima barem 15us, ostatak je nesavršenost i ostatak operacija
    
*/

AnalogIn Ain(p20);   //definira analogni ulaz na pinu 20
DigitalOut led(LED1);   //signalizacijska ledica
Timer t; 
Serial pc(USBTX, USBRX);    // serijska komunikacija prema racunalu

float ADCdata;
const int broj_pretvorbi = 100000;

int main() {
    
    led = 1;
    wait(0.2);
    led = 0;
    wait(0.5);
    led = 1;
    wait(0.2);
    led = 0;
    wait(2);
    
    while(true) {
        
        led = 1;
        t.start();   //pokreni timer
        
        //zapocni pretvorbu i ponavljaj broj_pretvorbi puta
        for( int i= 0; i<broj_pretvorbi; i++) {
            
            ADCdata = Ain;   //pokreni AD pretvorbu i pohrani uzorkovanu vrijednost napona u varijablu ADCdata
            
        }
        
        t.stop();   //zaustavi timer
        led = 0;
        
        pc.printf("Vrijeme jedne pretvorbe: %.2f us \n",(float)t.read_us()/broj_pretvorbi);
        t.reset();   //resetiraj timer na nulu
        
        //signalizacijske ledice        
        wait(2);
        led = 1;
        wait(0.2);
        led = 0;
        wait(0.5);
        led = 1;
        wait(0.2);
        led = 0;
        wait(2);
    }
}