#include "mbed.h"

/*
    generator signala generira sinusni naponski signal frekvencije 50Hz, 
    amplitude od vrha do vrha 2V, vertikalno pomaknut za 1.5V, odnosno donji vrh za 0.5V od 0
    
    vrijeme AD pretvorbe izmjereno: 20.85us
    vrijeme DA pretvorbe izmjereno: 1.75us
    ukupno min vrijeme pretvorbe T = 20.85us + 1.75us = 22.6us
    prema tome bi izračunata max frekvencija uzorkovanja bila jednaka: 
    f = 1/T = 1/0.0000226s = 44247.87Hz ???
    
    drugi dio zadatka zahtjeva da nam je frekvencija uzorkovanja približno 500Hz
    za to trebamo izračunati vrijeme uzorkovanja i postaviti u wait() funckiju
    T = 1/500Hz = 2ms
    
    granična frekvencija iznosi f = fs/2 = 500Hz/2 = 250Hz,
    kod granične frekvencije dobijemo točno 2 uzorka i možemo rekonstruirati signal,
    odnosno broj uzoraka je jednak: uzorci = frekvencija uzorkovanja / frekvencija ulaznog signala
    
    pošto nam je frekvencija ulaznog signala generator signala, smanjenjem frekvencije na
    generatoru dobijemo više uzoraka, ako prođemo frekvenciju iznad frekvencije uzorkovanja, 
    dolazi do aliasinga
    
    ako povečamo frekvenciju ulaznog signala na istu vrijednost frekvencije uzorkovanja,
    dobijemo samo 1 uzorak, odnosno dobijemo samo ravnu crtu 
*/

AnalogOut Aout(p18);
AnalogIn Ain(p20);

int main() {
    
    float ADCdata;
    
    while(true) {
        
        ADCdata = Ain;   //pokreni AD pretvorbu, spremi uzorak u varijablu ADCdata
        
        Aout = ADCdata;   //prebaci vrijednosti iz ADCdata u DA pretvornik i pokreni DA pretvorbu
        
        //wait(0.002);   //podesavanje vremena uzorkovanja
        
    }
}
