#include "mbed.h"

/*
    možemo izračunati da nam je promjena 3.3V / 2000 = 1.65mV
    ali LPC 1768 ne može izmjeriti toliko malu promjenu
    pošto je LPC 10 bitni, odnosno njegova rezolucija je 10 bitna, 
    najmanja promjena koju može izmjeriti je 3.3V / 2^10 = 3.22mV
    
    ovo možemo vidjeti ako izlaz pina p18 spojimo na voltmetar i stavimo "wait(5)",
    osim ako netko može očitati i zapisati dvije vrijednosti u roku 1s
    
    da bismo mogli vidjeti manje promjene, potreban nam je mbed sa 
    većom bit rezolucijom
    
*/

AnalogOut aout (p18);
float i;

int main() {

    while(true){
        
        //postavljanje uzlazećeg brida
        for( i=0; i<1; i=i+0.0005){
            
            aout = i;
            wait(1);   
            
            }
            
        //postavljanje padajućeg brida
        for( i=1; i>0; i=i-0.0005){
            
            aout = i;
            wait(1);
            
            }
        
    }    
}