#include "mbed.h"

/*

    BusOut je naredba kojom se definira stanje pina ili u našem slučaju ledica,
    te se također može očitati stanje tih pinova ili ledica.
    BusOut se može koristiti na bilo kojem pinu označen plavom bojom ali i 
    na mbedu, poput ledica.
    
    Vrijednosti ledica su 1 2 4 8 počevši od LED1 do LED4, obrnuto od binarnog.
    Najznačajniji bit je bit LED4, a najmanje značajan LED1.
    
    Stanje pina/ledica se definira na dva načina:
    sabirnica.write(broj) ili sabirnica = broj

*/
BusOut sabirnica(LED1, LED2, LED3, LED4);   //inicijalizacija kao polje

int main() {
 
    while(true) {
        
        sabirnica.write(1);   //vrijednost LED1 je 1, pa će se upaliti skroz lijeva ledica, binarno 0001
        
        wait(1); 
        sabirnica = 2;   //pali se i druga ledica, binarno 0010
        
        wait(1);
        sabirnica = sabirnica.read() + 1;   //sabirnica = .read(2)+1=3, pale se LED1 i LED2, binarno 0011
        
        wait(1);
        int sab = sabirnica;   //sab = 3
        sabirnica = sab + 3;   //sabirnica = 3 + 3, pale se LED2 i LED3, binarno 0110
        
        wait(1);
        sabirnica = 0b1111;   //0b = binarni zapis, imamo binarno 1111, odnosno broj 15, pale se sve ledice
         
        wait(1);
        sabirnica[0] = 0;   //polje[0] = 0, gasi se LED1, binarno 1110
        
        wait(1);
    }
}