/*U trećoj vježbi zadatak je bio kontinuirano slati 4-bitni podatak preko paralelne komunikacijske linije s
master mbeda na slave mbed. 4-bitni podatak zadaje se položajem sklopki S0 (pin20) do S3 (pin17), gdje
sklopka S0 predstavlja najmanje značajni bit, a S3 najznačajniji bit.
Za razliku od zadatka u prvoj vježbi u ovom zadatku će se koristiti SPI serijska komunikacijska veza (u prvoj
vježbi koristila se paralelna komunikacija).
Zadatak je ostvariti SPI komunikaciju između dva mbeda i preko nje poslati 4-bitni podatak zadan položajem
sklopki S0 do S1 na slave mbed. Analogno kao i u prvoj vježbi, LEDice LED1 do LED4 na master mbedu
palite prema položaju sklopki S0 do S3. Na slave mbedu prikazujte poslani podatak na diodama LED1 do
LED4.
Neka master šalje podatke na slave s razmakom od 100 ms.
Spojite master i slave mbed prema shemi na slici 5. MISO liniju za sada nemojte spajati! */

#include "mbed.h"

//master

BusOut ledice(LED4,LED3,LED2,LED1);
BusIn  datain(p20,p19,p18,p17);
BusOut lediceo(p21,p22,p23,p24);
SPI spi_port(p5, p6, p7);   // mosi, miso, sclk
DigitalOut ss(p8);   //slave select pin

int main() {

    spi_port.format(4,1); // 8 bitni okvir, mod rada 0
    spi_port.frequency(1000000); // frekvencija takta 1MHz
    datain.mode(PullUp);

    while(1){

        ledice=datain;
        ss=0;
        spi_port.write(datain);
        //pi_port.write(lediceo);
        ss=1;
        wait_ms(100);
        
        }
}