#include "mbed.h"

//slave program

SPISlave spi_port(p5, p6, p7, p8); // mosi, miso, sclk, ssel
Serial pc(USBTX, USBRX); // tx, rx

int main() {

   int podatak, temp;
   bool gornji_dio = true, prijenos = false;

   spi_port.format(16,0);   // 8 bitni okvir, mod rada 0
   spi_port.frequency(1000000);   // frekvencija takta 1MHz

   while (true){

     if (spi_port.receive()){   //cekaj da master posalje podatak
        temp = spi_port.read();

        if (temp == 0xF0F0){
            prijenos = true;
            continue;
        }

        if (prijenos) {
            if (gornji_dio) {   //ako je to prvi prijenos, tj. gornja 2 bajta
                podatak = temp << 16;
                gornji_dio = false;
            }

            else {   //inace je drugi prijenos, tj. donja 2 bajta
                podatak = podatak | 0x0000FFFF & temp;
                pc.printf("Podatak na slaveu: %x\n",podatak);
                gornji_dio = true;
                prijenos = false;
            }
        }
     }
  } 
}