#include "mbed.h"
 
PwmOut speaker(p26);
AnalogIn pot1(p19);
AnalogIn pot2(p20);
DigitalIn joystickCenter(p14);
 
int main() {
    /* note frequencies in Hz
    * rows: C C# D Eb E F F# G G# A Bb B
    * columns: 0 1 2 3 4 5 6 7 8
    */
    enum noteNames {A3, E4, GH4, A4, B4, CH5, DH5, E5, FH5, GH5, A5, B5, CH6, DH6, E6, FH6, GH6, A6, B6, CH7, DH7, E7, B7};
    float nt[23][9] = { {220.0}, {329.63}, {415.30}, {440.0}, {493.88}, {554.37}, {622.25}, {659.25}, {739.99}, {830.61}, {880.0}, {987.77}, {1108.73},
                        {1244.51}, {1318.51}, {1479.98}, {1661.22}, {1760.0}, {1975.53}, {2217.46}, {2489.02}, {2637.02}, {3951.07} };
    for (int i = 0; i < 12; i++) 
        for (int j = 1; j < 9; j++) 
            nt[i][j] = nt[i][j-1] * 2;
    
    while(1) {
        int scale = 0 * 8;
        float speed = 0.05 + pot1;
        float notesHere_with_you[] = {nt[E6][scale], 0, nt[E7][scale], 0, nt[DH7][scale], 0, nt[E6][scale], 0, nt[CH7][scale], 0, nt[A5][scale], 0,
                                nt[B4][scale], 0, nt[FH5][scale], 0, nt[FH6][scale], 0, nt[E6][scale], 0, nt[DH6][scale], 0, nt[E5][scale], 0, nt[DH5][scale], 0,
                                nt[CH5][scale], 0, nt[E7][scale], 0, nt[DH7][scale], 0, nt[E6][scale], 0, nt[CH7][scale], 0, nt[A5][scale], 0, nt[B4][scale], 0,
                                nt[FH5][scale], 0, nt[B5][scale], 0, nt[E6][scale], 0, nt[DH6][scale], 0, nt[B5][scale], 0, nt[A3][scale], 0, nt[E4][scale], 0,
                                nt[CH6][scale], 0, nt[E5][scale], 0, nt[DH6][scale], 0, nt[E5][scale], 0, nt[E6][scale], 0, nt[E5][scale], 0, nt[B5][scale], 0,
                                nt[E4][scale], 0, nt[GH4][scale], 0, nt[B4][scale], 0, nt[E5][scale], 0, nt[A3][scale], 0, nt[E4][scale], 0, nt[CH6][scale], 0,
                                nt[E5][scale], 0, nt[DH6][scale], 0, nt[E5][scale], 0, nt[E6][scale], 0, nt[E5][scale], 0, nt[E6][scale], 0, nt[FH6][scale], 0,
                                nt[B6][scale], 0, nt[GH6][scale], 0, nt[E5][scale], 0, nt[GH6][scale], 0, nt[CH6][scale], 0, nt[DH6][scale], 0, nt[E6][scale], 0,
                                nt[A3][scale], 0, nt[A4][scale], 0, nt[A3][scale], 0, nt[E4][scale], 0, nt[E5][scale], 0, nt[B5][scale], 0, nt[E6][scale], 0,
                                nt[B6][scale], 0, nt[A6][scale], 0, nt[E7][scale], 0, nt[E6][scale], 0, nt[A6][scale], 0, nt[E7][scale], 0, nt[B7][scale], 0};
        float beatHere_with_you[] =  {2, 0.5, 2, 0.5, 2, 0.5, 2, 0.5, 4, 0.5, 4, 0.5, 2, 0.5, 2, 0.5, 0.25, 0.5, 2.75, 0.5, 1, 0.5, 5, 0.5, 2, 0.5, 2, 0.5, 2, 0.5, 2, 0.5,
                                2, 0.5, 4, 0.5, 4, 0.5, 2, 0.5, 2, 0.5, 2, 0.5, 2, 0.5, 4, 4, 0.5, 4, 0.5, 2, 0.5, 2, 0.5, 2, 0.5, 2, 0.5, 2, 0.5, 2, 0.5, 2, 0.5, 2, 0.5, 
                                2, 0.5, 2, 0.5, 2, 0.5, 2, 0.5, 4, 0.5, 2, 0.5, 2, 0.5, 2, 0.5, 2, 0.5, 2, 0.5, 2, 0.5, 2, 0.5, 2, 0.5, 0.25, 0.5, 1.25, 0.5, 
                                2, 0.5, 2, 0.5, 2, 0.5, 2, 0.5, 2, 0.5, 2, 0.5, 2, 0.5, 1, 0.5, 1, 0.5, 2, 0.5, 2, 0.5, 1, 0.5, 3, 0.5, 2, 0.5, 2, 0.5, 2, 0.5, 2, 0.5,
                                2, 0.5, 2, 0.5, 2, 0.5, 2, 4, 4 };
        wait(4);
        
        for (int i = 0; i < 100; i++) {
            speaker.period(1 / (2*notesHere_with_you[i]) );
            speaker = 0.5;
            wait(speed * beatHere_with_you[i]);
        }
        if (joystickCenter) // press joystick center to stop playing
            break;
    }
}