#include "mbed.h"
#include "RemoteIR.h"
#include "ReceiverIR.h"
#include "TB6612FNG.h"
#include "TRSensors.h"
#include "ultrasonic.h"
#include "Adafruit_SSD1306.h"
#include "WS2812.h"
#include "PixelArray.h"

#define button_SENSORS 5
#define ADT7420_TEMP_REG (0x00)
#define ADT7420_CONF_REG (0x03)
#define EVAL_ADT7420_ADDR (0x48)
#define PCF8574_ADDR (0x20)
#define WS2812_BUF 100
#define WS2812_BUF2 4
#define NUM_COLORS 3
#define NUM_LEDS_PER_COLOR 4

// create object
DigitalOut dc(D8,1);
DigitalOut rst(D9,1);
I2C i2c(I2C_SDA, I2C_SCL);
TB6612FNG motorDriver(D6, A1, A0, D5, A2, A3);
Ultrasonic ultra(D3, D2, .1, false);
ReceiverIR IR(D4);
TRSensors trs;
RawSerial pc(USBTX, USBRX, 115200);
Adafruit_SSD1306_I2c gOled2(i2c,D9,0x7A,64,128);
Timer timer;
PixelArray px(WS2812_BUF);
WS2812 ws(D7, WS2812_BUF, 7, 15, 10, 15);


volatile int button = 0;

// PID variables
static float pval = 0;

// motor Driver
float fPwmAPeriod;
float fPwmAPulsewidth;
float fPwmBPeriod;
float fPwmBPulsewidth;

inline void update_display(){
                gOled2.clearDisplay();
                gOled2.setTextCursor(0,0);
                gOled2.printf("E-RON alphabot\r\n");
                gOled2.printf("P: %.2f\r\n",pval);
                gOled2.display();
}

int colorbuf[NUM_COLORS] = {0xff0000,0x00ff00,0x0000ff};
int colorbuf3 =0x000000;
    
int main()
{
          
    for (int i = 0; i < WS2812_BUF; i++) {
        px.Set(i, colorbuf[(i / NUM_LEDS_PER_COLOR) % NUM_COLORS]);
    }
    
    for (int j=0; j<WS2812_BUF; j++) {
        // px.SetI(pixel position, II value)
        px.SetI(j%WS2812_BUF, 0xf+(0xf*4));
    }
    
    update_display();
    
    RemoteIR::Format format;
    uint8_t buf[32];
    int bitcount;
    while(1)
    { // read the value of the code
        if (IR.getState() == ReceiverIR::Received)
        {
            bitcount = IR.getData(&format, buf, sizeof(buf) * 8);
            pc.printf("%d\r\n", bitcount);
            pc.printf("buf[2]: %d\r\n", buf[2]);
            button = buf[2];
        }
        
        switch(button)
        {
            case 0x45:
            // ch- button (P value up)
                pval += 0.01;
                pval = fabs(pval);
                update_display();
                wait(0.3);
                button = 0x1C;
                break;
  
            default:
                // wrong button
                pc.printf("wrong button!\r\n");
                break;
        }
    }
}