/*
 *  Copyright 2014 Embedded Artists AB
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
#ifndef APP_NETWORK_SETTINGS_H
#define APP_NETWORK_SETTINGS_H

#include "App.h"
#include "DMBoard.h"
#include "lpc_swim.h"
#include "Button.h"
#include "ImageButton.h"
#include "DigitButton.h"
#include "Resource.h"

/**
 * An App example. Allows changing IP Address, Netmask and Gateway.
 *
 * The purpose of this example is to show some of the graphics primitives in
 * the SWIM library.
 */
class AppNetworkSettings : public App {
public:

	AppNetworkSettings();
	virtual ~AppNetworkSettings();

    virtual bool setup();
    virtual void runToCompletion();
    virtual bool teardown();

    void modifyValue(int mod);
    void changeActiveField(bool next);
    void setActiveField(uint32_t newField);

    enum Resources {
        Resource_Ok_button,
        Resource_Cancel_button,
        Resource_ArrowUp_button,
        Resource_ArrowDown_button,
        Resource_ArrowLeft_button,
        Resource_ArrowRight_button,
        Resource_Digits,
        NumResources,
    };

    /** Specifies the resource to use
     *
     *  Adds a resource for a specific id. This allows the
     *  user program to select e.g. which image to use and
     *  if it should be loaded from a file or an array.
     *
     *  @param id  the identifier
     *  @param res the resource
     */
    void addResource(Resources id, Resource* res);

private:
    enum Buttons {
      ButtonIp0,
      ButtonIp1,
      ButtonIp2,
      ButtonIp3,
      ButtonMask0,
      ButtonMask1,
      ButtonMask2,
      ButtonMask3,
      ButtonGw0,
      ButtonGw1,
      ButtonGw2,
      ButtonGw3,
      ButtonOk,
      ButtonCancel,
      ButtonUp,
      ButtonDown,
      ButtonLeft,
      ButtonRight,
      NumButtons,
      NumFields = ButtonOk,
    };

    Display* _disp;
    SWIM_WINDOW_T* _win;
    void* _fb;

    Clickable* _buttons[NumButtons];
    
    uint32_t _activeField;
    uint32_t _values[NumFields];
    
    Image::ImageData_t _digitImage;
    
    Resource* _res[NumResources];

    void draw();
    void markField(int field, bool active);
    void addIPField(int y, int idx, const char* lbl);
};

#endif


