/*
 *  Copyright 2014 Embedded Artists AB
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
#ifndef APP_IMAGEVIEWER_H
#define APP_IMAGEVIEWER_H

#include "App.h"
#include "DMBoard.h"
#include "lpc_swim.h"
#include "ImageButton.h"
#include "Image.h"
#include "Resource.h"

/**
 * An App example. Searches for images on any connected media (USB Mass Storage, 
 * SD Card or QSPI File System) and presents the images one at a time, scaled to
 * fit the display.
 *
 * The purpose of this example is to show how to recursively search the file
 * systems and how to load images. The image scaling could be replaced with 
 * rotating, cropping or any other image operation. The two second delay between
 * images could be replaced with buttons or other touch events.
 */
class AppImageViewer : public App {
public:

	AppImageViewer();
	virtual ~AppImageViewer();

    virtual bool setup();
    virtual void runToCompletion();
    virtual bool teardown();

    void load(const char* file);

    enum Resources {
        Resource_Ok_button,
    };

    /** Specifies the resource to use
     *
     *  Adds a resource for a specific id. This allows the
     *  user program to select e.g. which image to use and
     *  if it should be loaded from a file or an array.
     *
     *  @param id  the identifier
     *  @param res the resource
     */
    void addResource(Resources id, Resource* res);

private:
    Display* _disp;
    SWIM_WINDOW_T* _win;
    void* _fb1;
    void* _fb2;
    ImageButton* _btn;
    Mail<Image::ImageData_t, 2> _mailbox;
    int _active;
    int _next;
    Mutex _allowedToRender;
    Mutex _imageLoaded;
    Resource* _resOk;

    void draw();
};

#endif


