/*
 *  Copyright 2014 Embedded Artists AB
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

#ifndef APP_DRAW_H
#define APP_DRAW_H

#include "App.h"
#include "DMBoard.h"
#include "lpc_swim.h"
#include "ImageButton.h"
#include "Resource.h"

/**
 * An App example. Lets the user draw on the screen. Each finger is 
 * assigned it's own color.
 *
 * The purpose of this example is to show the use of a multitouch
 * display.
 */
class AppDraw : public App {
public:

	AppDraw();
	virtual ~AppDraw();

    virtual bool setup();
    virtual void runToCompletion();
    virtual bool teardown();

    enum Resources {
        Resource_Ok_button,
    };

    /** Specifies the resource to use
     *
     *  Adds a resource for a specific id. This allows the
     *  user program to select e.g. which image to use and
     *  if it should be loaded from a file or an array.
     *
     *  @param id  the identifier
     *  @param res the resource
     */
    void addResource(Resources id, Resource* res);

private:
    enum Constants {
        MaxSupportedFingers = 5,
    };
    Display* _disp;
    SWIM_WINDOW_T* _win;
    void* _fb;
    ImageButton* _btn;
    touch_coordinate_t _coords[MaxSupportedFingers];
    Resource* _resOk;

    void draw();
};

#endif


