#include "mbed.h"
#include "platform/mbed_thread.h"
#include "DMBoard.h"
#include "lpc_swim.h"
#include "lpc_swim_font.h"

int main()
{

  DMBoard::BoardError err;
  DMBoard* board = &DMBoard::instance();
  RtosLog* log = board->logger();
  Display* disp = board->display();

  do {
    err = board->init();
    if (err != DMBoard::Ok) {
      log->printf("Failed to initialize the board, got error %d\r\n", err);
      break;
    }
    
    log->printf("\n\nHello World!\n\n");
    
    SWIM_WINDOW_T win;
    void* fb = disp->allocateFramebuffer();
    if (fb == NULL) {
      log->printf("Failed to allocate memory for a frame buffer\r\n");
      err = DMBoard::MemoryError;
      break;
    }

    // Prepare fullscreen
    swim_window_open(&win, 
                     disp->width(), disp->height(),         // full size
                     (COLOR_T*)fb,
                     0,0,disp->width()-1, disp->height()-1, // window position and size
                     1,                                     // border
                     WHITE, BLUE, BLACK);                   // colors: pen, backgr, forgr
    swim_set_title(&win, "My Program", BLACK);
  
    // Message
    swim_put_text_xy(&win, "Hello World!", 100, 100);  

    // Start display in default mode (16-bit)
    Display::DisplayError disperr = disp->powerUp(fb);            
    if (disperr != Display::DisplayError_Ok) {
      log->printf("Failed to initialize the display, got error %d\r\n", disperr);
      break;
    }
                
  } while(false);

  if (err != DMBoard::Ok) {
    log->printf("\nTERMINATING\n");
    thread_sleep_for(2000); // allow RtosLog to flush messages
    mbed_die();
  }  

  while(true) {
  }   
}
