/*
 *  Copyright 2014 Embedded Artists AB
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
#ifndef APP_USB_STATUS_H
#define APP_USB_STATUS_H

#include "App.h"
#include "DMBoard.h"
#include "lpc_swim.h"
#include "ImageButton.h"

/**
 * An App example. Static display of information.
 *
 * The purpose of this example is to show some of the graphics primitives in
 * the SWIM library.
 */
class AppUSBStatus : public App {
public:

	AppUSBStatus();
	virtual ~AppUSBStatus();

    virtual bool setup();
    virtual void runToCompletion();
    virtual bool teardown();

private:
    enum Ids {
        USBHost_MassStorage_Inserted,
        USBHost_MassStorage_Ejected,
        USBHost_Mouse_Inserted,
        USBHost_Mouse_Ejected,
        USBHost_Keyboard_Inserted,
        USBHost_Keyboard_Ejected,
        NumImages,
    };
    Display* _disp;
    SWIM_WINDOW_T* _win;
    void* _fb;
    Image::ImageData_t _images[NumImages];
    SWIM_WINDOW_T _imageWindows[NumImages/2];
    ImageButton* _btn;

    void draw();
    void updateStatus(Ids id);
};

#endif

