/*
 *  Copyright 2014 Embedded Artists AB
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
#ifndef APP_RTC_SETTINGS_H
#define APP_RTC_SETTINGS_H

#include "App.h"
#include "DMBoard.h"
#include "lpc_swim.h"
#include "Button.h"
#include "ImageButton.h"
#include "DigitButton.h"

/**
 * An App example. Allows changing the real time clock (RTC).
 *
 * The purpose of this example is to show some of the graphics primitives in
 * the SWIM library.
 */
class AppRTCSettings : public App {
public:

	AppRTCSettings();
	virtual ~AppRTCSettings();

    virtual bool setup();
    virtual void runToCompletion();
    virtual bool teardown();

    void modifyValue(int mod);
    void changeActiveField(bool next);
    void setActiveField(uint32_t newField);

private:
    enum Buttons {
      ButtonYear,
      ButtonMonth,
      ButtonDay,
      ButtonHour,
      ButtonMinute,
      ButtonSecond,
      ButtonOk,
      ButtonCancel,
      ButtonUp,
      ButtonDown,
      ButtonLeft,
      ButtonRight,
      NumButtons,
      NumFields = ButtonOk,
    };

    Display* _disp;
    SWIM_WINDOW_T* _win;
    void* _fb;

    Clickable* _buttons[NumButtons];
    
    uint32_t _activeField;
    uint32_t _values[NumFields];
    
    Image::ImageData_t _digitImage;

    void draw();
    void markField(int field, bool active);
    void addDateFields(int xoff, int yoff);
    void addTimeFields(int xoff, int yoff);
};

#endif

