/*
 *  Copyright 2014 Embedded Artists AB
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
#ifndef APP_LAUNCHER_SPECIAL_H
#define APP_LAUNCHER_SPECIAL_H

#include "App.h"
#include "DMBoard.h"
#include "lpc_swim.h"
#include "Clickable.h"
#include "Image.h"

/**
 * An App example. This uses a number of buttons to launch different Apps.
 *
 * The purpose of this example is to demonstrate how to manage a set of
 * Apps and launch them either as a result of clicked buttons or (in the 
 * case of the TouchCalibrationApp) after an extended press of the USER
 * button on the back of the display module.
 */
class AppLauncherSpecial : public App {
public:

	AppLauncherSpecial();
	virtual ~AppLauncherSpecial();

    enum CommonApplicationIDs {
        CalibrationApp = 0xffff,
    };

    virtual bool setup();
    virtual void runToCompletion();
    virtual bool teardown();

    void setAppCreatorFunc(App*(*callback)(uint32_t buttonID));

    bool addButton(uint32_t buttonID, const char* caption);
    bool addImageButton(uint32_t buttonID, const char* imgUp, const char* imgDown = 0);
    bool addImageButton(uint32_t buttonID, const unsigned char* imgUp, unsigned int imgUpSize, const unsigned char* imgDown = 0, unsigned int imgDownSize = 0);
    bool addImageButton(uint32_t buttonID, const char* caption, COLOR_T color, const char* imgUp, const char* imgDown = 0);
    bool addImageButton(uint32_t buttonID, const char* caption, COLOR_T color, const unsigned char* imgUp, unsigned int imgUpSize, const unsigned char* imgDown = 0, unsigned int imgDownSize = 0);

private:
    enum Constants {
       TitleHeight = 20,
       ButtonWidth = 75,
       ButtonHeight = 75,
       ButtonRows   = 2,
       ButtonColumns = 5,
       NumberOfButtons = ButtonRows*ButtonColumns,
    };

    Display* _disp;
    SWIM_WINDOW_T* _win;
    void* _fb;
    Clickable* _buttons[NumberOfButtons];
    int _usedButtons;
    App*(*_callback)(uint32_t buttonID);
    bool _supportsCalibration;
    bool _newTouchEvent;
    bool _newButtonEvent;
    Image::ImageData_t _bgImg;
    char _currentTime[30];

    void draw();
    void onTouchEvent();
    void onButtonEvent();
};

#endif

