/*
 *  Copyright 2014 Embedded Artists AB
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

#ifndef APP_USBMOUSE_H
#define APP_USBMOUSE_H

#include "App.h"
#include "DMBoard.h"
#include "lpc_swim.h"

/**
 * An App example letting the user move the mouse cursor on the PC.
 *
 * The purpose of this example is to show how to use the USBMouse class.
 */
class AppUSBMouse : public App {
public:

    AppUSBMouse();
    virtual ~AppUSBMouse();

    virtual bool setup();
    virtual void runToCompletion();
    virtual bool teardown();

private:
    Display* _disp;
    SWIM_WINDOW_T* _win;
    void* _fb;
    touch_coordinate_t _coords[2];

    void draw();
};

#endif
