/*********************************************************************
*                SEGGER Microcontroller GmbH & Co. KG                *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 1996 - 2015  SEGGER Microcontroller GmbH & Co. KG       *
*                                                                    *
*        Internet: www.segger.com    Support:  support@segger.com    *
*                                                                    *
**********************************************************************

** emWin V5.28 - Graphical user interface for embedded applications **
emWin is protected by international copyright laws.   Knowledge of the
source code may not be used to write a similar product.  This file may
only  be used  in accordance  with  a license  and should  not be  re-
distributed in any way. We appreciate your understanding and fairness.
----------------------------------------------------------------------
File        : MEMDEV_WM_Ticker.c
Purpose     : Shows how a ticker can be achieved with memory devices
              and smooth scrolling or with the window manager and
              pixel precise scrolling.
Requirements: WindowManager - (x)
              MemoryDevices - (x)
              AntiAliasing  - (x)
              VNC-Server    - ( )
              PNG-Library   - ( )
              TrueTypeFonts - ( )
----------------------------------------------------------------------
*/

#include <stddef.h>
#include "SLIDER.h"

/*********************************************************************
*
*       Defines
*
**********************************************************************
*/
#define YPOS_SLIDER    ((ySize / 12) *  3)
#define YPOS_0         ((ySize / 12) *  7)
#define YPOS_1         ((ySize / 12) * 10)
#define TICKER_PERIOD  80
#define TICKER_BKCOLOR 0xD8AA5D
#define BK_COLOR0      GUI_DARKBLUE
#define BK_COLOR1      GUI_BLUE

//
// Recommended memory to run the sample with adequate performance
//
#define RECOMMENDED_MEMORY (1024L * 100)

/*********************************************************************
*
*       Types
*
**********************************************************************
*/
typedef struct {
  GUI_TIMER_HANDLE  hTimer;
  const GUI_FONT  * pFont;
  const char      * pText;
  GUI_COLOR         TextColor;
  int               xSizeText;
  int               xPos;
  int               yPos;
  int               xSize;
  int               ySize;
  int               dx;
  int               vxPos;
  int               vyPos;
} TICKER_CONTEXT;

typedef struct {
  WM_HWIN           hWin;
  TICKER_CONTEXT    Ticker;
} TICKER_CONTEXT_WM;

typedef struct {
  GUI_MEMDEV_Handle hMemText;
  GUI_MEMDEV_Handle hMemWork;
  GUI_MEMDEV_Handle hMemBk;
  TICKER_CONTEXT    Ticker;
} TICKER_CONTEXT_MD;

typedef struct {
  TICKER_CONTEXT_WM * pTickerWM;
  TICKER_CONTEXT_MD * pTickerMD;
} TICKER_INFO;

/*********************************************************************
*
*       Static data
*
**********************************************************************
*/
/*********************************************************************
*
*       GUI_Font20_AA4
*/
GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0020[  1] = { // Code 0020, SPACE
  0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_002E[  8] = { // Code 002E, FULL STOP
  0x07, 0xB5,
  0x1F, 0xFD,
  0x0D, 0xFB,
  0x01, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0054[ 96] = { // Code 0054, LATIN CAPITAL LETTER T
  0x15, 0x66, 0x66, 0x66, 0x63, 0x00,
  0x9F, 0xFF, 0xFF, 0xFF, 0xFF, 0x00,
  0x6F, 0xFF, 0xFF, 0xFF, 0xFC, 0x00,
  0x00, 0x02, 0xFF, 0x70, 0x00, 0x00,
  0x00, 0x02, 0xFF, 0x70, 0x00, 0x00,
  0x00, 0x02, 0xFF, 0x70, 0x00, 0x00,
  0x00, 0x02, 0xFF, 0x70, 0x00, 0x00,
  0x00, 0x02, 0xFF, 0x70, 0x00, 0x00,
  0x00, 0x02, 0xFF, 0x70, 0x00, 0x00,
  0x00, 0x02, 0xFF, 0x70, 0x00, 0x00,
  0x00, 0x02, 0xFF, 0x70, 0x00, 0x00,
  0x00, 0x02, 0xFF, 0x70, 0x00, 0x00,
  0x00, 0x02, 0xFF, 0x70, 0x00, 0x00,
  0x00, 0x02, 0xFF, 0x70, 0x00, 0x00,
  0x00, 0x01, 0xEF, 0x60, 0x00, 0x00,
  0x00, 0x00, 0x13, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0061[ 52] = { // Code 0061, LATIN SMALL LETTER A
  0x00, 0x00, 0x20, 0x00,
  0x01, 0xAF, 0xFF, 0xB1,
  0x0C, 0xFF, 0xBF, 0xFA,
  0x2F, 0xF7, 0x09, 0xFD,
  0x0A, 0xB2, 0x1C, 0xFD,
  0x00, 0x07, 0xEF, 0xFD,
  0x03, 0xDF, 0xEB, 0xFD,
  0x0D, 0xFD, 0x27, 0xFD,
  0x3F, 0xF6, 0x08, 0xFD,
  0x4F, 0xF6, 0x0B, 0xFD,
  0x1F, 0xFE, 0xBF, 0xFE,
  0x08, 0xFF, 0xE7, 0xFF,
  0x00, 0x23, 0x00, 0x32
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0062[ 64] = { // Code 0062, LATIN SMALL LETTER B
  0x49, 0x20, 0x00, 0x00,
  0xCF, 0x90, 0x00, 0x00,
  0xDF, 0x90, 0x00, 0x00,
  0xDF, 0x90, 0x10, 0x00,
  0xDF, 0xAA, 0xFF, 0x60,
  0xDF, 0xFF, 0xFF, 0xF1,
  0xDF, 0xE1, 0x7F, 0xF5,
  0xDF, 0xA0, 0x3F, 0xF6,
  0xDF, 0x90, 0x2F, 0xF6,
  0xDF, 0x90, 0x2F, 0xF6,
  0xDF, 0x90, 0x2F, 0xF6,
  0xDF, 0xA0, 0x3F, 0xF6,
  0xDF, 0xD0, 0x5F, 0xF5,
  0xDF, 0xFD, 0xEF, 0xF2,
  0xAF, 0x9D, 0xFF, 0x80,
  0x13, 0x00, 0x33, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0063[ 52] = { // Code 0063, LATIN SMALL LETTER C
  0x00, 0x00, 0x20, 0x00,
  0x01, 0xAF, 0xFE, 0x80,
  0x0A, 0xFF, 0xDF, 0xF7,
  0x0F, 0xF9, 0x0B, 0xFB,
  0x2F, 0xF6, 0x08, 0xFA,
  0x2F, 0xF6, 0x00, 0x40,
  0x2F, 0xF6, 0x00, 0x00,
  0x2F, 0xF6, 0x01, 0x72,
  0x2F, 0xF6, 0x08, 0xFB,
  0x1F, 0xF9, 0x0A, 0xFB,
  0x0B, 0xFF, 0xBF, 0xF7,
  0x02, 0xDF, 0xFF, 0xA0,
  0x00, 0x03, 0x42, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0064[ 80] = { // Code 0064, LATIN SMALL LETTER D
  0x00, 0x00, 0x01, 0x87, 0x00,
  0x00, 0x00, 0x05, 0xFF, 0x10,
  0x00, 0x00, 0x06, 0xFF, 0x20,
  0x00, 0x01, 0x06, 0xFF, 0x20,
  0x03, 0xEF, 0xC8, 0xFF, 0x20,
  0x0C, 0xFF, 0xFF, 0xFF, 0x20,
  0x1F, 0xFA, 0x0B, 0xFF, 0x20,
  0x2F, 0xF7, 0x06, 0xFF, 0x20,
  0x2F, 0xF6, 0x06, 0xFF, 0x20,
  0x2F, 0xF6, 0x06, 0xFF, 0x20,
  0x2F, 0xF6, 0x06, 0xFF, 0x20,
  0x2F, 0xF7, 0x06, 0xFF, 0x20,
  0x1F, 0xF9, 0x09, 0xFF, 0x20,
  0x0D, 0xFF, 0xCF, 0xFF, 0x20,
  0x05, 0xFF, 0xE7, 0xFE, 0x00,
  0x00, 0x24, 0x10, 0x32, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0065[ 52] = { // Code 0065, LATIN SMALL LETTER E
  0x00, 0x00, 0x20, 0x00,
  0x02, 0xBF, 0xFF, 0x90,
  0x0C, 0xFF, 0xDF, 0xF6,
  0x1F, 0xF7, 0x0B, 0xFB,
  0x3F, 0xF6, 0x09, 0xFD,
  0x4F, 0xFD, 0xBE, 0xFD,
  0x4F, 0xFE, 0xDD, 0xD7,
  0x4F, 0xF6, 0x00, 0x10,
  0x4F, 0xF6, 0x07, 0xF9,
  0x2F, 0xF7, 0x0B, 0xFB,
  0x0D, 0xFE, 0xBF, 0xF8,
  0x03, 0xEF, 0xFF, 0xB1,
  0x00, 0x03, 0x42, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0066[ 48] = { // Code 0066, LATIN SMALL LETTER F
  0x00, 0x69, 0x80,
  0x07, 0xFF, 0xF3,
  0x09, 0xFE, 0x40,
  0x09, 0xFB, 0x00,
  0xAE, 0xFF, 0xB1,
  0xDF, 0xFF, 0xE2,
  0x09, 0xFB, 0x00,
  0x09, 0xFB, 0x00,
  0x09, 0xFB, 0x00,
  0x09, 0xFB, 0x00,
  0x09, 0xFB, 0x00,
  0x09, 0xFB, 0x00,
  0x09, 0xFB, 0x00,
  0x09, 0xFB, 0x00,
  0x08, 0xFA, 0x00,
  0x00, 0x30, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0067[ 85] = { // Code 0067, LATIN SMALL LETTER G
  0x00, 0x01, 0x00, 0x00, 0x00,
  0x03, 0xDF, 0xC4, 0xED, 0x00,
  0x0B, 0xFF, 0xFE, 0xFF, 0x20,
  0x1F, 0xFB, 0x0B, 0xFF, 0x20,
  0x2F, 0xF7, 0x06, 0xFF, 0x20,
  0x2F, 0xF6, 0x06, 0xFF, 0x20,
  0x2F, 0xF6, 0x06, 0xFF, 0x20,
  0x2F, 0xF6, 0x06, 0xFF, 0x20,
  0x2F, 0xF7, 0x06, 0xFF, 0x20,
  0x1F, 0xFA, 0x0B, 0xFF, 0x20,
  0x0B, 0xFF, 0xEF, 0xFF, 0x20,
  0x02, 0xDF, 0xD8, 0xFF, 0x20,
  0x00, 0x00, 0x06, 0xFF, 0x20,
  0x07, 0xE5, 0x07, 0xFF, 0x00,
  0x0B, 0xFE, 0x9E, 0xFB, 0x00,
  0x03, 0xCF, 0xFF, 0xB1, 0x00,
  0x00, 0x01, 0x21, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0068[ 64] = { // Code 0068, LATIN SMALL LETTER H
  0x59, 0x10, 0x00, 0x00,
  0xDF, 0x70, 0x00, 0x00,
  0xDF, 0x70, 0x00, 0x00,
  0xDF, 0x70, 0x10, 0x00,
  0xDF, 0x8B, 0xFF, 0x60,
  0xDF, 0xEF, 0xFF, 0xF1,
  0xDF, 0xD2, 0x7F, 0xF3,
  0xDF, 0x80, 0x4F, 0xF4,
  0xDF, 0x70, 0x4F, 0xF4,
  0xDF, 0x70, 0x4F, 0xF4,
  0xDF, 0x70, 0x4F, 0xF4,
  0xDF, 0x70, 0x4F, 0xF4,
  0xDF, 0x70, 0x4F, 0xF4,
  0xDF, 0x70, 0x4F, 0xF3,
  0xCF, 0x60, 0x2F, 0xF1,
  0x13, 0x00, 0x02, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0069[ 32] = { // Code 0069, LATIN SMALL LETTER I
  0x5B, 0x30,
  0xFF, 0xB0,
  0xAF, 0x70,
  0x01, 0x00,
  0x9F, 0x60,
  0xCF, 0x90,
  0xDF, 0x90,
  0xDF, 0x90,
  0xDF, 0x90,
  0xDF, 0x90,
  0xDF, 0x90,
  0xDF, 0x90,
  0xDF, 0x90,
  0xDF, 0x90,
  0xAF, 0x70,
  0x13, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_006B[ 64] = { // Code 006B, LATIN SMALL LETTER K
  0x59, 0x10, 0x00, 0x00,
  0xDF, 0x70, 0x00, 0x00,
  0xDF, 0x70, 0x00, 0x00,
  0xDF, 0x70, 0x00, 0x00,
  0xDF, 0x70, 0x1D, 0xE1,
  0xDF, 0x70, 0xAF, 0xE1,
  0xDF, 0x75, 0xFF, 0x60,
  0xDF, 0x8D, 0xFB, 0x00,
  0xDF, 0xEF, 0xF3, 0x00,
  0xDF, 0xFF, 0xF8, 0x00,
  0xDF, 0xFE, 0xFE, 0x00,
  0xDF, 0xA5, 0xFF, 0x50,
  0xDF, 0x70, 0xEF, 0xC0,
  0xDF, 0x70, 0x7F, 0xF3,
  0xCF, 0x60, 0x1E, 0xF5,
  0x13, 0x00, 0x02, 0x30
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_006C[ 32] = { // Code 006C, LATIN SMALL LETTER L
  0x49, 0x20,
  0xCF, 0x90,
  0xDF, 0x90,
  0xDF, 0x90,
  0xDF, 0x90,
  0xDF, 0x90,
  0xDF, 0x90,
  0xDF, 0x90,
  0xDF, 0x90,
  0xDF, 0x90,
  0xDF, 0x90,
  0xDF, 0x90,
  0xDF, 0x90,
  0xDF, 0x90,
  0xAF, 0x70,
  0x13, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_006D[ 78] = { // Code 006D, LATIN SMALL LETTER M
  0x01, 0x00, 0x10, 0x00, 0x01, 0x00,
  0xCF, 0x4B, 0xFF, 0x76, 0xEF, 0xC1,
  0xFF, 0xEF, 0xFF, 0xFF, 0xFF, 0xF8,
  0xFF, 0xC1, 0x8F, 0xF7, 0x1D, 0xFB,
  0xFF, 0x70, 0x6F, 0xF2, 0x0B, 0xFB,
  0xFF, 0x70, 0x6F, 0xF2, 0x0B, 0xFB,
  0xFF, 0x70, 0x6F, 0xF2, 0x0B, 0xFB,
  0xFF, 0x70, 0x6F, 0xF2, 0x0B, 0xFB,
  0xFF, 0x70, 0x6F, 0xF2, 0x0B, 0xFB,
  0xFF, 0x70, 0x6F, 0xF2, 0x0B, 0xFB,
  0xFF, 0x70, 0x6F, 0xF2, 0x0B, 0xFB,
  0xDF, 0x50, 0x4F, 0xE0, 0x09, 0xF9,
  0x13, 0x00, 0x03, 0x20, 0x00, 0x40
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_006E[ 52] = { // Code 006E, LATIN SMALL LETTER N
  0x01, 0x00, 0x10, 0x00,
  0xBF, 0x5B, 0xFF, 0x60,
  0xDF, 0xEF, 0xFF, 0xF1,
  0xDF, 0xD2, 0x7F, 0xF3,
  0xDF, 0x80, 0x4F, 0xF4,
  0xDF, 0x70, 0x4F, 0xF4,
  0xDF, 0x70, 0x4F, 0xF4,
  0xDF, 0x70, 0x4F, 0xF4,
  0xDF, 0x70, 0x4F, 0xF4,
  0xDF, 0x70, 0x4F, 0xF4,
  0xDF, 0x70, 0x4F, 0xF3,
  0xCF, 0x60, 0x2F, 0xF1,
  0x13, 0x00, 0x02, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_006F[ 65] = { // Code 006F, LATIN SMALL LETTER O
  0x00, 0x00, 0x20, 0x00, 0x00,
  0x01, 0xAF, 0xFF, 0x91, 0x00,
  0x0B, 0xFF, 0xDF, 0xF9, 0x00,
  0x1F, 0xF8, 0x0A, 0xFE, 0x00,
  0x3F, 0xF6, 0x07, 0xFF, 0x20,
  0x4F, 0xF6, 0x07, 0xFF, 0x20,
  0x4F, 0xF6, 0x07, 0xFF, 0x20,
  0x4F, 0xF6, 0x07, 0xFF, 0x20,
  0x4F, 0xF6, 0x07, 0xFF, 0x20,
  0x1F, 0xF7, 0x09, 0xFF, 0x00,
  0x0C, 0xFE, 0xAF, 0xFA, 0x00,
  0x02, 0xDF, 0xFF, 0xC1, 0x00,
  0x00, 0x03, 0x42, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0070[ 68] = { // Code 0070, LATIN SMALL LETTER P
  0x01, 0x00, 0x10, 0x00,
  0x9F, 0x69, 0xFF, 0x60,
  0xCF, 0xEF, 0xFF, 0xF1,
  0xDF, 0xE1, 0x7F, 0xF5,
  0xDF, 0xA0, 0x3F, 0xF6,
  0xDF, 0x90, 0x2F, 0xF6,
  0xDF, 0x90, 0x2F, 0xF6,
  0xDF, 0x90, 0x2F, 0xF6,
  0xDF, 0xA0, 0x2F, 0xF6,
  0xDF, 0xD0, 0x4F, 0xF5,
  0xDF, 0xFB, 0xDF, 0xF2,
  0xDF, 0xBD, 0xFF, 0x80,
  0xDF, 0x90, 0x33, 0x00,
  0xDF, 0x90, 0x00, 0x00,
  0xDF, 0x90, 0x00, 0x00,
  0xAF, 0x70, 0x00, 0x00,
  0x02, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0072[ 39] = { // Code 0072, LATIN SMALL LETTER R
  0x01, 0x00, 0x10,
  0xBF, 0x3B, 0xF3,
  0xDF, 0xBF, 0xF6,
  0xDF, 0xFF, 0xD2,
  0xDF, 0xC1, 0x00,
  0xDF, 0x70, 0x00,
  0xDF, 0x70, 0x00,
  0xDF, 0x70, 0x00,
  0xDF, 0x70, 0x00,
  0xDF, 0x70, 0x00,
  0xDF, 0x70, 0x00,
  0xCF, 0x60, 0x00,
  0x13, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0073[ 52] = { // Code 0073, LATIN SMALL LETTER S
  0x00, 0x01, 0x10, 0x00,
  0x03, 0xCF, 0xFD, 0x40,
  0x1E, 0xFD, 0xDF, 0xE1,
  0x4F, 0xF3, 0x1F, 0xF5,
  0x3F, 0xF9, 0x08, 0xB1,
  0x0C, 0xFF, 0xB1, 0x00,
  0x01, 0xCF, 0xFE, 0x30,
  0x00, 0x08, 0xFF, 0xE1,
  0x3D, 0xA0, 0x5F, 0xF7,
  0x5F, 0xF1, 0x0E, 0xF7,
  0x2F, 0xFB, 0xBF, 0xF3,
  0x06, 0xFF, 0xFF, 0x60,
  0x00, 0x14, 0x31, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0074[ 48] = { // Code 0074, LATIN SMALL LETTER T
  0x00, 0x20, 0x00,
  0x07, 0xF9, 0x00,
  0x09, 0xFB, 0x00,
  0x09, 0xFB, 0x00,
  0xAE, 0xFF, 0xC3,
  0xDF, 0xFF, 0xF4,
  0x09, 0xFB, 0x00,
  0x09, 0xFB, 0x00,
  0x09, 0xFB, 0x00,
  0x09, 0xFB, 0x00,
  0x09, 0xFB, 0x00,
  0x09, 0xFB, 0x00,
  0x09, 0xFC, 0x00,
  0x09, 0xFF, 0xD3,
  0x03, 0xDF, 0xF3,
  0x00, 0x02, 0x10
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0075[ 52] = { // Code 0075, LATIN SMALL LETTER U
  0x01, 0x00, 0x00, 0x00,
  0xBF, 0x40, 0x1E, 0xE1,
  0xDF, 0x70, 0x4F, 0xF3,
  0xDF, 0x70, 0x4F, 0xF4,
  0xDF, 0x70, 0x4F, 0xF4,
  0xDF, 0x70, 0x4F, 0xF4,
  0xDF, 0x70, 0x4F, 0xF4,
  0xDF, 0x70, 0x4F, 0xF4,
  0xDF, 0x70, 0x4F, 0xF4,
  0xDF, 0x90, 0x8F, 0xF4,
  0xCF, 0xFD, 0xFF, 0xF3,
  0x5F, 0xFE, 0x7F, 0xF1,
  0x02, 0x41, 0x02, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0076[ 65] = { // Code 0076, LATIN SMALL LETTER V
  0x01, 0x00, 0x00, 0x10, 0x00,
  0x5F, 0xC0, 0x03, 0xFD, 0x00,
  0x7F, 0xF2, 0x07, 0xFF, 0x00,
  0x4F, 0xF4, 0x09, 0xFC, 0x00,
  0x0F, 0xF7, 0x0C, 0xF8, 0x00,
  0x0C, 0xFA, 0x0F, 0xF5, 0x00,
  0x08, 0xFC, 0x2F, 0xF1, 0x00,
  0x05, 0xFF, 0x5F, 0xD0, 0x00,
  0x01, 0xFF, 0xAF, 0x90, 0x00,
  0x00, 0xCF, 0xFF, 0x60, 0x00,
  0x00, 0x9F, 0xFF, 0x20, 0x00,
  0x00, 0x4F, 0xFD, 0x00, 0x00,
  0x00, 0x02, 0x41, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0077[ 91] = { // Code 0077, LATIN SMALL LETTER W
  0x01, 0x00, 0x00, 0x10, 0x00, 0x01, 0x00,
  0x4F, 0xC0, 0x07, 0xF5, 0x00, 0xBF, 0x30,
  0x7F, 0xF1, 0x0C, 0xFA, 0x01, 0xFF, 0x60,
  0x4F, 0xF4, 0x0E, 0xFD, 0x03, 0xFF, 0x30,
  0x1F, 0xF6, 0x2F, 0xFF, 0x15, 0xFF, 0x00,
  0x0D, 0xF8, 0x4F, 0xFF, 0x47, 0xFC, 0x00,
  0x0A, 0xFA, 0x7F, 0xBF, 0x79, 0xF9, 0x00,
  0x07, 0xFD, 0x9F, 0x5F, 0xAC, 0xF6, 0x00,
  0x03, 0xFF, 0xCE, 0x0F, 0xCE, 0xF3, 0x00,
  0x00, 0xFF, 0xFC, 0x0C, 0xFF, 0xE0, 0x00,
  0x00, 0xCF, 0xF9, 0x0A, 0xFF, 0xB0, 0x00,
  0x00, 0x7F, 0xF4, 0x04, 0xFF, 0x70, 0x00,
  0x00, 0x03, 0x20, 0x00, 0x33, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0078[ 52] = { // Code 0078, LATIN SMALL LETTER X
  0x01, 0x00, 0x00, 0x10,
  0x4F, 0xC0, 0x08, 0xF7,
  0x6F, 0xF5, 0x2F, 0xF8,
  0x0E, 0xFC, 0x8F, 0xF1,
  0x06, 0xFF, 0xFF, 0x80,
  0x00, 0xDF, 0xFE, 0x10,
  0x00, 0x7F, 0xF9, 0x00,
  0x00, 0xDF, 0xFE, 0x10,
  0x06, 0xFF, 0xFF, 0x90,
  0x0E, 0xFA, 0x9F, 0xF2,
  0x7F, 0xF3, 0x3F, 0xF9,
  0x8F, 0xA0, 0x0B, 0xFA,
  0x03, 0x10, 0x00, 0x40
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_0079[ 85] = { // Code 0079, LATIN SMALL LETTER Y
  0x01, 0x00, 0x00, 0x10, 0x00,
  0x7F, 0xB0, 0x02, 0xEE, 0x10,
  0x8F, 0xF1, 0x07, 0xFF, 0x10,
  0x5F, 0xF4, 0x09, 0xFC, 0x00,
  0x1F, 0xF7, 0x0C, 0xF9, 0x00,
  0x0D, 0xF9, 0x0E, 0xF5, 0x00,
  0x09, 0xFC, 0x1F, 0xF2, 0x00,
  0x06, 0xFF, 0x4F, 0xD0, 0x00,
  0x02, 0xFF, 0x9F, 0xA0, 0x00,
  0x00, 0xDF, 0xEF, 0x60, 0x00,
  0x00, 0xAF, 0xFF, 0x20, 0x00,
  0x00, 0x6F, 0xFE, 0x00, 0x00,
  0x00, 0x3F, 0xFA, 0x00, 0x00,
  0x00, 0x0F, 0xF7, 0x00, 0x00,
  0x07, 0xEF, 0xF2, 0x00, 0x00,
  0x0A, 0xFF, 0x80, 0x00, 0x00,
  0x00, 0x21, 0x00, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font20_AA4_007A[ 44] = { // Code 007A, LATIN SMALL LETTER Z
  0x3B, 0xDD, 0xDD, 0xD8,
  0x5F, 0xFF, 0xFF, 0xFC,
  0x03, 0x44, 0x9F, 0xF6,
  0x00, 0x01, 0xEF, 0xC0,
  0x00, 0x08, 0xFF, 0x30,
  0x00, 0x3F, 0xF9, 0x00,
  0x00, 0xBF, 0xE1, 0x00,
  0x05, 0xFF, 0x70, 0x00,
  0x0D, 0xFD, 0x22, 0x20,
  0x6F, 0xFF, 0xFF, 0xFD,
  0x5F, 0xFF, 0xFF, 0xFC
};

GUI_CONST_STORAGE GUI_CHARINFO_EXT GUI_Font20_AA4_CharInfo[27] = {
   {   1,   1,   0,  15,   5, acGUI_Font20_AA4_0020 } // Code 0020, SPACE
  ,{   4,   4,   0,  12,   5, acGUI_Font20_AA4_002E } // Code 002E, FULL STOP
  ,{  11,  16,   0,   0,  10, acGUI_Font20_AA4_0054 } // Code 0054, LATIN CAPITAL LETTER T
  ,{   8,  13,   0,   3,   9, acGUI_Font20_AA4_0061 } // Code 0061, LATIN SMALL LETTER A
  ,{   8,  16,   1,   0,   9, acGUI_Font20_AA4_0062 } // Code 0062, LATIN SMALL LETTER B
  ,{   8,  13,   0,   3,   9, acGUI_Font20_AA4_0063 } // Code 0063, LATIN SMALL LETTER C
  ,{   9,  16,   0,   0,   9, acGUI_Font20_AA4_0064 } // Code 0064, LATIN SMALL LETTER D
  ,{   8,  13,   0,   3,   9, acGUI_Font20_AA4_0065 } // Code 0065, LATIN SMALL LETTER E
  ,{   6,  16,   0,   0,   5, acGUI_Font20_AA4_0066 } // Code 0066, LATIN SMALL LETTER F
  ,{   9,  17,   0,   3,   9, acGUI_Font20_AA4_0067 } // Code 0067, LATIN SMALL LETTER G
  ,{   8,  16,   1,   0,   9, acGUI_Font20_AA4_0068 } // Code 0068, LATIN SMALL LETTER H
  ,{   3,  16,   1,   0,   5, acGUI_Font20_AA4_0069 } // Code 0069, LATIN SMALL LETTER I
  ,{   8,  16,   1,   0,   9, acGUI_Font20_AA4_006B } // Code 006B, LATIN SMALL LETTER K
  ,{   3,  16,   1,   0,   5, acGUI_Font20_AA4_006C } // Code 006C, LATIN SMALL LETTER L
  ,{  12,  13,   1,   3,  14, acGUI_Font20_AA4_006D } // Code 006D, LATIN SMALL LETTER M
  ,{   8,  13,   1,   3,   9, acGUI_Font20_AA4_006E } // Code 006E, LATIN SMALL LETTER N
  ,{   9,  13,   0,   3,   9, acGUI_Font20_AA4_006F } // Code 006F, LATIN SMALL LETTER O
  ,{   8,  17,   1,   3,   9, acGUI_Font20_AA4_0070 } // Code 0070, LATIN SMALL LETTER P
  ,{   6,  13,   1,   3,   7, acGUI_Font20_AA4_0072 } // Code 0072, LATIN SMALL LETTER R
  ,{   8,  13,   0,   3,   8, acGUI_Font20_AA4_0073 } // Code 0073, LATIN SMALL LETTER S
  ,{   6,  16,   0,   0,   5, acGUI_Font20_AA4_0074 } // Code 0074, LATIN SMALL LETTER T
  ,{   8,  13,   1,   3,   9, acGUI_Font20_AA4_0075 } // Code 0075, LATIN SMALL LETTER U
  ,{   9,  13,   0,   3,   9, acGUI_Font20_AA4_0076 } // Code 0076, LATIN SMALL LETTER V
  ,{  13,  13,   0,   3,  13, acGUI_Font20_AA4_0077 } // Code 0077, LATIN SMALL LETTER W
  ,{   8,  13,   0,   3,   8, acGUI_Font20_AA4_0078 } // Code 0078, LATIN SMALL LETTER X
  ,{   9,  17,   0,   3,   9, acGUI_Font20_AA4_0079 } // Code 0079, LATIN SMALL LETTER Y
  ,{   8,  11,   0,   4,   9, acGUI_Font20_AA4_007A } // Code 007A, LATIN SMALL LETTER Z
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font20_AA4_Prop6 = {
   0x0072                                   // First character
  ,0x007A                                   // Last character 
  ,&GUI_Font20_AA4_CharInfo[ 18]            // Address of first character
  ,(GUI_CONST_STORAGE GUI_FONT_PROP_EXT *)0 // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font20_AA4_Prop5 = {
   0x006B                                   // First character
  ,0x0070                                   // Last character 
  ,&GUI_Font20_AA4_CharInfo[ 12]            // Address of first character
  ,&GUI_Font20_AA4_Prop6                    // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font20_AA4_Prop4 = {
   0x0061                                   // First character
  ,0x0069                                   // Last character 
  ,&GUI_Font20_AA4_CharInfo[  3]            // Address of first character
  ,&GUI_Font20_AA4_Prop5                    // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font20_AA4_Prop3 = {
   0x0054                                   // First character
  ,0x0054                                   // Last character 
  ,&GUI_Font20_AA4_CharInfo[  2]            // Address of first character
  ,&GUI_Font20_AA4_Prop4                    // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font20_AA4_Prop2 = {
   0x002E                                   // First character
  ,0x002E                                   // Last character 
  ,&GUI_Font20_AA4_CharInfo[  1]            // Address of first character
  ,&GUI_Font20_AA4_Prop3                    // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font20_AA4_Prop1 = {
   0x0020                                   // First character
  ,0x0020                                   // Last character 
  ,&GUI_Font20_AA4_CharInfo[  0]            // Address of first character
  ,&GUI_Font20_AA4_Prop2                    // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT GUI_Font20_AA4 = {
   GUI_FONTTYPE_PROP_AA4_EXT // type of font   
  ,20 // Height of font 
  ,20 // Space of font y
  ,1  // Magnification x
  ,1  // Magnification y
  ,{&GUI_Font20_AA4_Prop1}
  ,13 // Baseline
  ,13 // Height of lowercase characters
  ,16 // Height of capital characters
};

/*********************************************************************
*
*       GUI_Font24_AA4
*/
GUI_CONST_STORAGE unsigned char acGUI_Font24_AA4_0020[  1] = { // Code 0020, SPACE
  0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font24_AA4_002D[  6] = { // Code 002D, HYPHEN-MINUS
  0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font24_AA4_0044[ 90] = { // Code 0044, LATIN CAPITAL LETTER D
  0xFF, 0xFF, 0xFF, 0xEC, 0x70, 0x00,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x10,
  0xFF, 0x00, 0x00, 0x15, 0xDF, 0xB0,
  0xFF, 0x00, 0x00, 0x00, 0x2E, 0xF4,
  0xFF, 0x00, 0x00, 0x00, 0x07, 0xF9,
  0xFF, 0x00, 0x00, 0x00, 0x03, 0xFD,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x01, 0xFF,
  0xFF, 0x00, 0x00, 0x00, 0x03, 0xFC,
  0xFF, 0x00, 0x00, 0x00, 0x08, 0xF9,
  0xFF, 0x00, 0x00, 0x00, 0x2E, 0xF3,
  0xFF, 0x00, 0x00, 0x15, 0xDF, 0xB0,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x10,
  0xFF, 0xFF, 0xFF, 0xEB, 0x60, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font24_AA4_0054[ 90] = { // Code 0054, LATIN CAPITAL LETTER T
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00,
  0x00, 0x00, 0x0F, 0xF0, 0x00, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font24_AA4_0063[ 55] = { // Code 0063, LATIN SMALL LETTER C
  0x00, 0x7C, 0xFE, 0xA2, 0x00,
  0x0B, 0xFF, 0xFF, 0xFE, 0x10,
  0x6F, 0xE5, 0x02, 0xBF, 0x90,
  0xBF, 0x50, 0x00, 0x2F, 0xE0,
  0xEF, 0x10, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xEF, 0x10, 0x00, 0x00, 0x00,
  0xCF, 0x50, 0x00, 0x2F, 0xE0,
  0x7F, 0xE4, 0x02, 0xBF, 0x80,
  0x0B, 0xFF, 0xFF, 0xFD, 0x10,
  0x00, 0x7D, 0xFE, 0x91, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font24_AA4_0065[ 55] = { // Code 0065, LATIN SMALL LETTER E
  0x00, 0x6C, 0xFF, 0xC6, 0x00,
  0x09, 0xFF, 0xFF, 0xFF, 0xA0,
  0x5F, 0xD4, 0x00, 0x3C, 0xF6,
  0xBF, 0x20, 0x00, 0x02, 0xFB,
  0xEF, 0xFF, 0xFF, 0xFF, 0xFE,
  0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
  0xEF, 0x10, 0x00, 0x00, 0x00,
  0xBF, 0x60, 0x00, 0x00, 0x00,
  0x6F, 0xF7, 0x10, 0x29, 0xFB,
  0x0A, 0xFF, 0xFF, 0xFF, 0xE2,
  0x00, 0x6C, 0xFF, 0xD9, 0x20
};

GUI_CONST_STORAGE unsigned char acGUI_Font24_AA4_0069[ 15] = { // Code 0069, LATIN SMALL LETTER I
  0xFF,
  0xFF,
  0x00,
  0x00,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF,
  0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font24_AA4_006B[ 75] = { // Code 006B, LATIN SMALL LETTER K
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0x00, 0x8E, 0x70,
  0xFF, 0x00, 0x08, 0xFA, 0x00,
  0xFF, 0x00, 0x8F, 0xA0, 0x00,
  0xFF, 0x08, 0xFA, 0x00, 0x00,
  0xFF, 0xAF, 0xF5, 0x00, 0x00,
  0xFF, 0xFD, 0xFD, 0x00, 0x00,
  0xFF, 0x72, 0xFF, 0x70, 0x00,
  0xFF, 0x00, 0x7F, 0xE1, 0x00,
  0xFF, 0x00, 0x0C, 0xF9, 0x00,
  0xFF, 0x00, 0x03, 0xFF, 0x20,
  0xFF, 0x00, 0x00, 0x9F, 0xB0
};

GUI_CONST_STORAGE unsigned char acGUI_Font24_AA4_006D[ 77] = { // Code 006D, LATIN SMALL LETTER M
  0xFF, 0x09, 0xEE, 0x70, 0x1A, 0xFE, 0x91,
  0xFF, 0x9F, 0xFF, 0xF6, 0xCF, 0xFF, 0xF9,
  0xFF, 0xD3, 0x08, 0xFE, 0xC2, 0x08, 0xFE,
  0xFF, 0x40, 0x01, 0xFF, 0x30, 0x01, 0xFF,
  0xFF, 0x10, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF,
  0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00, 0xFF
};

GUI_CONST_STORAGE unsigned char acGUI_Font24_AA4_006F[ 55] = { // Code 006F, LATIN SMALL LETTER O
  0x00, 0x6C, 0xFF, 0xC6, 0x00,
  0x0A, 0xFF, 0xFF, 0xFF, 0xA0,
  0x6F, 0xE6, 0x11, 0x6E, 0xF6,
  0xBF, 0x60, 0x00, 0x07, 0xFB,
  0xEF, 0x10, 0x00, 0x01, 0xFE,
  0xFF, 0x00, 0x00, 0x00, 0xFF,
  0xEF, 0x10, 0x00, 0x01, 0xFE,
  0xBF, 0x70, 0x00, 0x07, 0xFB,
  0x6F, 0xE6, 0x11, 0x6E, 0xF6,
  0x0A, 0xFF, 0xFF, 0xFF, 0xA0,
  0x00, 0x6C, 0xFF, 0xC6, 0x00
};

GUI_CONST_STORAGE unsigned char acGUI_Font24_AA4_0072[ 33] = { // Code 0072, LATIN SMALL LETTER R
  0xFF, 0x2C, 0xFB,
  0xFF, 0xBF, 0xF9,
  0xFF, 0xC2, 0x00,
  0xFF, 0x40, 0x00,
  0xFF, 0x10, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00,
  0xFF, 0x00, 0x00
};

GUI_CONST_STORAGE GUI_CHARINFO_EXT GUI_Font24_AA4_CharInfo[11] = {
   {   1,   1,   0,  19,   6, acGUI_Font24_AA4_0020 } // Code 0020, SPACE
  ,{   6,   2,   0,  12,   7, acGUI_Font24_AA4_002D } // Code 002D, HYPHEN-MINUS
  ,{  12,  15,   2,   4,  15, acGUI_Font24_AA4_0044 } // Code 0044, LATIN CAPITAL LETTER D
  ,{  12,  15,   0,   4,  12, acGUI_Font24_AA4_0054 } // Code 0054, LATIN CAPITAL LETTER T
  ,{   9,  11,   1,   8,  11, acGUI_Font24_AA4_0063 } // Code 0063, LATIN SMALL LETTER C
  ,{  10,  11,   1,   8,  12, acGUI_Font24_AA4_0065 } // Code 0065, LATIN SMALL LETTER E
  ,{   2,  15,   1,   4,   5, acGUI_Font24_AA4_0069 } // Code 0069, LATIN SMALL LETTER I
  ,{   9,  15,   1,   4,  10, acGUI_Font24_AA4_006B } // Code 006B, LATIN SMALL LETTER K
  ,{  14,  11,   1,   8,  16, acGUI_Font24_AA4_006D } // Code 006D, LATIN SMALL LETTER M
  ,{  10,  11,   1,   8,  12, acGUI_Font24_AA4_006F } // Code 006F, LATIN SMALL LETTER O
  ,{   6,  11,   1,   8,   7, acGUI_Font24_AA4_0072 } // Code 0072, LATIN SMALL LETTER R
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font24_AA4_Prop11 = {
   0x0072                                   // First character
  ,0x0072                                   // Last character 
  ,&GUI_Font24_AA4_CharInfo[ 10]            // Address of first character
  ,(GUI_CONST_STORAGE GUI_FONT_PROP_EXT *)0 // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font24_AA4_Prop10 = {
   0x006F                                   // First character
  ,0x006F                                   // Last character 
  ,&GUI_Font24_AA4_CharInfo[  9]            // Address of first character
  ,&GUI_Font24_AA4_Prop11                   // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font24_AA4_Prop9 = {
   0x006D                                   // First character
  ,0x006D                                   // Last character 
  ,&GUI_Font24_AA4_CharInfo[  8]            // Address of first character
  ,&GUI_Font24_AA4_Prop10                   // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font24_AA4_Prop8 = {
   0x006B                                   // First character
  ,0x006B                                   // Last character 
  ,&GUI_Font24_AA4_CharInfo[  7]            // Address of first character
  ,&GUI_Font24_AA4_Prop9                    // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font24_AA4_Prop7 = {
   0x0069                                   // First character
  ,0x0069                                   // Last character 
  ,&GUI_Font24_AA4_CharInfo[  6]            // Address of first character
  ,&GUI_Font24_AA4_Prop8                    // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font24_AA4_Prop6 = {
   0x0065                                   // First character
  ,0x0065                                   // Last character 
  ,&GUI_Font24_AA4_CharInfo[  5]            // Address of first character
  ,&GUI_Font24_AA4_Prop7                    // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font24_AA4_Prop5 = {
   0x0063                                   // First character
  ,0x0063                                   // Last character 
  ,&GUI_Font24_AA4_CharInfo[  4]            // Address of first character
  ,&GUI_Font24_AA4_Prop6                    // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font24_AA4_Prop4 = {
   0x0054                                   // First character
  ,0x0054                                   // Last character 
  ,&GUI_Font24_AA4_CharInfo[  3]            // Address of first character
  ,&GUI_Font24_AA4_Prop5                    // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font24_AA4_Prop3 = {
   0x0044                                   // First character
  ,0x0044                                   // Last character 
  ,&GUI_Font24_AA4_CharInfo[  2]            // Address of first character
  ,&GUI_Font24_AA4_Prop4                    // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font24_AA4_Prop2 = {
   0x002D                                   // First character
  ,0x002D                                   // Last character 
  ,&GUI_Font24_AA4_CharInfo[  1]            // Address of first character
  ,&GUI_Font24_AA4_Prop3                    // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT_PROP_EXT GUI_Font24_AA4_Prop1 = {
   0x0020                                   // First character
  ,0x0020                                   // Last character 
  ,&GUI_Font24_AA4_CharInfo[  0]            // Address of first character
  ,&GUI_Font24_AA4_Prop2                    // Pointer to next GUI_FONT_PROP_EXT
};

GUI_CONST_STORAGE GUI_FONT GUI_Font24_AA4 = {
   GUI_FONTTYPE_PROP_AA4_EXT // type of font   
  ,24 // Height of font 
  ,24 // Space of font y
  ,1  // Magnification x
  ,1  // Magnification y
  ,{&GUI_Font24_AA4_Prop1}
  ,19 // Baseline
  ,11 // Height of lowercase characters
  ,15 // Height of capital characters
};

/*********************************************************************
*
*       _bmSeggerLogo_60x30
*/
static GUI_CONST_STORAGE unsigned long acSeggerLogo_60x30[] = {
  0x9F292929, 0x10292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x10292929, 0x9F292929,
  0x10292929, 0x00515151, 0x00AFAFAF, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 
        0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 
        0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00AFAFAF, 0x00515151, 0x10292929,
  0x00292929, 0x00AFAFAF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00292929,
  0x00292929, 0x00CACACA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929,
  0x00292929, 0x00CACACA, 0x00FFFFFF, 0x00AA6661, 0x00AA6661, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00CBA19E, 0x0096433D, 0x00DEC4C2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929,
  0x00292929, 0x00CACACA, 0x00FFFFFF, 0x00A35B55, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00CBA19E, 0x0096433D, 0x009D4F49, 0x00F2E8E7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929,
  0x00292929, 0x00CACACA, 0x00FFFFFF, 0x00EBDCDB, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x00AA6661, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929,
  0x00292929, 0x00CACACA, 0x00FFFFFF, 0x00FFFFFF, 0x00D1ADAA, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00F8F3F3, 0x009D4F49, 0x0096433D, 0x00BD8A86, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929,
  0x00292929, 0x00CACACA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B77E7A, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00E5D0CF, 0x0096433D, 0x0096433D, 0x00D8B9B6, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929,
  0x00292929, 0x00CACACA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x00A35B55, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00CBA19E, 0x0096433D, 0x009D4F49, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929,
  0x00292929, 0x00CACACA, 0x00FFFFFF, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00B77E7A, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929,
  0x00292929, 0x00CACACA, 0x00FFFFFF, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00D1ADAA, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00F8F3F3, 0x00A35B55, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929,
  0x00292929, 0x00CACACA, 0x00FFFFFF, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00B77E7A, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00EBDCDB, 0x0096433D, 0x0096433D, 0x00AA6661, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 
        0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 
        0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00D8B9B6, 0x00FFFFFF, 0x00CACACA, 0x00292929,
  0x00292929, 0x00CACACA, 0x00FFFFFF, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00F8F3F3, 0x00A35B55, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00D1ADAA, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00C49592, 0x00FFFFFF, 0x00CACACA, 0x00292929,
  0x00292929, 0x00CACACA, 0x00FFFFFF, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x0096433D, 0x0096433D, 0x00D8B9B6, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929,
  0x00292929, 0x00CACACA, 0x00FFFFFF, 0x0096433D, 0x0096433D, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x0096433D, 0x0096433D, 0x00D8B9B6, 0x00FFFFFF, 0x00FFFFFF, 0x00F2E8E7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929,
  0x00292929, 0x00CACACA, 0x00FFFFFF, 0x0096433D, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00F8F3F3, 0x00A35B55, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00D1ADAA, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 
        0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x0096433D, 0x00C49592, 0x00FFFFFF, 0x00CACACA, 0x00292929,
  0x00292929, 0x00CACACA, 0x00FFFFFF, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00FFFFFF, 0x00B77E7A, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00EBDCDB, 0x0096433D, 0x0096433D, 0x00AA6661, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 
        0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 
        0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00B0726E, 0x00D8B9B6, 0x00FFFFFF, 0x00CACACA, 0x00292929,
  0x00292929, 0x00CACACA, 0x00FFFFFF, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00D1ADAA, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00F8F3F3, 0x00A35B55, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929,
  0x00292929, 0x00CACACA, 0x00FFFFFF, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00EBDCDB, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00B77E7A, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929,
  0x00292929, 0x00CACACA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F8F3F3, 0x00A35B55, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00CBA19E, 0x0096433D, 0x009D4F49, 0x00EBDCDB, 0x00FFFFFF, 0x00A1A1A1, 0x00292929, 0x00292929, 0x00292929, 0x005F5F5F, 
        0x00F2F2F2, 0x00BCBCBC, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00363636, 0x00FFFFFF, 0x00AFAFAF, 0x00363636, 0x00292929, 0x00292929, 0x00444444, 0x00BCBCBC, 0x00FFFFFF, 0x00F2F2F2, 0x005F5F5F, 0x00292929, 0x00292929, 0x00292929, 
        0x00797979, 0x00FFFFFF, 0x00D7D7D7, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00363636, 0x00FFFFFF, 0x00363636, 0x00292929, 0x00292929, 0x00292929, 0x00444444, 0x00CACACA, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929,
  0x00292929, 0x00CACACA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00B77E7A, 0x0096433D, 0x00A35B55, 0x00F8F3F3, 0x00FFFFFF, 0x00E5D0CF, 0x0096433D, 0x0096433D, 0x00D8B9B6, 0x00FFFFFF, 0x00FFFFFF, 0x00292929, 0x00515151, 0x00E4E4E4, 0x00A1A1A1, 0x00292929, 
        0x00BCBCBC, 0x00949494, 0x00292929, 0x00A1A1A1, 0x00CACACA, 0x00CACACA, 0x00D7D7D7, 0x00E4E4E4, 0x00292929, 0x00515151, 0x00BCBCBC, 0x00BCBCBC, 0x00363636, 0x005F5F5F, 0x00FFFFFF, 0x006C6C6C, 0x00292929, 0x00A1A1A1, 0x00CACACA, 0x00797979, 
        0x00292929, 0x00CACACA, 0x00CACACA, 0x00292929, 0x00A1A1A1, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00FFFFFF, 0x00292929, 0x00797979, 0x00CACACA, 0x00BCBCBC, 0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929,
  0x00292929, 0x00CACACA, 0x00FFFFFF, 0x00FFFFFF, 0x00D1ADAA, 0x0096433D, 0x0096433D, 0x00EBDCDB, 0x00FFFFFF, 0x00F8F3F3, 0x009D4F49, 0x0096433D, 0x00BD8A86, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00444444, 0x00292929, 0x00515151, 0x00797979, 0x00AFAFAF, 
        0x00FFFFFF, 0x00949494, 0x00292929, 0x00515151, 0x005F5F5F, 0x005F5F5F, 0x00BCBCBC, 0x00A1A1A1, 0x00292929, 0x00AFAFAF, 0x00FFFFFF, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00FFFFFF, 0x00292929, 0x00515151, 0x00FFFFFF, 0x00E4E4E4, 0x00CACACA, 
        0x00CACACA, 0x00E4E4E4, 0x00CACACA, 0x00292929, 0x00515151, 0x005F5F5F, 0x005F5F5F, 0x00949494, 0x00FFFFFF, 0x00292929, 0x005F5F5F, 0x00949494, 0x00878787, 0x00292929, 0x00797979, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929,
  0x00292929, 0x00CACACA, 0x00FFFFFF, 0x00EBDCDB, 0x0096433D, 0x0096433D, 0x00D1ADAA, 0x00FFFFFF, 0x00FFFFFF, 0x00AA6661, 0x0096433D, 0x00AA6661, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00A1A1A1, 0x006C6C6C, 0x00363636, 0x00292929, 
        0x00878787, 0x00949494, 0x00292929, 0x00797979, 0x00949494, 0x00949494, 0x00CACACA, 0x00949494, 0x00292929, 0x00BCBCBC, 0x00FFFFFF, 0x00363636, 0x00292929, 0x00292929, 0x00CACACA, 0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00A1A1A1, 0x00292929, 
        0x00292929, 0x00949494, 0x00CACACA, 0x00292929, 0x00797979, 0x00949494, 0x00949494, 0x00BCBCBC, 0x00FFFFFF, 0x00292929, 0x00444444, 0x005F5F5F, 0x00363636, 0x00292929, 0x00AFAFAF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929,
  0x00292929, 0x00CACACA, 0x00FFFFFF, 0x00A35B55, 0x0096433D, 0x00B77E7A, 0x00FFFFFF, 0x00FFFFFF, 0x00CBA19E, 0x0096433D, 0x009D4F49, 0x00F2E8E7, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00363636, 0x00797979, 0x00F2F2F2, 0x00E4E4E4, 0x00292929, 
        0x005F5F5F, 0x00949494, 0x00292929, 0x00A1A1A1, 0x00CACACA, 0x00CACACA, 0x00D7D7D7, 0x00D7D7D7, 0x00292929, 0x00515151, 0x00E4E4E4, 0x00E4E4E4, 0x00515151, 0x00292929, 0x00CACACA, 0x005F5F5F, 0x00292929, 0x00A1A1A1, 0x00FFFFFF, 0x00A1A1A1, 
        0x00292929, 0x00949494, 0x00CACACA, 0x00292929, 0x00A1A1A1, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00FFFFFF, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00D7D7D7, 0x00292929, 0x00878787, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929,
  0x00292929, 0x00CACACA, 0x00FFFFFF, 0x00AA6661, 0x00AA6661, 0x00F8F3F3, 0x00FFFFFF, 0x00FFFFFF, 0x00CBA19E, 0x0096433D, 0x00DEC4C2, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00878787, 0x00292929, 0x00292929, 0x00292929, 0x00363636, 
        0x00BCBCBC, 0x00AFAFAF, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00FFFFFF, 0x00AFAFAF, 0x00292929, 0x00292929, 0x00292929, 0x00444444, 0x00292929, 0x00CACACA, 0x00D7D7D7, 0x00444444, 0x00292929, 0x00292929, 0x00292929, 
        0x00363636, 0x00949494, 0x00CACACA, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00CACACA, 0x00292929, 0x00949494, 0x00FFFFFF, 0x00FFFFFF, 0x00292929, 0x005F5F5F, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929,
  0x00292929, 0x00CACACA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00E4E4E4, 0x00CACACA, 0x00CACACA, 0x00F2F2F2, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00F2F2F2, 0x00CACACA, 0x00CACACA, 0x00FFFFFF, 0x00CACACA, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00CACACA, 0x00E4E4E4, 
        0x00E4E4E4, 0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00D7D7D7, 0x00F2F2F2, 0x00FFFFFF, 0x00FFFFFF, 0x00D7D7D7, 0x00E4E4E4, 0x00FFFFFF, 0x00FFFFFF, 0x00CACACA, 0x00292929,
  0x00292929, 0x00AFAFAF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 
        0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00FFFFFF, 0x00AFAFAF, 0x00292929,
  0x10292929, 0x00515151, 0x00AFAFAF, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 
        0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 
        0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00CACACA, 0x00AFAFAF, 0x00515151, 0x10292929,
  0x9F292929, 0x10292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 
        0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x00292929, 0x10292929, 0x9F292929
};

static GUI_CONST_STORAGE GUI_BITMAP _bmSeggerLogo_60x30 = {
  60,   // XSize
  30,   // YSize
  240,  // BytesPerLine
  32,   // BitsPerPixel
  (unsigned char *)acSeggerLogo_60x30,  // Pointer to picture data
  NULL  // Pointer to palette
 ,GUI_DRAW_BMP8888
};

static WM_HWIN _hBk;

/*********************************************************************
*
*       Static code (MemoryDevice based ticker)
*
**********************************************************************
*/
/*********************************************************************
*
*       _cbTickerMD
*/
static void _cbTickerMD(GUI_TIMER_MESSAGE * pTM) {
  TICKER_CONTEXT_MD * pContext;
  GUI_MEMDEV_Handle   hMemOld;

  pContext = (TICKER_CONTEXT_MD *)pTM->Context;
  GUI_TIMER_Restart(pContext->Ticker.hTimer);
  WM_SelectWindow(_hBk);
  //
  // Prepare text device
  //
  hMemOld = GUI_MEMDEV_Select(pContext->hMemText);
  GUI_MEMDEV_WriteAt(pContext->hMemBk, 0, 0);
  GUI_SetColor(pContext->Ticker.TextColor);
  GUI_SetTextMode(GUI_TM_TRANS);
  GUI_DispStringAt(pContext->Ticker.pText, pContext->Ticker.vxPos / 8, 0);
  GUI_MEMDEV_Select(hMemOld);
  //
  // Draw it
  //
  hMemOld = GUI_MEMDEV_Select(pContext->hMemWork);
  GUI_MEMDEV_Write(pContext->hMemBk);
  GUI_MEMDEV_RotateHQHR(pContext->hMemText, pContext->hMemWork, pContext->Ticker.vxPos % 8, 0, 0, 1000);
  GUI_MEMDEV_Select(hMemOld);
  GUI_MEMDEV_Write(pContext->hMemWork);
  //
  // Move virtual text position
  //
  pContext->Ticker.vxPos += pContext->Ticker.dx;
  if ((pContext->Ticker.vxPos / 8) >= pContext->Ticker.xSize) {
    pContext->Ticker.vxPos = -(pContext->Ticker.xSizeText - 1) * 8;
  }
  if ((pContext->Ticker.vxPos / 8) <= -pContext->Ticker.xSizeText) {
    pContext->Ticker.vxPos = (pContext->Ticker.xSize - 1) * 8;
  }
}

/*********************************************************************
*
*       _StartTickerMD
*/
static int _StartTickerMD(int xPos, int yPos, int xSize, int ySize, int dx, int Period, const char * pText, const GUI_FONT * pFont, GUI_COLOR Color, TICKER_CONTEXT_MD * pContext) {

  pContext->Ticker.pText     = pText;
  pContext->Ticker.pFont     = pFont;
  pContext->Ticker.TextColor = Color;
  pContext->Ticker.xPos      = xPos;
  pContext->Ticker.yPos      = yPos;
  pContext->Ticker.dx        = dx;

  GUI_SetFont(pContext->Ticker.pFont);
  pContext->Ticker.xSizeText = GUI_GetStringDistX(pContext->Ticker.pText);
  if (xSize == 0) {
    xSize = pContext->Ticker.xSizeText;
  }
  if (ySize == 0) {
    ySize = GUI_GetFontSizeY();
  }
  pContext->Ticker.xSize = xSize;
  pContext->Ticker.ySize = ySize;
  //
  // Calculate virtual text start position
  //
  if (dx > 0) {
    pContext->Ticker.vxPos = -(pContext->Ticker.xSizeText - 1) * 8;
  } else {
    pContext->Ticker.vxPos = +(pContext->Ticker.xSize - 1) * 8;
  }
  //
  // Background device
  //
  pContext->hMemBk = GUI_MEMDEV_CreateFixed(xPos, yPos, xSize, ySize, GUI_MEMDEV_NOTRANS, GUI_MEMDEV_APILIST_32, GUICC_8888);
  if (pContext->hMemBk == 0) {
    return 1;
  }
  //
  // Working device
  //
  pContext->hMemWork = GUI_MEMDEV_CreateFixed(xPos, yPos, xSize, ySize, GUI_MEMDEV_NOTRANS, GUI_MEMDEV_APILIST_32, GUICC_8888);
  if (pContext->hMemWork == 0) {
    GUI_MEMDEV_Delete(pContext->hMemBk);
    return 1;
  }
  GUI_MEMDEV_CopyFromLCD(pContext->hMemBk);
  //
  // Text device
  //
  pContext->hMemText = GUI_MEMDEV_CreateFixed(0, 0, xSize, ySize, GUI_MEMDEV_NOTRANS, GUI_MEMDEV_APILIST_32, GUICC_8888);
  if (pContext->hMemText == 0) {
    GUI_MEMDEV_Delete(pContext->hMemBk);
    GUI_MEMDEV_Delete(pContext->hMemWork);
    return 1;
  }
  //
  // Create timer
  //
  pContext->Ticker.hTimer = GUI_TIMER_Create(_cbTickerMD, 0, (U32)pContext, 0);
  if (pContext->Ticker.hTimer == 0) {
    GUI_MEMDEV_Delete(pContext->hMemBk);
    GUI_MEMDEV_Delete(pContext->hMemWork);
    GUI_MEMDEV_Delete(pContext->hMemText);
    return 1;
  }
  GUI_TIMER_SetPeriod(pContext->Ticker.hTimer, Period);
  return 0;
}

/*********************************************************************
*
*       Static code (WindowManager based ticker)
*
**********************************************************************
*/
/*********************************************************************
*
*       _cbTickerWM
*/
static void _cbTickerWM(WM_MESSAGE * pMsg) {
  TICKER_CONTEXT_WM * pContext;

  WM_GetUserData(pMsg->hWin, &pContext, sizeof(pContext));
  switch (pMsg->MsgId) {
  case WM_TIMER:
    //
    // Invalidate window and restart timer
    //
    WM_Invalidate(pMsg->hWin);
    WM_RestartTimer(pMsg->Data.v, 0);
    //
    // Move virtual text position
    //
    pContext->Ticker.vxPos += pContext->Ticker.dx;
    if ((pContext->Ticker.vxPos) >= pContext->Ticker.xSize) {
      pContext->Ticker.vxPos = -(pContext->Ticker.xSizeText - 1);
    }
    if ((pContext->Ticker.vxPos) <= -pContext->Ticker.xSizeText) {
      pContext->Ticker.vxPos = (pContext->Ticker.xSize - 1);
    }
    break;
  case WM_PAINT:
    //
    // Draw ticker text
    //
    GUI_SetBkColor(TICKER_BKCOLOR);
    GUI_Clear();
    GUI_SetFont(pContext->Ticker.pFont);
    GUI_SetTextMode(GUI_TM_TRANS);
    GUI_SetColor(pContext->Ticker.TextColor);
    GUI_DispStringAt(pContext->Ticker.pText, pContext->Ticker.vxPos, pContext->Ticker.vyPos);
    break;
  default:
    WM_DefaultProc(pMsg);
  }
}

/*********************************************************************
*
*       _StartTickerWM
*/
static int _StartTickerWM(int xPos, int yPos, int xSize, int ySize, int dx, int Period, const char * pText, const GUI_FONT * pFont, GUI_COLOR Color, TICKER_CONTEXT_WM * pContext, WM_HWIN hParent) {
  GUI_SetFont(pFont);
  pContext->Ticker.xSizeText = GUI_GetStringDistX(pContext->Ticker.pText);
  if (xSize == 0) {
    xSize = pContext->Ticker.xSizeText;
  }
  if (ySize == 0) {
    ySize = GUI_GetFontSizeY();
  }
  pContext->Ticker.pText     = pText;
  pContext->Ticker.pFont     = pFont;
  pContext->Ticker.TextColor = Color;
  pContext->Ticker.xPos      = xPos;
  pContext->Ticker.yPos      = yPos;
  pContext->Ticker.xSize     = xSize;
  pContext->Ticker.ySize     = ySize;
  pContext->Ticker.dx        = dx;
  pContext->hWin             = hParent;
  pContext->Ticker.xSizeText = GUI_GetStringDistX(pContext->Ticker.pText);
  //
  // Calculate virtual text start position
  //
  if (dx > 0) {
    pContext->Ticker.vxPos = -(pContext->Ticker.xSizeText - 1) * 8;
  } else {
    pContext->Ticker.vxPos = +(pContext->Ticker.xSize - 1) * 8;
  }
  //
  // Create ticker window
  //
  pContext->hWin = WM_CreateWindowAsChild(xPos, yPos, xSize, ySize, hParent, WM_CF_SHOW | WM_CF_MEMDEV, _cbTickerWM, sizeof(pContext));
  if (pContext->hWin == 0) {
    return 1;
  }
  WM_SetUserData(pContext->hWin, &pContext, sizeof(pContext));
  //
  // Create timer
  //
  pContext->Ticker.hTimer = WM_CreateTimer(pContext->hWin, 0, Period, 0);
  if (pContext->Ticker.hTimer == 0) {
    WM_DeleteWindow(pContext->hWin);
    return 1;
  }
  return 0;
}

/*********************************************************************
*
*       _cbBk
*/
static void _cbBk(WM_MESSAGE * pMsg) {
  GUI_CONST_STORAGE GUI_BITMAP * pBitmap;
  TICKER_INFO                  * pInfo;
  static int                   xSize;
  static int                   ySize;
  int                          NCode;
  int                          Value;

  pBitmap = &_bmSeggerLogo_60x30;
  switch (pMsg->MsgId) {
  case WM_NOTIFY_PARENT:
    NCode = pMsg->Data.v;
    switch (NCode) {
    case WM_NOTIFICATION_VALUE_CHANGED:
      Value = SLIDER_GetValue(pMsg->hWinSrc);
      WM_GetUserData(pMsg->hWin, &pInfo, sizeof(TICKER_INFO *));
      //
      // Memory device based ticker
      //
      switch (Value) {
      case 0:
        pInfo->pTickerMD->Ticker.dx = -1;
        GUI_TIMER_SetPeriod(pInfo->pTickerWM->Ticker.hTimer, 10);
        break;
      case 1:
        pInfo->pTickerMD->Ticker.dx = -3;
        GUI_TIMER_SetPeriod(pInfo->pTickerWM->Ticker.hTimer, 20);
        break;
      case 2:
        pInfo->pTickerMD->Ticker.dx = -8;
        GUI_TIMER_SetPeriod(pInfo->pTickerWM->Ticker.hTimer, 20);
        break;
      }
      //
      // Window manager based ticker
      //
      switch (Value) {
      case 0:
        pInfo->pTickerWM->Ticker.dx = 1;
        WM_RestartTimer(pInfo->pTickerWM->Ticker.hTimer, 80);
        break;
      case 1:
        pInfo->pTickerWM->Ticker.dx = 1;
        WM_RestartTimer(pInfo->pTickerWM->Ticker.hTimer, 40);
        break;
      case 2:
        pInfo->pTickerWM->Ticker.dx = 2;
        WM_RestartTimer(pInfo->pTickerWM->Ticker.hTimer, 30);
        break;
      }
      break;
    }
    break;
  case WM_PAINT:
    //
    // Draw all sample details only once
    //
    xSize = LCD_GetXSize();
    ySize = LCD_GetYSize();
    GUI_DrawGradientH(0, 0, xSize / 2 - 1, ySize - 1, BK_COLOR0, BK_COLOR1);
    GUI_DrawGradientH(xSize / 2, 0, xSize - 1, ySize - 1, BK_COLOR1, BK_COLOR0);
    GUI_SetColor(0xccffffff);
    GUI_FillRect(0, 0, xSize - 1, 50);
    GUI_DrawRect(0, 0, xSize - 1, 50);
    GUI_DrawBitmap(pBitmap, 10, 10);
    GUI_SetColor(GUI_LIGHTGRAY);
    GUI_SetFont(&GUI_Font24_AA4);
    GUI_SetTextMode(GUI_TM_TRANS);
    GUI_DispStringHCenterAt("Ticker - Demo", (xSize + pBitmap->XSize + 10) / 2, 13);
    GUI_SetFont(GUI_FONT_16_ASCII);
    GUI_DispStringHCenterAt("Memory device based ticker with smooth scrolling:", xSize / 2, YPOS_0 - 30);
    GUI_DispStringHCenterAt("Window manager based ticker:", xSize / 2, YPOS_1 - 30);
    GUI_SetColor(TICKER_BKCOLOR);
    GUI_AA_FillRoundedRect(5, YPOS_0 - 8, xSize - 6, YPOS_0 + 24, 8);
    GUI_AA_FillRoundedRect(5, YPOS_1 - 8, xSize - 6, YPOS_1 + 24, 8);
    GUI_SetColor(GUI_WHITE);
    GUI_AA_DrawRoundedRect(5, YPOS_0 - 8, xSize - 6, YPOS_0 + 24, 8);
    GUI_AA_DrawRoundedRect(5, YPOS_1 - 8, xSize - 6, YPOS_1 + 24, 8);
    break;
  default:
    WM_DefaultProc(pMsg);
  }
}

/*********************************************************************
*
*       _DrawSkinFlex
*
* Function description
*   Skinning function for slider widget
*/
static int _DrawSkinFlex(const WIDGET_ITEM_DRAW_INFO * pDrawItemInfo) {
  int x;
  int y;

  switch (pDrawItemInfo->Cmd) {
  case WIDGET_ITEM_DRAW_THUMB:
    GUI_SetColor(TICKER_BKCOLOR);
    GUI_AA_FillRoundedRect(pDrawItemInfo->x0, pDrawItemInfo->y1 / 2, pDrawItemInfo->x1, pDrawItemInfo->y1, 3);
    GUI_SetColor(GUI_WHITE);
    GUI_AA_DrawRoundedRect(pDrawItemInfo->x0, pDrawItemInfo->y1 / 2, pDrawItemInfo->x1, pDrawItemInfo->y1, 3);
    return 0;
  case WIDGET_ITEM_DRAW_TICKS:
    return 0;
  case WIDGET_ITEM_DRAW_FOCUS:
    return 0;
  case WIDGET_ITEM_DRAW_SHAFT:
    GUI_SetFont(GUI_FONT_8_ASCII);
    GUI_SetTextMode(GUI_TM_TRANS);
    y = (pDrawItemInfo->y1 / 6) * 2;
    x = pDrawItemInfo->x0;
    GUI_SetColor(GUI_LIGHTGRAY);
    GUI_AA_DrawLine(x, y, x + 10, y + 4);
    GUI_AA_DrawLine(x, y, x + 10, y - 4);
    GUI_DrawLine(x, y, x + 15, y);
    GUI_SetTextAlign(GUI_TA_VCENTER);
    GUI_DispStringAt("Slow", x + 20, y);
    x = pDrawItemInfo->x1;
    GUI_AA_DrawLine(x, y, x - 10, y + 4);
    GUI_AA_DrawLine(x, y, x - 10, y - 4);
    GUI_DrawLine(x, y, x - 15, y);
    GUI_SetTextAlign(GUI_TA_VCENTER | GUI_TA_RIGHT);
    GUI_DispStringAt("Fast", x - 20, y);
    GUI_SetLineStyle(GUI_LS_DASH);
    GUI_SetTextAlign(GUI_TA_VCENTER | GUI_TA_HCENTER);
    GUI_DispStringAt("Medium", pDrawItemInfo->x1 / 2, y);
    GUI_DrawLine(pDrawItemInfo->x0 + 70, y, pDrawItemInfo->x1 / 2 - 30, y);
    GUI_DrawLine(pDrawItemInfo->x1 - 70, y, pDrawItemInfo->x1 / 2 + 30, y);
    return 0;
  default:
    return SLIDER_DrawSkinFlex(pDrawItemInfo);
  }
}

/*********************************************************************
*
*       Public code
*
**********************************************************************
*/
/*********************************************************************
*
*       MainTask
*/
void MainTask(void) {
  TICKER_CONTEXT_WM  ContextWM = { 0 };
  TICKER_CONTEXT_MD  ContextMD = { 0 };
  const GUI_FONT   * pFont;
  TICKER_INFO        Info;
  TICKER_INFO      * pInfo;
  const char       * pTextMD = "This ticker text is shown with smooth horizontal scrolling by using memory device functions...";
  const char       * pTextWM = "This ticker text is shown with pixel accurate text positioning using the window manager...";
  WM_HWIN            hSlider;
  int                xSize;
  int                ySize;
  int                Cnt;
  int                Key;

  Info.pTickerWM = &ContextWM;
  Info.pTickerMD = &ContextMD;
  pInfo = &Info;
  pFont = &GUI_Font20_AA4;
  WM_SetCreateFlags(WM_CF_MEMDEV);
  GUI_Init();
  //
  // Check if recommended memory for the sample is available
  //
  if (GUI_ALLOC_GetNumFreeBytes() < RECOMMENDED_MEMORY) {
    GUI_ErrorOut("Not enough memory available."); 
    return;
  }
  GUI_EnableAlpha(1);
  xSize = LCD_GetXSize();
  ySize = LCD_GetYSize();
  //
  // Create background window
  //
  _hBk = WM_CreateWindow(0, 0, xSize, ySize, WM_CF_SHOW, _cbBk, sizeof(TICKER_INFO *));
  WM_SetUserData(_hBk, &pInfo, sizeof(TICKER_INFO *));
  //
  // Make sure backgound has already been drawn
  //
  WM_Exec();
  //
  // Create memory device based ticker
  //
  _StartTickerMD(10,  YPOS_0, xSize - 20, 0, -1, TICKER_PERIOD / 8, pTextMD, pFont, GUI_WHITE, &ContextMD);
  //
  // Create window manager based ticker
  //
  _StartTickerWM(10,  YPOS_1, xSize - 20, 0, +1, TICKER_PERIOD / 1, pTextWM, pFont, GUI_WHITE, &ContextWM, _hBk);
  //
  // Create slider for speed setting
  //
  SLIDER_SetDefaultSkin(_DrawSkinFlex);
  hSlider = SLIDER_Create(10, YPOS_SLIDER, xSize - 20, 30, _hBk, GUI_ID_SLIDER0, WM_CF_SHOW, 0);
  SLIDER_SetRange(hSlider, 0, 2);
  WM_SetFocus(hSlider);
  //
  // Keep demo alive...
  //
  Cnt = 0;
  while (1) {
    GUI_Delay(2000);
    Key = ((Cnt++ / 2) % 2) ? GUI_KEY_LEFT : GUI_KEY_RIGHT;
    GUI_StoreKeyMsg(Key, 1);
    GUI_StoreKeyMsg(Key, 0);
  }
}

/*************************** End of file ****************************/

