/*
 *  Copyright 2014 Embedded Artists AB
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

#ifndef APP_COLORPICKER_H
#define APP_COLORPICKER_H

#include "App.h"
#include "DMBoard.h"
#include "lpc_swim.h"
#include "ImageButton.h"
#include "Resource.h"

/**
 * An App example letting the user pick a color from a colored area.
 * The hex value in RGB565 format is shown as well as a larger sample
 * of the selected color.
 *
 * The purpose of this example is to show let the user test the touch
 * panel and it can be helpful when selecting colors for e.g. backgrounds.
 */
class AppColorPicker : public App {
public:

	AppColorPicker();
	virtual ~AppColorPicker();

    virtual bool setup();
    virtual void runToCompletion();
    virtual bool teardown();

    enum Resources {
        Resource_Ok_button,
    };

    /** Specifies the resource to use
     *
     *  Adds a resource for a specific id. This allows the
     *  user program to select e.g. which image to use and
     *  if it should be loaded from a file or an array.
     *
     *  @param id  the identifier
     *  @param res the resource
     */
    void addResource(Resources id, Resource* res);

private:
    Display* _disp;
    SWIM_WINDOW_T* _win;
    SWIM_WINDOW_T* _colorwin;
    COLOR_T* _fb;
    COLOR_T* _fb2;
    ImageButton* _btn;
    Resource* _resOk;
    int _resultX;
    int _resultY;
    int _resultW;
    int _resultH;

    void draw();
};

#endif
