/*
 *  Copyright 2014 Embedded Artists AB
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
#ifndef APP_SLIDESHOW_H
#define APP_SLIDESHOW_H

#include "App.h"
#include "DMBoard.h"
#include "SlideShow.h"
#include "rtos.h"
#include "ImageButton.h"
#include "Resource.h"

/**
 * An App example showing how to use the SlideShow engine.
 *
 * The purpose of this example is to show how the SlideShow class can be used.
 */
class AppSlideShow : public App {
public:

    /** Create a new App based on the specified slideshow
     *
     * @param scriptFile  path and filename of the script to run
     * @param pathPrefix  optional path to prepend to all paths in the script file
     * @param x           optional x coordinate to draw the slideshow at, default is 0
     * @param y           optional y coordinate to draw the slideshow at, default is 0
     */
	AppSlideShow(const char* scriptFile, const char* pathPrefix=NULL, int xoff=0, int yoff=0);
	virtual ~AppSlideShow();

    virtual bool setup();
    virtual void runToCompletion();
    virtual bool teardown();

    enum Resources {
        Resource_Ok_button,
        Resource_Repeat_button,
    };

    /** Specifies the resource to use
     *
     *  Adds a resource for a specific id. This allows the
     *  user program to select e.g. which image to use and
     *  if it should be loaded from a file or an array.
     *
     *  @param id  the identifier
     *  @param res the resource
     */
    void addResource(Resources id, Resource* res);

private:
    void* _fb;
    Display* _disp;
    SlideShow* _show;
    Renderer* _rend;
    Mutex _fileMutex;
    ImageButton* _btnDone;
    ImageButton* _btnRepeat;
    char* _script;
    char* _path;
    int _xoff;
    int _yoff;
    Resource* _resOk;
    Resource* _resRepeat;
};

#endif
