/*
 *  Copyright 2014 Embedded Artists AB
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

#include "mbed.h"
#include "Resource.h"

Resource::Resource(const char* filename, int width, int height) :
    _width(width), _height(height), _isFile(true), _data(NULL), _dataSize(0)
{
    _filename = (char*)malloc(strlen(filename)+1);
    if (_filename != NULL) {
        strcpy(_filename, filename);
    }
    memset(&_img, 0, sizeof(Image::ImageData_t));
}

Resource::Resource(const unsigned char* data, const unsigned int dataSize, int width, int height) :
    _width(width), _height(height), _isFile(false), _filename(NULL), _data(data), _dataSize(dataSize)
{
    memset(&_img, 0, sizeof(Image::ImageData_t));
}

Resource::~Resource()
{
    if (_filename != NULL) {
        free(_filename);
        _filename = NULL;
    }
}

