/*
 * jswitch.cpp -- debounces and reads pins 12 
 *    (SW_DOWN), 13(SW_LEFT),14(SW_CENTER),15(SW_UP),
 *    and 16(SE_RIGHT) of the mbed 40 pin dip board    
 */
#include "mbed.h" 
#include "debug.h"
#include "jswitch.h"

#define JS_BLANKING_MSEC 333

DigitalIn js_down(p12);
DigitalIn js_left(p13);
DigitalIn js_center(p14);
DigitalIn js_up(p15);
DigitalIn js_right(p16);

Timer js_timer;

static unsigned char js_oldest=0;
static unsigned char js_older=0;
static unsigned char js_old=0;
static unsigned char js_now=0;
static unsigned char js_official=0;
static int js_msec=0;

void js_init(void)
{
    js_official = 0;
    js_now = 0;
    js_old = 0;
    js_older = 0;
    js_oldest = 0;
    js_timer.start();
}
/*
 * js_debounce -- button presses will not be reported 
 * any more that once every 333 msec. 
 */
void js_debounce(void){
    if ((js_timer.read_ms()-js_msec)>JS_BLANKING_MSEC) {
        if (js_official==0) {
            js_oldest = js_older; 
            js_older=js_old;
            js_old=js_now;
            js_now = ( (js_center << 4) 
                       | (js_up << 3) 
                       | (js_down << 2) 
                       | (js_left << 1) 
                       | js_right );
            js_official|=(js_now&js_old&js_older&js_oldest);
            if (js_official>0) {
                js_msec=js_timer.read_ms();
            }
        } else {
            js_now=0;
            js_old=0;
            js_older=0;
            js_oldest=0;
        }
    }
}
/*
 *   js_read -- reads buttons indicated by the mask.
 *   once read the masked button indications are cleared
 */
unsigned char js_read(unsigned char mask)
{
    unsigned char retval;

    retval = js_official & mask;
    js_official &= ~retval; 
    return retval;
}


