/*
 ** debug.cpp -- a few handy debug functions
 */
#include "mbed.h"
#include "debug.h"
#include "string.h"
 
 RawSerial rs(USBTX, USBRX);

 static char debug_hexnyb(char);

 void debug_putstr(char *sptr)
 {
     int j,len;

     len = strlen(sptr);
     if (len>64) len = 64;
     for (j=0;j<len;j++) {
         debug_putch(sptr[j]);
     }
 }

 int debug_putch(char ch) {
     return rs.putc(ch);
 }

 void debug_hexbyte(char inch)
 {
     char lonyb,hinyb;

     lonyb = inch & 0x0F;
     hinyb = (inch >> 4) & 0x0F;
     (void)debug_putch(debug_hexnyb(hinyb));
     (void)debug_putch(debug_hexnyb(lonyb));
 }

 char debug_hexnyb(char inval)
 {
     switch (inval) {
     case 0 ... 9:
         return (char)(0x30 | inval);
     case 10 ... 15:
         return (char)(0x37 + inval);
     }
     return ('.');
 }

void debug_hexshort(short inval)
 {
     char loch,hich;

     loch = inval & 0xFF;
     hich = (inval>>8) & 0xFF;
     debug_hexbyte(hich);
     debug_hexbyte(loch);
 }

void debug_crlf(void)
 {
     (void)debug_putch(0x0D);
     (void)debug_putch(0x0A);
 }

void debug_space(void)
 {
     (void)debug_putch(0x20);
 }

