/* 
 * main.cpp 
 * Sending digital note waveforms out the onboard DAC 
 * in responses to touches on an XY pad(resistive touchscreen) 
 * X changes audio volume..  Y changes audio frequency 
 * Varies from forty Hz to 1047 Hz (C6) 
 */
#include "mbed.h"
#include "debug.h"
#include "dma.h"
#include "wave.h"
#include "note.h"
#include "jswitch.h"
#include "touch.h"
#include "envlp.h"

int main(void)
{
    js_init();  // initialize joystick
    envlp_init(); // initialize envelope parameters
    wave_init();  // starts with default wave type
    touch_init();  // initialize touchscreen controller
    note_init();    // initialize note production    

    while (1==1) {
        js_debounce();  // debounce joystick
        envlp_update(); // update envelope parameters
        wave_update();  // update waveform choice
        note_update();  // update note or start a new one
        wait_ms(2);  // lower limit on loop timing
    }
}

