#pragma once
// MESSAGE FUSED_IMU PACKING

#define MAVLINK_MSG_ID_FUSED_IMU 151

MAVPACKED(
typedef struct __mavlink_fused_imu_t {
 uint32_t time_boot_ms; /*< Timestamp (milliseconds since system boot)*/
 float accel_x; /*< X acceleration (m/s^2)*/
 float accel_y; /*< Y acceleration (m/s^2)*/
 float accel_z; /*< Z acceleration (m/s^2)*/
 float gyro_x; /*< Roll angular speed (rad/s)*/
 float gyro_y; /*< Pitch angular speed (rad/s)*/
 float gyro_z; /*< Yaw angular speed (rad/s)*/
 float roll; /*< Roll angle (rad, -pi..+pi)*/
 float pitch; /*< Pitch angle (rad, -pi..+pi)*/
 float yaw; /*< Yaw angle (rad, -pi..+pi)*/
}) mavlink_fused_imu_t;

#define MAVLINK_MSG_ID_FUSED_IMU_LEN 40
#define MAVLINK_MSG_ID_FUSED_IMU_MIN_LEN 40
#define MAVLINK_MSG_ID_151_LEN 40
#define MAVLINK_MSG_ID_151_MIN_LEN 40

#define MAVLINK_MSG_ID_FUSED_IMU_CRC 218
#define MAVLINK_MSG_ID_151_CRC 218



#if MAVLINK_COMMAND_24BIT
#define MAVLINK_MESSAGE_INFO_FUSED_IMU { \
    151, \
    "FUSED_IMU", \
    10, \
    {  { "time_boot_ms", NULL, MAVLINK_TYPE_UINT32_T, 0, 0, offsetof(mavlink_fused_imu_t, time_boot_ms) }, \
         { "accel_x", NULL, MAVLINK_TYPE_FLOAT, 0, 4, offsetof(mavlink_fused_imu_t, accel_x) }, \
         { "accel_y", NULL, MAVLINK_TYPE_FLOAT, 0, 8, offsetof(mavlink_fused_imu_t, accel_y) }, \
         { "accel_z", NULL, MAVLINK_TYPE_FLOAT, 0, 12, offsetof(mavlink_fused_imu_t, accel_z) }, \
         { "gyro_x", NULL, MAVLINK_TYPE_FLOAT, 0, 16, offsetof(mavlink_fused_imu_t, gyro_x) }, \
         { "gyro_y", NULL, MAVLINK_TYPE_FLOAT, 0, 20, offsetof(mavlink_fused_imu_t, gyro_y) }, \
         { "gyro_z", NULL, MAVLINK_TYPE_FLOAT, 0, 24, offsetof(mavlink_fused_imu_t, gyro_z) }, \
         { "roll", NULL, MAVLINK_TYPE_FLOAT, 0, 28, offsetof(mavlink_fused_imu_t, roll) }, \
         { "pitch", NULL, MAVLINK_TYPE_FLOAT, 0, 32, offsetof(mavlink_fused_imu_t, pitch) }, \
         { "yaw", NULL, MAVLINK_TYPE_FLOAT, 0, 36, offsetof(mavlink_fused_imu_t, yaw) }, \
         } \
}
#else
#define MAVLINK_MESSAGE_INFO_FUSED_IMU { \
    "FUSED_IMU", \
    10, \
    {  { "time_boot_ms", NULL, MAVLINK_TYPE_UINT32_T, 0, 0, offsetof(mavlink_fused_imu_t, time_boot_ms) }, \
         { "accel_x", NULL, MAVLINK_TYPE_FLOAT, 0, 4, offsetof(mavlink_fused_imu_t, accel_x) }, \
         { "accel_y", NULL, MAVLINK_TYPE_FLOAT, 0, 8, offsetof(mavlink_fused_imu_t, accel_y) }, \
         { "accel_z", NULL, MAVLINK_TYPE_FLOAT, 0, 12, offsetof(mavlink_fused_imu_t, accel_z) }, \
         { "gyro_x", NULL, MAVLINK_TYPE_FLOAT, 0, 16, offsetof(mavlink_fused_imu_t, gyro_x) }, \
         { "gyro_y", NULL, MAVLINK_TYPE_FLOAT, 0, 20, offsetof(mavlink_fused_imu_t, gyro_y) }, \
         { "gyro_z", NULL, MAVLINK_TYPE_FLOAT, 0, 24, offsetof(mavlink_fused_imu_t, gyro_z) }, \
         { "roll", NULL, MAVLINK_TYPE_FLOAT, 0, 28, offsetof(mavlink_fused_imu_t, roll) }, \
         { "pitch", NULL, MAVLINK_TYPE_FLOAT, 0, 32, offsetof(mavlink_fused_imu_t, pitch) }, \
         { "yaw", NULL, MAVLINK_TYPE_FLOAT, 0, 36, offsetof(mavlink_fused_imu_t, yaw) }, \
         } \
}
#endif

/**
 * @brief Pack a fused_imu message
 * @param system_id ID of this system
 * @param component_id ID of this component (e.g. 200 for IMU)
 * @param msg The MAVLink message to compress the data into
 *
 * @param time_boot_ms Timestamp (milliseconds since system boot)
 * @param accel_x X acceleration (m/s^2)
 * @param accel_y Y acceleration (m/s^2)
 * @param accel_z Z acceleration (m/s^2)
 * @param gyro_x Roll angular speed (rad/s)
 * @param gyro_y Pitch angular speed (rad/s)
 * @param gyro_z Yaw angular speed (rad/s)
 * @param roll Roll angle (rad, -pi..+pi)
 * @param pitch Pitch angle (rad, -pi..+pi)
 * @param yaw Yaw angle (rad, -pi..+pi)
 * @return length of the message in bytes (excluding serial stream start sign)
 */
static inline uint16_t mavlink_msg_fused_imu_pack(uint8_t system_id, uint8_t component_id, mavlink_message_t* msg,
                               uint32_t time_boot_ms, float accel_x, float accel_y, float accel_z, float gyro_x, float gyro_y, float gyro_z, float roll, float pitch, float yaw)
{
#if MAVLINK_NEED_BYTE_SWAP || !MAVLINK_ALIGNED_FIELDS
    char buf[MAVLINK_MSG_ID_FUSED_IMU_LEN];
    _mav_put_uint32_t(buf, 0, time_boot_ms);
    _mav_put_float(buf, 4, accel_x);
    _mav_put_float(buf, 8, accel_y);
    _mav_put_float(buf, 12, accel_z);
    _mav_put_float(buf, 16, gyro_x);
    _mav_put_float(buf, 20, gyro_y);
    _mav_put_float(buf, 24, gyro_z);
    _mav_put_float(buf, 28, roll);
    _mav_put_float(buf, 32, pitch);
    _mav_put_float(buf, 36, yaw);

        memcpy(_MAV_PAYLOAD_NON_CONST(msg), buf, MAVLINK_MSG_ID_FUSED_IMU_LEN);
#else
    mavlink_fused_imu_t packet;
    packet.time_boot_ms = time_boot_ms;
    packet.accel_x = accel_x;
    packet.accel_y = accel_y;
    packet.accel_z = accel_z;
    packet.gyro_x = gyro_x;
    packet.gyro_y = gyro_y;
    packet.gyro_z = gyro_z;
    packet.roll = roll;
    packet.pitch = pitch;
    packet.yaw = yaw;

        memcpy(_MAV_PAYLOAD_NON_CONST(msg), &packet, MAVLINK_MSG_ID_FUSED_IMU_LEN);
#endif

    msg->msgid = MAVLINK_MSG_ID_FUSED_IMU;
    return mavlink_finalize_message(msg, system_id, component_id, MAVLINK_MSG_ID_FUSED_IMU_MIN_LEN, MAVLINK_MSG_ID_FUSED_IMU_LEN, MAVLINK_MSG_ID_FUSED_IMU_CRC);
}

/**
 * @brief Pack a fused_imu message on a channel
 * @param system_id ID of this system
 * @param component_id ID of this component (e.g. 200 for IMU)
 * @param chan The MAVLink channel this message will be sent over
 * @param msg The MAVLink message to compress the data into
 * @param time_boot_ms Timestamp (milliseconds since system boot)
 * @param accel_x X acceleration (m/s^2)
 * @param accel_y Y acceleration (m/s^2)
 * @param accel_z Z acceleration (m/s^2)
 * @param gyro_x Roll angular speed (rad/s)
 * @param gyro_y Pitch angular speed (rad/s)
 * @param gyro_z Yaw angular speed (rad/s)
 * @param roll Roll angle (rad, -pi..+pi)
 * @param pitch Pitch angle (rad, -pi..+pi)
 * @param yaw Yaw angle (rad, -pi..+pi)
 * @return length of the message in bytes (excluding serial stream start sign)
 */
static inline uint16_t mavlink_msg_fused_imu_pack_chan(uint8_t system_id, uint8_t component_id, uint8_t chan,
                               mavlink_message_t* msg,
                                   uint32_t time_boot_ms,float accel_x,float accel_y,float accel_z,float gyro_x,float gyro_y,float gyro_z,float roll,float pitch,float yaw)
{
#if MAVLINK_NEED_BYTE_SWAP || !MAVLINK_ALIGNED_FIELDS
    char buf[MAVLINK_MSG_ID_FUSED_IMU_LEN];
    _mav_put_uint32_t(buf, 0, time_boot_ms);
    _mav_put_float(buf, 4, accel_x);
    _mav_put_float(buf, 8, accel_y);
    _mav_put_float(buf, 12, accel_z);
    _mav_put_float(buf, 16, gyro_x);
    _mav_put_float(buf, 20, gyro_y);
    _mav_put_float(buf, 24, gyro_z);
    _mav_put_float(buf, 28, roll);
    _mav_put_float(buf, 32, pitch);
    _mav_put_float(buf, 36, yaw);

        memcpy(_MAV_PAYLOAD_NON_CONST(msg), buf, MAVLINK_MSG_ID_FUSED_IMU_LEN);
#else
    mavlink_fused_imu_t packet;
    packet.time_boot_ms = time_boot_ms;
    packet.accel_x = accel_x;
    packet.accel_y = accel_y;
    packet.accel_z = accel_z;
    packet.gyro_x = gyro_x;
    packet.gyro_y = gyro_y;
    packet.gyro_z = gyro_z;
    packet.roll = roll;
    packet.pitch = pitch;
    packet.yaw = yaw;

        memcpy(_MAV_PAYLOAD_NON_CONST(msg), &packet, MAVLINK_MSG_ID_FUSED_IMU_LEN);
#endif

    msg->msgid = MAVLINK_MSG_ID_FUSED_IMU;
    return mavlink_finalize_message_chan(msg, system_id, component_id, chan, MAVLINK_MSG_ID_FUSED_IMU_MIN_LEN, MAVLINK_MSG_ID_FUSED_IMU_LEN, MAVLINK_MSG_ID_FUSED_IMU_CRC);
}

/**
 * @brief Encode a fused_imu struct
 *
 * @param system_id ID of this system
 * @param component_id ID of this component (e.g. 200 for IMU)
 * @param msg The MAVLink message to compress the data into
 * @param fused_imu C-struct to read the message contents from
 */
static inline uint16_t mavlink_msg_fused_imu_encode(uint8_t system_id, uint8_t component_id, mavlink_message_t* msg, const mavlink_fused_imu_t* fused_imu)
{
    return mavlink_msg_fused_imu_pack(system_id, component_id, msg, fused_imu->time_boot_ms, fused_imu->accel_x, fused_imu->accel_y, fused_imu->accel_z, fused_imu->gyro_x, fused_imu->gyro_y, fused_imu->gyro_z, fused_imu->roll, fused_imu->pitch, fused_imu->yaw);
}

/**
 * @brief Encode a fused_imu struct on a channel
 *
 * @param system_id ID of this system
 * @param component_id ID of this component (e.g. 200 for IMU)
 * @param chan The MAVLink channel this message will be sent over
 * @param msg The MAVLink message to compress the data into
 * @param fused_imu C-struct to read the message contents from
 */
static inline uint16_t mavlink_msg_fused_imu_encode_chan(uint8_t system_id, uint8_t component_id, uint8_t chan, mavlink_message_t* msg, const mavlink_fused_imu_t* fused_imu)
{
    return mavlink_msg_fused_imu_pack_chan(system_id, component_id, chan, msg, fused_imu->time_boot_ms, fused_imu->accel_x, fused_imu->accel_y, fused_imu->accel_z, fused_imu->gyro_x, fused_imu->gyro_y, fused_imu->gyro_z, fused_imu->roll, fused_imu->pitch, fused_imu->yaw);
}

/**
 * @brief Send a fused_imu message
 * @param chan MAVLink channel to send the message
 *
 * @param time_boot_ms Timestamp (milliseconds since system boot)
 * @param accel_x X acceleration (m/s^2)
 * @param accel_y Y acceleration (m/s^2)
 * @param accel_z Z acceleration (m/s^2)
 * @param gyro_x Roll angular speed (rad/s)
 * @param gyro_y Pitch angular speed (rad/s)
 * @param gyro_z Yaw angular speed (rad/s)
 * @param roll Roll angle (rad, -pi..+pi)
 * @param pitch Pitch angle (rad, -pi..+pi)
 * @param yaw Yaw angle (rad, -pi..+pi)
 */
#ifdef MAVLINK_USE_CONVENIENCE_FUNCTIONS

static inline void mavlink_msg_fused_imu_send(mavlink_channel_t chan, uint32_t time_boot_ms, float accel_x, float accel_y, float accel_z, float gyro_x, float gyro_y, float gyro_z, float roll, float pitch, float yaw)
{
#if MAVLINK_NEED_BYTE_SWAP || !MAVLINK_ALIGNED_FIELDS
    char buf[MAVLINK_MSG_ID_FUSED_IMU_LEN];
    _mav_put_uint32_t(buf, 0, time_boot_ms);
    _mav_put_float(buf, 4, accel_x);
    _mav_put_float(buf, 8, accel_y);
    _mav_put_float(buf, 12, accel_z);
    _mav_put_float(buf, 16, gyro_x);
    _mav_put_float(buf, 20, gyro_y);
    _mav_put_float(buf, 24, gyro_z);
    _mav_put_float(buf, 28, roll);
    _mav_put_float(buf, 32, pitch);
    _mav_put_float(buf, 36, yaw);

    _mav_finalize_message_chan_send(chan, MAVLINK_MSG_ID_FUSED_IMU, buf, MAVLINK_MSG_ID_FUSED_IMU_MIN_LEN, MAVLINK_MSG_ID_FUSED_IMU_LEN, MAVLINK_MSG_ID_FUSED_IMU_CRC);
#else
    mavlink_fused_imu_t packet;
    packet.time_boot_ms = time_boot_ms;
    packet.accel_x = accel_x;
    packet.accel_y = accel_y;
    packet.accel_z = accel_z;
    packet.gyro_x = gyro_x;
    packet.gyro_y = gyro_y;
    packet.gyro_z = gyro_z;
    packet.roll = roll;
    packet.pitch = pitch;
    packet.yaw = yaw;

    _mav_finalize_message_chan_send(chan, MAVLINK_MSG_ID_FUSED_IMU, (const char *)&packet, MAVLINK_MSG_ID_FUSED_IMU_MIN_LEN, MAVLINK_MSG_ID_FUSED_IMU_LEN, MAVLINK_MSG_ID_FUSED_IMU_CRC);
#endif
}

/**
 * @brief Send a fused_imu message
 * @param chan MAVLink channel to send the message
 * @param struct The MAVLink struct to serialize
 */
static inline void mavlink_msg_fused_imu_send_struct(mavlink_channel_t chan, const mavlink_fused_imu_t* fused_imu)
{
#if MAVLINK_NEED_BYTE_SWAP || !MAVLINK_ALIGNED_FIELDS
    mavlink_msg_fused_imu_send(chan, fused_imu->time_boot_ms, fused_imu->accel_x, fused_imu->accel_y, fused_imu->accel_z, fused_imu->gyro_x, fused_imu->gyro_y, fused_imu->gyro_z, fused_imu->roll, fused_imu->pitch, fused_imu->yaw);
#else
    _mav_finalize_message_chan_send(chan, MAVLINK_MSG_ID_FUSED_IMU, (const char *)fused_imu, MAVLINK_MSG_ID_FUSED_IMU_MIN_LEN, MAVLINK_MSG_ID_FUSED_IMU_LEN, MAVLINK_MSG_ID_FUSED_IMU_CRC);
#endif
}

#if MAVLINK_MSG_ID_FUSED_IMU_LEN <= MAVLINK_MAX_PAYLOAD_LEN
/*
  This varient of _send() can be used to save stack space by re-using
  memory from the receive buffer.  The caller provides a
  mavlink_message_t which is the size of a full mavlink message. This
  is usually the receive buffer for the channel, and allows a reply to an
  incoming message with minimum stack space usage.
 */
static inline void mavlink_msg_fused_imu_send_buf(mavlink_message_t *msgbuf, mavlink_channel_t chan,  uint32_t time_boot_ms, float accel_x, float accel_y, float accel_z, float gyro_x, float gyro_y, float gyro_z, float roll, float pitch, float yaw)
{
#if MAVLINK_NEED_BYTE_SWAP || !MAVLINK_ALIGNED_FIELDS
    char *buf = (char *)msgbuf;
    _mav_put_uint32_t(buf, 0, time_boot_ms);
    _mav_put_float(buf, 4, accel_x);
    _mav_put_float(buf, 8, accel_y);
    _mav_put_float(buf, 12, accel_z);
    _mav_put_float(buf, 16, gyro_x);
    _mav_put_float(buf, 20, gyro_y);
    _mav_put_float(buf, 24, gyro_z);
    _mav_put_float(buf, 28, roll);
    _mav_put_float(buf, 32, pitch);
    _mav_put_float(buf, 36, yaw);

    _mav_finalize_message_chan_send(chan, MAVLINK_MSG_ID_FUSED_IMU, buf, MAVLINK_MSG_ID_FUSED_IMU_MIN_LEN, MAVLINK_MSG_ID_FUSED_IMU_LEN, MAVLINK_MSG_ID_FUSED_IMU_CRC);
#else
    mavlink_fused_imu_t *packet = (mavlink_fused_imu_t *)msgbuf;
    packet->time_boot_ms = time_boot_ms;
    packet->accel_x = accel_x;
    packet->accel_y = accel_y;
    packet->accel_z = accel_z;
    packet->gyro_x = gyro_x;
    packet->gyro_y = gyro_y;
    packet->gyro_z = gyro_z;
    packet->roll = roll;
    packet->pitch = pitch;
    packet->yaw = yaw;

    _mav_finalize_message_chan_send(chan, MAVLINK_MSG_ID_FUSED_IMU, (const char *)packet, MAVLINK_MSG_ID_FUSED_IMU_MIN_LEN, MAVLINK_MSG_ID_FUSED_IMU_LEN, MAVLINK_MSG_ID_FUSED_IMU_CRC);
#endif
}
#endif

#endif

// MESSAGE FUSED_IMU UNPACKING


/**
 * @brief Get field time_boot_ms from fused_imu message
 *
 * @return Timestamp (milliseconds since system boot)
 */
static inline uint32_t mavlink_msg_fused_imu_get_time_boot_ms(const mavlink_message_t* msg)
{
    return _MAV_RETURN_uint32_t(msg,  0);
}

/**
 * @brief Get field accel_x from fused_imu message
 *
 * @return X acceleration (m/s^2)
 */
static inline float mavlink_msg_fused_imu_get_accel_x(const mavlink_message_t* msg)
{
    return _MAV_RETURN_float(msg,  4);
}

/**
 * @brief Get field accel_y from fused_imu message
 *
 * @return Y acceleration (m/s^2)
 */
static inline float mavlink_msg_fused_imu_get_accel_y(const mavlink_message_t* msg)
{
    return _MAV_RETURN_float(msg,  8);
}

/**
 * @brief Get field accel_z from fused_imu message
 *
 * @return Z acceleration (m/s^2)
 */
static inline float mavlink_msg_fused_imu_get_accel_z(const mavlink_message_t* msg)
{
    return _MAV_RETURN_float(msg,  12);
}

/**
 * @brief Get field gyro_x from fused_imu message
 *
 * @return Roll angular speed (rad/s)
 */
static inline float mavlink_msg_fused_imu_get_gyro_x(const mavlink_message_t* msg)
{
    return _MAV_RETURN_float(msg,  16);
}

/**
 * @brief Get field gyro_y from fused_imu message
 *
 * @return Pitch angular speed (rad/s)
 */
static inline float mavlink_msg_fused_imu_get_gyro_y(const mavlink_message_t* msg)
{
    return _MAV_RETURN_float(msg,  20);
}

/**
 * @brief Get field gyro_z from fused_imu message
 *
 * @return Yaw angular speed (rad/s)
 */
static inline float mavlink_msg_fused_imu_get_gyro_z(const mavlink_message_t* msg)
{
    return _MAV_RETURN_float(msg,  24);
}

/**
 * @brief Get field roll from fused_imu message
 *
 * @return Roll angle (rad, -pi..+pi)
 */
static inline float mavlink_msg_fused_imu_get_roll(const mavlink_message_t* msg)
{
    return _MAV_RETURN_float(msg,  28);
}

/**
 * @brief Get field pitch from fused_imu message
 *
 * @return Pitch angle (rad, -pi..+pi)
 */
static inline float mavlink_msg_fused_imu_get_pitch(const mavlink_message_t* msg)
{
    return _MAV_RETURN_float(msg,  32);
}

/**
 * @brief Get field yaw from fused_imu message
 *
 * @return Yaw angle (rad, -pi..+pi)
 */
static inline float mavlink_msg_fused_imu_get_yaw(const mavlink_message_t* msg)
{
    return _MAV_RETURN_float(msg,  36);
}

/**
 * @brief Decode a fused_imu message into a struct
 *
 * @param msg The message to decode
 * @param fused_imu C-struct to decode the message contents into
 */
static inline void mavlink_msg_fused_imu_decode(const mavlink_message_t* msg, mavlink_fused_imu_t* fused_imu)
{
#if MAVLINK_NEED_BYTE_SWAP || !MAVLINK_ALIGNED_FIELDS
    fused_imu->time_boot_ms = mavlink_msg_fused_imu_get_time_boot_ms(msg);
    fused_imu->accel_x = mavlink_msg_fused_imu_get_accel_x(msg);
    fused_imu->accel_y = mavlink_msg_fused_imu_get_accel_y(msg);
    fused_imu->accel_z = mavlink_msg_fused_imu_get_accel_z(msg);
    fused_imu->gyro_x = mavlink_msg_fused_imu_get_gyro_x(msg);
    fused_imu->gyro_y = mavlink_msg_fused_imu_get_gyro_y(msg);
    fused_imu->gyro_z = mavlink_msg_fused_imu_get_gyro_z(msg);
    fused_imu->roll = mavlink_msg_fused_imu_get_roll(msg);
    fused_imu->pitch = mavlink_msg_fused_imu_get_pitch(msg);
    fused_imu->yaw = mavlink_msg_fused_imu_get_yaw(msg);
#else
        uint8_t len = msg->len < MAVLINK_MSG_ID_FUSED_IMU_LEN? msg->len : MAVLINK_MSG_ID_FUSED_IMU_LEN;
        memset(fused_imu, 0, MAVLINK_MSG_ID_FUSED_IMU_LEN);
    memcpy(fused_imu, _MAV_PAYLOAD(msg), len);
#endif
}

