#pragma once
// MESSAGE RANGE_TO_NODE PACKING

#define MAVLINK_MSG_ID_RANGE_TO_NODE 150

MAVPACKED(
typedef struct __mavlink_range_to_node_t {
 uint32_t time_boot_ms; /*< Timestamp (milliseconds since system boot)*/
 float range; /*<  range between nodes in (meters)*/
 uint8_t my_id; /*<  ID of the sending node */
 uint8_t tgt_id; /*<  ID of the receiving node */
}) mavlink_range_to_node_t;

#define MAVLINK_MSG_ID_RANGE_TO_NODE_LEN 10
#define MAVLINK_MSG_ID_RANGE_TO_NODE_MIN_LEN 10
#define MAVLINK_MSG_ID_150_LEN 10
#define MAVLINK_MSG_ID_150_MIN_LEN 10

#define MAVLINK_MSG_ID_RANGE_TO_NODE_CRC 2
#define MAVLINK_MSG_ID_150_CRC 2



#if MAVLINK_COMMAND_24BIT
#define MAVLINK_MESSAGE_INFO_RANGE_TO_NODE { \
    150, \
    "RANGE_TO_NODE", \
    4, \
    {  { "time_boot_ms", NULL, MAVLINK_TYPE_UINT32_T, 0, 0, offsetof(mavlink_range_to_node_t, time_boot_ms) }, \
         { "range", NULL, MAVLINK_TYPE_FLOAT, 0, 4, offsetof(mavlink_range_to_node_t, range) }, \
         { "my_id", NULL, MAVLINK_TYPE_UINT8_T, 0, 8, offsetof(mavlink_range_to_node_t, my_id) }, \
         { "tgt_id", NULL, MAVLINK_TYPE_UINT8_T, 0, 9, offsetof(mavlink_range_to_node_t, tgt_id) }, \
         } \
}
#else
#define MAVLINK_MESSAGE_INFO_RANGE_TO_NODE { \
    "RANGE_TO_NODE", \
    4, \
    {  { "time_boot_ms", NULL, MAVLINK_TYPE_UINT32_T, 0, 0, offsetof(mavlink_range_to_node_t, time_boot_ms) }, \
         { "range", NULL, MAVLINK_TYPE_FLOAT, 0, 4, offsetof(mavlink_range_to_node_t, range) }, \
         { "my_id", NULL, MAVLINK_TYPE_UINT8_T, 0, 8, offsetof(mavlink_range_to_node_t, my_id) }, \
         { "tgt_id", NULL, MAVLINK_TYPE_UINT8_T, 0, 9, offsetof(mavlink_range_to_node_t, tgt_id) }, \
         } \
}
#endif

/**
 * @brief Pack a range_to_node message
 * @param system_id ID of this system
 * @param component_id ID of this component (e.g. 200 for IMU)
 * @param msg The MAVLink message to compress the data into
 *
 * @param time_boot_ms Timestamp (milliseconds since system boot)
 * @param my_id  ID of the sending node 
 * @param tgt_id  ID of the receiving node 
 * @param range  range between nodes in (meters)
 * @return length of the message in bytes (excluding serial stream start sign)
 */
static inline uint16_t mavlink_msg_range_to_node_pack(uint8_t system_id, uint8_t component_id, mavlink_message_t* msg,
                               uint32_t time_boot_ms, uint8_t my_id, uint8_t tgt_id, float range)
{
#if MAVLINK_NEED_BYTE_SWAP || !MAVLINK_ALIGNED_FIELDS
    char buf[MAVLINK_MSG_ID_RANGE_TO_NODE_LEN];
    _mav_put_uint32_t(buf, 0, time_boot_ms);
    _mav_put_float(buf, 4, range);
    _mav_put_uint8_t(buf, 8, my_id);
    _mav_put_uint8_t(buf, 9, tgt_id);

        memcpy(_MAV_PAYLOAD_NON_CONST(msg), buf, MAVLINK_MSG_ID_RANGE_TO_NODE_LEN);
#else
    mavlink_range_to_node_t packet;
    packet.time_boot_ms = time_boot_ms;
    packet.range = range;
    packet.my_id = my_id;
    packet.tgt_id = tgt_id;

        memcpy(_MAV_PAYLOAD_NON_CONST(msg), &packet, MAVLINK_MSG_ID_RANGE_TO_NODE_LEN);
#endif

    msg->msgid = MAVLINK_MSG_ID_RANGE_TO_NODE;
    return mavlink_finalize_message(msg, system_id, component_id, MAVLINK_MSG_ID_RANGE_TO_NODE_MIN_LEN, MAVLINK_MSG_ID_RANGE_TO_NODE_LEN, MAVLINK_MSG_ID_RANGE_TO_NODE_CRC);
}

/**
 * @brief Pack a range_to_node message on a channel
 * @param system_id ID of this system
 * @param component_id ID of this component (e.g. 200 for IMU)
 * @param chan The MAVLink channel this message will be sent over
 * @param msg The MAVLink message to compress the data into
 * @param time_boot_ms Timestamp (milliseconds since system boot)
 * @param my_id  ID of the sending node 
 * @param tgt_id  ID of the receiving node 
 * @param range  range between nodes in (meters)
 * @return length of the message in bytes (excluding serial stream start sign)
 */
static inline uint16_t mavlink_msg_range_to_node_pack_chan(uint8_t system_id, uint8_t component_id, uint8_t chan,
                               mavlink_message_t* msg,
                                   uint32_t time_boot_ms,uint8_t my_id,uint8_t tgt_id,float range)
{
#if MAVLINK_NEED_BYTE_SWAP || !MAVLINK_ALIGNED_FIELDS
    char buf[MAVLINK_MSG_ID_RANGE_TO_NODE_LEN];
    _mav_put_uint32_t(buf, 0, time_boot_ms);
    _mav_put_float(buf, 4, range);
    _mav_put_uint8_t(buf, 8, my_id);
    _mav_put_uint8_t(buf, 9, tgt_id);

        memcpy(_MAV_PAYLOAD_NON_CONST(msg), buf, MAVLINK_MSG_ID_RANGE_TO_NODE_LEN);
#else
    mavlink_range_to_node_t packet;
    packet.time_boot_ms = time_boot_ms;
    packet.range = range;
    packet.my_id = my_id;
    packet.tgt_id = tgt_id;

        memcpy(_MAV_PAYLOAD_NON_CONST(msg), &packet, MAVLINK_MSG_ID_RANGE_TO_NODE_LEN);
#endif

    msg->msgid = MAVLINK_MSG_ID_RANGE_TO_NODE;
    return mavlink_finalize_message_chan(msg, system_id, component_id, chan, MAVLINK_MSG_ID_RANGE_TO_NODE_MIN_LEN, MAVLINK_MSG_ID_RANGE_TO_NODE_LEN, MAVLINK_MSG_ID_RANGE_TO_NODE_CRC);
}

/**
 * @brief Encode a range_to_node struct
 *
 * @param system_id ID of this system
 * @param component_id ID of this component (e.g. 200 for IMU)
 * @param msg The MAVLink message to compress the data into
 * @param range_to_node C-struct to read the message contents from
 */
static inline uint16_t mavlink_msg_range_to_node_encode(uint8_t system_id, uint8_t component_id, mavlink_message_t* msg, const mavlink_range_to_node_t* range_to_node)
{
    return mavlink_msg_range_to_node_pack(system_id, component_id, msg, range_to_node->time_boot_ms, range_to_node->my_id, range_to_node->tgt_id, range_to_node->range);
}

/**
 * @brief Encode a range_to_node struct on a channel
 *
 * @param system_id ID of this system
 * @param component_id ID of this component (e.g. 200 for IMU)
 * @param chan The MAVLink channel this message will be sent over
 * @param msg The MAVLink message to compress the data into
 * @param range_to_node C-struct to read the message contents from
 */
static inline uint16_t mavlink_msg_range_to_node_encode_chan(uint8_t system_id, uint8_t component_id, uint8_t chan, mavlink_message_t* msg, const mavlink_range_to_node_t* range_to_node)
{
    return mavlink_msg_range_to_node_pack_chan(system_id, component_id, chan, msg, range_to_node->time_boot_ms, range_to_node->my_id, range_to_node->tgt_id, range_to_node->range);
}

/**
 * @brief Send a range_to_node message
 * @param chan MAVLink channel to send the message
 *
 * @param time_boot_ms Timestamp (milliseconds since system boot)
 * @param my_id  ID of the sending node 
 * @param tgt_id  ID of the receiving node 
 * @param range  range between nodes in (meters)
 */
#ifdef MAVLINK_USE_CONVENIENCE_FUNCTIONS

static inline void mavlink_msg_range_to_node_send(mavlink_channel_t chan, uint32_t time_boot_ms, uint8_t my_id, uint8_t tgt_id, float range)
{
#if MAVLINK_NEED_BYTE_SWAP || !MAVLINK_ALIGNED_FIELDS
    char buf[MAVLINK_MSG_ID_RANGE_TO_NODE_LEN];
    _mav_put_uint32_t(buf, 0, time_boot_ms);
    _mav_put_float(buf, 4, range);
    _mav_put_uint8_t(buf, 8, my_id);
    _mav_put_uint8_t(buf, 9, tgt_id);

    _mav_finalize_message_chan_send(chan, MAVLINK_MSG_ID_RANGE_TO_NODE, buf, MAVLINK_MSG_ID_RANGE_TO_NODE_MIN_LEN, MAVLINK_MSG_ID_RANGE_TO_NODE_LEN, MAVLINK_MSG_ID_RANGE_TO_NODE_CRC);
#else
    mavlink_range_to_node_t packet;
    packet.time_boot_ms = time_boot_ms;
    packet.range = range;
    packet.my_id = my_id;
    packet.tgt_id = tgt_id;

    _mav_finalize_message_chan_send(chan, MAVLINK_MSG_ID_RANGE_TO_NODE, (const char *)&packet, MAVLINK_MSG_ID_RANGE_TO_NODE_MIN_LEN, MAVLINK_MSG_ID_RANGE_TO_NODE_LEN, MAVLINK_MSG_ID_RANGE_TO_NODE_CRC);
#endif
}

/**
 * @brief Send a range_to_node message
 * @param chan MAVLink channel to send the message
 * @param struct The MAVLink struct to serialize
 */
static inline void mavlink_msg_range_to_node_send_struct(mavlink_channel_t chan, const mavlink_range_to_node_t* range_to_node)
{
#if MAVLINK_NEED_BYTE_SWAP || !MAVLINK_ALIGNED_FIELDS
    mavlink_msg_range_to_node_send(chan, range_to_node->time_boot_ms, range_to_node->my_id, range_to_node->tgt_id, range_to_node->range);
#else
    _mav_finalize_message_chan_send(chan, MAVLINK_MSG_ID_RANGE_TO_NODE, (const char *)range_to_node, MAVLINK_MSG_ID_RANGE_TO_NODE_MIN_LEN, MAVLINK_MSG_ID_RANGE_TO_NODE_LEN, MAVLINK_MSG_ID_RANGE_TO_NODE_CRC);
#endif
}

#if MAVLINK_MSG_ID_RANGE_TO_NODE_LEN <= MAVLINK_MAX_PAYLOAD_LEN
/*
  This varient of _send() can be used to save stack space by re-using
  memory from the receive buffer.  The caller provides a
  mavlink_message_t which is the size of a full mavlink message. This
  is usually the receive buffer for the channel, and allows a reply to an
  incoming message with minimum stack space usage.
 */
static inline void mavlink_msg_range_to_node_send_buf(mavlink_message_t *msgbuf, mavlink_channel_t chan,  uint32_t time_boot_ms, uint8_t my_id, uint8_t tgt_id, float range)
{
#if MAVLINK_NEED_BYTE_SWAP || !MAVLINK_ALIGNED_FIELDS
    char *buf = (char *)msgbuf;
    _mav_put_uint32_t(buf, 0, time_boot_ms);
    _mav_put_float(buf, 4, range);
    _mav_put_uint8_t(buf, 8, my_id);
    _mav_put_uint8_t(buf, 9, tgt_id);

    _mav_finalize_message_chan_send(chan, MAVLINK_MSG_ID_RANGE_TO_NODE, buf, MAVLINK_MSG_ID_RANGE_TO_NODE_MIN_LEN, MAVLINK_MSG_ID_RANGE_TO_NODE_LEN, MAVLINK_MSG_ID_RANGE_TO_NODE_CRC);
#else
    mavlink_range_to_node_t *packet = (mavlink_range_to_node_t *)msgbuf;
    packet->time_boot_ms = time_boot_ms;
    packet->range = range;
    packet->my_id = my_id;
    packet->tgt_id = tgt_id;

    _mav_finalize_message_chan_send(chan, MAVLINK_MSG_ID_RANGE_TO_NODE, (const char *)packet, MAVLINK_MSG_ID_RANGE_TO_NODE_MIN_LEN, MAVLINK_MSG_ID_RANGE_TO_NODE_LEN, MAVLINK_MSG_ID_RANGE_TO_NODE_CRC);
#endif
}
#endif

#endif

// MESSAGE RANGE_TO_NODE UNPACKING


/**
 * @brief Get field time_boot_ms from range_to_node message
 *
 * @return Timestamp (milliseconds since system boot)
 */
static inline uint32_t mavlink_msg_range_to_node_get_time_boot_ms(const mavlink_message_t* msg)
{
    return _MAV_RETURN_uint32_t(msg,  0);
}

/**
 * @brief Get field my_id from range_to_node message
 *
 * @return  ID of the sending node 
 */
static inline uint8_t mavlink_msg_range_to_node_get_my_id(const mavlink_message_t* msg)
{
    return _MAV_RETURN_uint8_t(msg,  8);
}

/**
 * @brief Get field tgt_id from range_to_node message
 *
 * @return  ID of the receiving node 
 */
static inline uint8_t mavlink_msg_range_to_node_get_tgt_id(const mavlink_message_t* msg)
{
    return _MAV_RETURN_uint8_t(msg,  9);
}

/**
 * @brief Get field range from range_to_node message
 *
 * @return  range between nodes in (meters)
 */
static inline float mavlink_msg_range_to_node_get_range(const mavlink_message_t* msg)
{
    return _MAV_RETURN_float(msg,  4);
}

/**
 * @brief Decode a range_to_node message into a struct
 *
 * @param msg The message to decode
 * @param range_to_node C-struct to decode the message contents into
 */
static inline void mavlink_msg_range_to_node_decode(const mavlink_message_t* msg, mavlink_range_to_node_t* range_to_node)
{
#if MAVLINK_NEED_BYTE_SWAP || !MAVLINK_ALIGNED_FIELDS
    range_to_node->time_boot_ms = mavlink_msg_range_to_node_get_time_boot_ms(msg);
    range_to_node->range = mavlink_msg_range_to_node_get_range(msg);
    range_to_node->my_id = mavlink_msg_range_to_node_get_my_id(msg);
    range_to_node->tgt_id = mavlink_msg_range_to_node_get_tgt_id(msg);
#else
        uint8_t len = msg->len < MAVLINK_MSG_ID_RANGE_TO_NODE_LEN? msg->len : MAVLINK_MSG_ID_RANGE_TO_NODE_LEN;
        memset(range_to_node, 0, MAVLINK_MSG_ID_RANGE_TO_NODE_LEN);
    memcpy(range_to_node, _MAV_PAYLOAD(msg), len);
#endif
}

