
#include "mbed.h"
#include "DS1820.h"
Serial pc(SERIAL_TX, SERIAL_RX);
const int MAX_PROBES = 1;
DS1820 probe[1] = {A0};
int main()
{
    int i;
    int devices_found=0;
    
    //pc.attach(&pcRx, pc.RxIrq);
    pc.printf("Started\r\n");

    pc.printf("search_ROM_setup\r\n");
    probe[0].search_ROM_setup();
    pc.printf("search_ROM\r\n");
    while (probe[devices_found].search_ROM() and devices_found<MAX_PROBES-1)
          devices_found++;
    
    // If maximum number of probes are found,
    // bump the counter to include the last array entry
    if (probe[devices_found].ROM[0] != 0xFF)
        devices_found++;
    pc.printf("devices found:%d\r\n", devices_found);


    while(1) {
        probe[0].convert_temperature(DS1820::all_devices);
        for (i=0; i<devices_found; i++) {
          //  pc.printf("Device[%d]: %3.1f \r\n",i, probe[i].temperature('f'));
           float t=probe[i].temperature('f');
           float tc=(t-32)/1.8; //da Farenheit a Celsius
            pc.printf("Device[%d]: %3.1f \r\n",i, t);
             pc.printf("Device[%d]: %3.1f \r\n",i, tc);  
        }
        wait(1); // 1 sec
    }
}
