#include "mbed.h"

DigitalIn botao_SW1(D2); // Define o pino D2 como leitura do botao_SW1
DigitalIn botao_SW2(D7); // Define o pino D7 como leitura do botão_SW2

AnalogIn Shunt(A5); // Define o pino aA5 como leitura da corrente de shunt (usada para detecção de esmagamento)


DigitalOut Enable(D9); // Define o pino D9 como saída do sinal enable
DigitalOut saida_IN1(D10);// Define o pino D10 como saida_IN1
DigitalOut saida_IN2(D8);// Define o pino D8 como saida_IN2

int main () { // Define as variáveis
    bool SW1 = 1;
    bool SW2 = 1;
    bool IN1 = 0;
    bool IN2 = 0;
    float Leitura_Shunt = 0;
    printf("Olá");
    
    while(1) {
        SW1 = botao_SW1; 
        Leitura_Shunt = Shunt;
        if(SW1 == 0) { // caso o botão 1 esteja sendo pressionado, aciona o motor em um sentido
            if(Leitura_Shunt <= 0.1) {
                IN1 = 1;  
                IN2 = 0; // evita o acionamento em dois sentidos ao mesmo tempo
                Enable = 1; // habilita a saída do CI
                saida_IN1 = IN1;
                saida_IN2 = IN2;
                printf("%1.2f", Leitura_Shunt);
                wait(0.01); //espera 0.01 segundos
                }
            if(Leitura_Shunt > 0.1) {//Inverte o sentido do Vidro e espera um segundo
                IN1 = 0;  
                IN2 = 1; // evita o acionamento em dois sentidos ao mesmo tempo
                Enable = 1; // habilita a saída do CI
                saida_IN1 = IN1;
                saida_IN2 = IN2;
                printf("%1.2f", Leitura_Shunt);
                wait(1); //espera 1 segundo
                }
            }
        SW2 = botao_SW2;
        if(SW2  == 0) { // caso o botão 2 esteja sendo pressionado, aciona o motor no sentido contrário
            if(Leitura_Shunt <= 0.25) {
                IN1 = 0; // evita o acionamento em dois sentidos ao mesmo tempo
                IN2 = 1;
                Enable = 1; // habilita a saída do CI
                saida_IN1 = IN1;
                saida_IN2 = IN2;
                printf("%1.2f", Leitura_Shunt);
                wait(0.01); //espera 0.01 segundos
            }
            if(Leitura_Shunt > 0.25) { //Inverte o sentido do Vidro e espera um segundo
                IN1 = 1;  
                IN2 = 0; // evita o acionamento em dois sentidos ao mesmo tempo
                Enable = 1; // habilita a saída do CI
                saida_IN1 = IN1;
                saida_IN2 = IN2;
                printf("%1.2f", Leitura_Shunt);
                wait(1); //espera 1 segundo
                }
                    
        }
            else{ //caso nenhum botão esteja pressionado, o motor não é acionado
                IN1 = 0;
                IN2 = 0;
                Enable = 0; // desabilita a saída do CI
                saida_IN1 = IN1;
                saida_IN2 = IN2;
            }
            wait(0.01);
        }
}


