#include<stdio.h>
#include<AnalogIn.h>    //Library for using analog inputs
#include<mbed.h>        //Regular mbed library 
#include<DHT.h>         //Library for Humidity/temperature sensor, the only one that works.

AnalogIn mic1(A0);
AnalogIn mic2(A1);
AnalogIn mic3(A2);
DHT sensor(A3, DHT11);

const int n = 100;
int m1[n];
int m2[n];
int m3[n];
int data;

int main(){
    for(int i = 0; i<n; ++i){
        float f1 = 10*mic1.read();
        float f2 = 10*mic2.read();
        float f3 = 10*mic3.read();
        printf("Mic 1: ");
        printf("%10.6f",f1);
        printf("\t Mic 2:");
        printf("%10.6f", f2);
        printf("\t Mic 3:");
        printf("%10.6f", f3);
        printf("\n");
        //wait(0.1);
        m1[i]=f1;
        m2[i]=f2;
        m2[i]=f3;
        
        data = sensor.readData();
        if (data == 0){
             printf("Temp: %4.2f C",sensor.ReadTemperature(CELCIUS));
             printf("Hum: %4.2f",sensor.ReadHumidity());
        }
        printf("\n");
        
    }
}