#include "mbed.h"

//Definerer BusIn
BusIn numpad(PA_10, PB_3, PB_5,PB_4, PB_10, PA_8, PA_9, PB_6);

//Funksjonsprototyper
int returnValueKeyPressed(int, int);
 
int main() {
  numpad.mode(PullUp);
  int sum;
  int tall1, tall2;
  while(1) {
  sum = 0;
  printf("Press first number: ");
  
  //Så lenge ingen av knappene trykkes
  while(returnValueKeyPressed(numpad.read(), 1)==0){};
  
  //Bruker funksjonen returnValueKeyPressed som gjør om BusIn signal til korrensponderende tall
  tall1 = returnValueKeyPressed(numpad.read(), 1);
  printf(" %d\r\n", returnValueKeyPressed(numpad.read(), 1));
  
  //Så lenge en eller fler av knappene ikke er sluppet
  while(returnValueKeyPressed(numpad.read(), 1)!=0){};
  printf("Press second number: ");
  
   //Så lenge ingen av knappene trykkes
  while(returnValueKeyPressed(numpad.read(), 1)==0){};
  
  tall2 = returnValueKeyPressed(numpad.read(), 1);
  printf(" %d\r\n", returnValueKeyPressed(numpad.read(), 1)); 
   
  //Så lenge en eller fler av knappene ikke er sluppet
  while(returnValueKeyPressed(numpad.read(), 1)!=0){};
  sum = tall1 + tall2;
  printf("The sum of the two numbers is %d\r\n", sum);
  wait(1);
  }
  
}


//Funksjon for å konvertere inngangsbit til tilhørende verdi på et 8-knapper numpad, kan utvides til 12-knapper 
int returnValueKeyPressed(int key, int inv = 0){
    int opKey;
    
    //Betingelse som sjekker om det er snakk om inverterte innganger
    if(inv){
    opKey = ~key & 0xFF; //Inverterer Key og masker for 8-bit, kan forandres til flere bit
    }else{
    opKey = key & 0xFF;  //Masker for 8-bit, kan forandres til flere bit   
    } 
    
    switch(opKey){
        case 1: // 0000 0001
            return 1;
        case 2: // 0000 0010
            return 2;
        case 4: // 0000 0100
            return 3;
        case 8: // 0000 1000
            return 4; 
        case 16: // 0001 0000
            return 5;
        case 32: // 0010 0000
            return 6;      
        case 64: // 0100 0000
            return 7;
        case 128: // 1000 0000
            return 8;
        default:
            return 0;       
    }
}