#include "mbed.h"
 
//Definerer inn/utganger 
DigitalOut led(LED1);
InterruptIn button(USER_BUTTON);
Timeout tOut;


//Funksjonsprototyper
void btnClick(void);
void enableIRQ(void);
void toggleLed(void);


int main() {
   //Setter pull-up og fester en funksjon til fall på button.
   button.mode(PullUp);
   button.fall(&btnClick);
    
  
    
    while(1) {

        wait(0.2); // 200 ms
    }
}

//Toggler Led fra av/på -> på/av
void toggleLed(){ 
    led = !led; //Toggler LED
}


//Skrur på interrupts
void enableIRQ(){
    button.enable_irq();    
}


//Kjører når knappen blir trykket
void btnClick(){
    button.disable_irq();
    tOut.attach_us(enableIRQ, 10);
    toggleLed();
    }