#include "mbed.h"


Serial Bluetooth(PB_6, PA_10);
DigitalIn button(USER_BUTTON); //Definerer bruker input på NUCLEO
PwmOut led(PC_7); //Definerer LED objekt



void toggleLed(int *ledOn){
    *ledOn = !*ledOn;
 }
 
 
int main() {
  float periodeTid=0.01f;
  int ledOn = 0;
  int prosent;
  float periodeTid_ms=(int)periodeTid*1000;
  led.period(periodeTid);
  Bluetooth.baud(9600);
  
  while(1) {  
    while(Bluetooth.readable()){    //Hvis vi kan lese av informasjon fra Bluetoothen
        if(Bluetooth.getc()=='T'){
            toggleLed(&ledOn);
        }
        if(ledOn){
            led.pulsewidth(periodeTid*Bluetooth.getc()/100);   
        }else{
            led = 0;    
        }
    }
  }
}
 