#include "mbed.h"
#include "rtos.h"
#include "sx127x_lora.h"
#include "comm.h"
#include "fun.h"
#include "application.h"

unsigned long readCurrentTimestamp( void ) {
    time_t seconds = time(NULL);
    return seconds;
}

void setCurrentTimeDate( unsigned long ts ) {
    set_time(ts);
}


void printStr(unsigned int destination, unsigned char * str, unsigned int len) {
    unsigned int i;
    
    #ifdef LORA_TARGET     
    if(destination==LORA_TARGET) {
        kom.write_reg(0x22,len);   
    } 
    #endif
    
    for(i=0;i<len;i++) {
        switch(destination) {            
            #ifdef PC_TARGET   
            case PC_TARGET:
                pc_mutex.lock();
                pc.putc(str[i]);
                pc_mutex.unlock();
                break;    
            #endif      
            #ifdef FIBER_OPTIC_TARGET     
            case FIBER_OPTIC_TARGET:
                fiberOptic_mutex.lock();    
                fiberOptic.putc(str[i]);
                fiberOptic_mutex.unlock();            
                break;   
            #endif
            #ifdef LORA_TARGET            
            case LORA_TARGET:                 
                kom.tx_buf[i] = str[i];          
                break;
            #endif
            #ifdef GSM_TARGET
            case GSM_TARGET:
                //gsm_mutex.lock();                
                //gsm_mutex.unlock();             
                break;
            #endif
            default:
                break;   
        }
    } 
    #ifdef LORA_TARGET   
    if(destination==LORA_TARGET)  
        Lora.start_tx(len);        
        while(Lora.service() != SERVICE_TX_DONE);   
        Lora.start_rx();  
    #endif
}