#ifndef __COMM_H__
#define __COMM_H__

// Uart's targets for output payload
#define PC_TARGET               0
#define FIBER_OPTIC_TARGET      1
#define LORA_TARGET             2
//#define GSM_TARGET              3

// Structures
typedef struct {
    unsigned char   flg;
    unsigned int    lenght;
    unsigned char   *buf;
} uartBufferStructure;

typedef struct {
   unsigned char   flg; 
    unsigned char  buf[50];
} queueStruct;

extern queueStruct queue[5];
extern uartBufferStructure pcBuffer;
extern uartBufferStructure fiberOpticBuffer;
extern uartBufferStructure loraBuffer;

extern Mutex pc_mutex; 
extern Mutex fiberOptic_mutex;

extern Mutex lora_mutex;

extern SX127x kom;
extern SX127x_lora Lora;

void pc_thread(void const *argument);
void pc_handle(void);      
void fiberOptic_thread(void const *argument);
void fiberOptic_handle(void); 
void lora_thread(void const *argument);
void printBuffer(uartBufferStructure buffer);

void lora_rx_thread(void const *argument);


#endif