#ifndef __APPLICATION_H__
#define __APPLICATION_H__

// Application
#define APP                     "WIND Concentrator"
#define SOURCE_ID               0
#define DESTINATION_ID          0

#define PC_INTERVAL             1
#define FIBER_OPTIC_INTERVAL    1
#define LORA_INTERVAL           1

// Uart's
#define PC_RX_BUFFER            500
#define FIBER_OPTIC_RX_BUFFER   500
#define LORA_RX_BUFFER          500

// Uart's bauds
#define PC_BAUD                 115200
#define FIBER_OPTIC_BAUD        57600

// Enable modules
#define PC_ENABLE               1
#define FIBER_OPTIC_ENABLE      0
#define LORA_ENABLE             1

// Protocol
#define pSTX                    0x02
#define pETX                    0x03
#define pBEL                    0x07
#define pACK                    0x06

enum systemEnum{
    Clear   = 0,
    Set     = 0,
    SetLed  = 0,
    ClearLed= 1
};

enum communications {
    lora_com,fiberOptic_com,pc_com
};

// System settings structure
typedef struct {
    unsigned char last_ppe_id[3];      // Last transmited PPE ID
    unsigned char last_ppe_id_fo;
    unsigned long TXCharCounter[3];    // Transmited chars -> PC,FIBER_OPTIC,LoRa 
    unsigned long RXCharCounter[3];    // Received chars -> PC,FIBER_OPTIC,LoRa 
    unsigned long errorCounter[3];  
    unsigned char fiberOpticEnable;
}systemStructure;

extern systemStructure sys;

extern Timer txFiberOpticTmr;
extern Timer rxFiberOpticTmr;
extern Timer pcTmr;

enum counters{
    PC,FO,LO,GS  
};

extern DigitalOut LEDG;          // Testni Led Green
extern DigitalOut LEDR;          // Testni Led Red

extern DigitalOut RX_LED;
extern DigitalOut TX_LED;

//extern DigitalOut FIBER_OPTIC_TX;
extern DigitalOut FIBER_OPTIC_TX_PWR;
extern DigitalOut FIBER_OPTIC_RX_PWR;

// Turn On fiber optic
extern DigitalIn OperationMode;

extern RawSerial pc;            // USB serial port
extern RawSerial fiberOptic;    // Fiber Optic serial port
extern RawSerial lora;          // GSM serial port

#endif