#include "mbed.h"
#include "rtos.h"
#include "stdlib.h"
#include "sx127x_lora.h"
#include "comm.h"
#include "fun.h"
#include "application.h"

// Lora TX/RX indication
DigitalOut RX_LED(LED1);             // LED blink on receive - LoRa
DigitalOut TX_LED(LED2);             // LED blink on transmit - LoRa

// Serial ports
RawSerial pc(USBTX,USBRX);          // USB serial port
RawSerial fiberOptic(PTE0,PTE1);    // Fiber Optic serial port

// Lora communication
SX127x kom(PTD2, PTD3, PTD1, PTD0, PTD5, PTA13, PTC9);
SX127x_lora Lora(kom);

// Enable/Disable fiber optic mode
DigitalIn OperationMode(PTE20);

// Enable disable tx pin on fiber optic
//DigitalOut FIBER_OPTIC_TX(PTE0);
DigitalOut FIBER_OPTIC_TX_PWR(PTB9);
DigitalOut FIBER_OPTIC_RX_PWR(PTB8);

systemStructure sys;            // System structure

int main(void) {
     
    Thread pcThread(pc_thread);
    Thread loraThread(lora_thread);   
    //Thread fiberOpticThread(fiberOptic_thread);
    Thread loraRXThread(lora_rx_thread);
    
    while(true) {
        if(loraBuffer.flg) {
        } 
        TX_LED = ClearLed;
        RX_LED = ClearLed;  
        wait_ms(1);
    }
}
