#include "mbed.h"
#include "stdlib.h"
#include "rtos.h"
#include "sx127x_lora.h"
#include "comm.h"
#include "fun.h"
#include "application.h"

queueStruct queue[5];
uartBufferStructure pcBuffer;
uartBufferStructure fiberOpticBuffer;
uartBufferStructure loraBuffer;

Mutex pc_mutex;                 // Mutex for RTOS system - USB serial port
Mutex fiberOptic_mutex;         // Mutex for RTOS system - Fiber optic port
Mutex lora_mutex;

Timer txFiberOpticTmr;
Timer rxFiberOpticTmr;
Timer pcTmr;

void pc_thread(void const *argument) {
    pcBuffer.buf = (unsigned char *)malloc(sizeof(char)*PC_RX_BUFFER);
    pc.baud(PC_BAUD);
    pc.attach(&pc_handle); 
    pc_mutex.lock();
    pc.printf("\n#: Application %s \n#: Source ID: %d \n#: Destination ID: %d \n#: PC thread Started with BAUD(%d)", APP,SOURCE_ID,DESTINATION_ID,PC_BAUD);
    pc_mutex.unlock();   
    while(true){ 
        wait_ms(1);
    }
}

void lora_thread(void const *argument){
    Timer txLoraTmr;

    // Initialize lora
    kom.init();
    Lora.enable();
    Lora.setSf(8);
    Lora.setBw(250);
    
    kom.set_frf_MHz(868); 
    Lora.start_rx(); 
     
    pc_mutex.lock();
    pc.printf("\n#: LoRa thread started");
    pc_mutex.unlock();
    loraBuffer.buf = (unsigned char *)malloc(sizeof(char)*LORA_RX_BUFFER); 
    
    txLoraTmr.stop();    
    txLoraTmr.reset();    
    txLoraTmr.start();
    
    int step = 0;
    while(true){ 
        // PING rutine   
        
        if(txLoraTmr.read_ms()>=500 && step==0) {  
            unsigned char tmpStr[] = {pSTX, sys.last_ppe_id[0], 0, SOURCE_ID, 0, 1, 0, 1, pBEL, pETX};            
            //lora_mutex.lock();  
            printStr(LORA_TARGET,tmpStr,sizeof(tmpStr));
            //lora_mutex.unlock();                        
            sys.last_ppe_id[0] = sys.last_ppe_id[0] + 1;   
            txLoraTmr.reset();           
            step++;
            
            pc_mutex.lock();
            pc.printf("\n<:");            
            pc_mutex.unlock();
            TX_LED = SetLed;
        }
        if(txLoraTmr.read_ms()>=500 && step==1) { 
            unsigned char tmpStr[] = {pSTX, sys.last_ppe_id[1], 0, SOURCE_ID, 0, 2, 0, 1, pBEL, pETX};           
            //lora_mutex.lock();  
            printStr(LORA_TARGET,tmpStr,sizeof(tmpStr));  
            //lora_mutex.unlock();                                              
            sys.last_ppe_id[1] = sys.last_ppe_id[1] + 1;              
            txLoraTmr.reset();             
            step++;
            TX_LED = SetLed;          
        } 
        if(txLoraTmr.read_ms()>=500 && step==2) {      
            unsigned char tmpStr[] = {pSTX, sys.last_ppe_id[2], 0, SOURCE_ID, 0, 3, 0, 1, pBEL, pETX};           
            //lora_mutex.lock();  
            printStr(LORA_TARGET,tmpStr,sizeof(tmpStr));   
            //lora_mutex.unlock();                                             
            sys.last_ppe_id[2] = sys.last_ppe_id[2] + 1;              
            txLoraTmr.reset();             
            step=0;
            TX_LED = SetLed;             
        }        
        if(Lora.service() == SERVICE_READ_FIFO) {
            unsigned int pyloadSize = kom.read_reg(REG_LR_RXNBBYTES);
            float rssi = Lora.get_pkt_rssi();
            unsigned int i;       
            for(i=0;i<pyloadSize;i++){              
                loraBuffer.buf[i] = kom.rx_buf[i];
                loraBuffer.lenght = loraBuffer.lenght++;
            }  
            pc_mutex.lock();
            pc.printf("[%d,%2.1f]",loraBuffer.buf[3],rssi);
            pc_mutex.unlock();
        }     
        
    }
}

void fiberOptic_thread(void const *argument){
    OperationMode.mode(PullUp);   
    fiberOpticBuffer.buf = (unsigned char *)malloc(sizeof(char)*FIBER_OPTIC_RX_BUFFER); 
    fiberOptic.baud(FIBER_OPTIC_BAUD);
    fiberOptic.attach(&fiberOptic_handle);  
    if(!OperationMode.read()) { 
        pc_mutex.lock();
        pc.printf("\n#: Fiber Optic thread started with BAUD(%d)",FIBER_OPTIC_BAUD);
        pc_mutex.unlock();
        //FIBER_OPTIC_TX = 1;   
        sys.fiberOpticEnable = true;
        FIBER_OPTIC_TX_PWR = 0;
        FIBER_OPTIC_RX_PWR = 0;
        
        txFiberOpticTmr.start();     
          
        while(true) {        
            // PING rutine        
            if(txFiberOpticTmr.read()>FIBER_OPTIC_INTERVAL) {
                if(sys.last_ppe_id_fo==0)
                    sys.last_ppe_id_fo = 1;
                pc_mutex.lock();
                pc.printf("\n>: PPE_ID_FO: %d, NODE: 1", sys.last_ppe_id_fo);
                pc_mutex.unlock();     
                fiberOptic_mutex.lock();
                fiberOptic.printf("%c%c%c%c%c%c%c%c%c%c",pSTX,sys.last_ppe_id_fo,0,SOURCE_ID,0,1,0,1,pACK,pETX);
                fiberOptic_mutex.unlock();           
                sys.last_ppe_id_fo = sys.last_ppe_id_fo + 1;    
                txFiberOpticTmr.reset();
            }   
            if(fiberOpticBuffer.flg) {
                if(fiberOpticBuffer.lenght >= 5){
                    pc_mutex.lock();
                    pc.printf("\n>: Received shitty payload");
                    pc_mutex.unlock(); 
                    fiberOpticBuffer.flg = false;
                    fiberOpticBuffer.lenght = false;
                }
                if(fiberOpticBuffer.buf[0]==pSTX && fiberOpticBuffer.buf[fiberOpticBuffer.lenght-1]==pETX ) {
                    pc_mutex.lock();
                    pc.printf("\n>: Received shitty payload");
                    pc_mutex.unlock(); 
                    fiberOpticBuffer.flg = false;
                    fiberOpticBuffer.lenght = false;
                }
                
            }
        }
    }
    else {    
        sys.fiberOpticEnable = false;    
        pc_mutex.lock();
        pc.printf("\n#: Fiber Optic thread disabled!\n");
        pc_mutex.unlock();
        //FIBER_OPTIC_TX = 0; 
        FIBER_OPTIC_TX_PWR = 1;
        FIBER_OPTIC_RX_PWR = 1;
    }
}

void pc_handle(void) {
    //LEDG = SetLed;
    pc_mutex.lock();
    unsigned char c = pc.getc();  
    pc_mutex.unlock();
    sys.RXCharCounter[pc_com] = sys.RXCharCounter[pc_com]+1;
    if(pcBuffer.lenght < PC_RX_BUFFER) {
        pcBuffer.buf[pcBuffer.lenght]   = c;
        pcBuffer.lenght               = pcBuffer.lenght + 1;
        pcBuffer.flg                  = true;
    }
}

void fiberOptic_handle(void) {  
    //LEDB = SetLed;
    fiberOptic_mutex.lock();
    unsigned char c = fiberOptic.getc();  
    fiberOptic_mutex.unlock();    
                    
    if(fiberOpticBuffer.lenght < FIBER_OPTIC_RX_BUFFER) {
        fiberOpticBuffer.buf[fiberOpticBuffer.lenght] = c;
        fiberOpticBuffer.lenght               = fiberOpticBuffer.lenght + 1;
        fiberOpticBuffer.flg                  = true;
    }
}

void printBuffer(uartBufferStructure buffer) {
    if(buffer.flg) {
        unsigned int i;
        pc_mutex.lock();
        pc.printf("\n<: ");
        pc_mutex.unlock(); 
        for(i=0;i<buffer.lenght-1;i++){
            pc_mutex.lock();
            pc.printf("%02x ",buffer.buf[i]);
            pc_mutex.unlock();
        }
    }
       
}



void lora_rx_thread(void const *argument) {
    /*
    unsigned int i;
    while(true) {        
        lora_mutex.lock();        
        if(Lora.service() == SERVICE_READ_FIFO) {
        lora_mutex.unlock();  
         
            pc_mutex.lock();
            pc.printf(".");
            pc_mutex.unlock();  
            unsigned int pyloadSize = kom.read_reg(REG_LR_RXNBBYTES);
            float rssi = Lora.get_pkt_rssi();
            
            while(Lora.service() == SERVICE_READ_FIFO) { 
                loraBuffer.buf[i] = kom.rx_buf[i];
                loraBuffer.lenght = loraBuffer.lenght++;
            }
            
                pc_mutex.lock();
                pc.printf(".");
                pc_mutex.unlock();  
            while(Lora.service() == SERVICE_READ_FIFO) { 
                loraBuffer.buf[i] = kom.rx_buf[i];
                loraBuffer.lenght = loraBuffer.lenght++;
                pc_mutex.lock();
                pc.printf("Tukaj");
                pc_mutex.unlock();  
           // }
        }
    }
    */
}