#include "mbed.h"
#include "datos.h"

#define longitudTrama 500

Timer timer;
float resultado;
int tiempo;

struct estructuraMedidas {
    float vrms;
    float irms;
    float potenciaActiva;
    float potenciaReactiva;
    float potenciaAparente;
    float energiaConsumida;
    float factorDePotencia;
};

float calcularRMS(int16_t *datos, int longitud);

void calcularDatos(int16_t *datosV, int16_t *datosI, int longitud, estructuraMedidas *medidas);

int main()
{

    timer.reset();
    timer.start();
    resultado=calcularRMS(datos, longitudTrama);
    timer.stop();
    printf("****El valor Vrms es %f calculado en %d us ****\n",resultado,timer.read_us());

    estructuraMedidas medidas;
    medidas.energiaConsumida=0;

    timer.reset();
    timer.start();
    calcularDatos(datosV,datosI,longitudTrama,&medidas);
    timer.stop();
    printf("**** Datos calculados en %d us ****\n",timer.read_us());
    printf("**** El valor Vrms es %f ****\n",medidas.vrms);
    printf("**** El valor Irms es %f ****\n",medidas.irms);
    printf("**** La potencia activa es %f ****\n",medidas.potenciaActiva);
    printf("**** La potencia reactiva es %f ****\n",medidas.potenciaReactiva);
    printf("**** La potencia aparente es %f ****\n",medidas.potenciaAparente);
    printf("**** La energia consumida es %f ****\n",medidas.energiaConsumida);
    printf("**** El factor de potencia es es %f ****\n",medidas.factorDePotencia);

}

float calcularRMS(int16_t *datos, int longitud)
{

    float cont = 6.6/65536.0*6.6/65536.0;
    int16_t dato=0.0;
    float dato_1=0.0;
    int32_t producto=0.0;
    int64_t sumatorio=0.0;

    for (int n=0; n<longitud; n++) {
        dato=datos[n];
        producto=dato*dato;
        sumatorio+= producto;
    }
    dato_1=cont*sumatorio/longitud;

    return sqrt(dato_1);
}

void calcularDatos(int16_t *datosV, int16_t *datosI, int longitud, estructuraMedidas *medidas)
{
    float cont =6.6/65536.0*6.6/65536.0;
    int16_t dato_v=0.0;
    int32_t mult_v=0.0;
    int64_t sumatorio_v=0.0;
    float emaitza_v=0.0;
    int32_t dato_p=0.0;
    int64_t sumatorio_p=0.0;
    float emaitza_p=0.0;
    int16_t dato_i=0.0;
    int32_t mult_i=0.0;
    int64_t sumatorio_i=0.0;
    float emaitza_i=0.0;

    for (int n=0; n<longitud; n++) {
        //Cálculo voltaje
        dato_v = datosV[n];
        mult_v = dato_v*dato_v;
        sumatorio_v+=mult_v;
        //Cálculo intensidad
        dato_i = datosI[n];
        mult_i = dato_i*dato_i;
        sumatorio_i+=mult_i;
        //Cálculo de potencia
        dato_p=dato_v*dato_i;
        sumatorio_p+=dato_p;
    }
    //misma estructura que arriba
    emaitza_v=sumatorio_v*cont/longitud;
    emaitza_i=sumatorio_i*cont/longitud;
    emaitza_p=sumatorio_p*cont/longitud;

    //mandar dato a medidas
    medidas->vrms=sqrt(emaitza_v);
    medidas->irms=sqrt(emaitza_i);
    medidas->potenciaActiva=emaitza_p;
    medidas->potenciaAparente=medidas->vrms*medidas->irms;
    medidas->potenciaReactiva=sqrt(-(medidas->potenciaActiva*medidas->potenciaActiva)+(medidas->potenciaAparente*medidas->potenciaAparente));

    //medidas->energiaConsumida Esta nos dijiste que habia que calcular el tiempo y que no hicieramos
    medidas->factorDePotencia=medidas->potenciaActiva/medidas->potenciaAparente;
}

