#include "mbed.h"
#include "math.h"
#include "Adafruit_SSD1306.h"

//#include "hcsr04.h"
class I2CPreInit : public I2C
{
public:
    I2CPreInit(PinName sda, PinName scl) : I2C(sda, scl)
    {
        frequency(100000);
        start();
    };
};

I2CPreInit gI2C(PB_9,PB_8);

// an SPI sub-class that provides a constructed default

Adafruit_SSD1306_I2c gOled(gI2C,NC,0x78,64,128);
Serial pc(USBTX, USBRX); // tx, rx
Ticker tickerMideDistancia;
Ticker visualTemp;
unsigned distancia=1000;

AnalogIn senal(A0);
DigitalIn final1(D9);
DigitalIn final2(D10);
DigitalOut step(D2);
DigitalOut dir(A4);
DigitalOut enableMotor(D11);
DigitalIn boton_inicial(D3);
DigitalIn boton_emergencia(D7);
DigitalOut dirAMotor(D4);//M121
PwmOut     dirBMotor(D5);//M121
DigitalOut rele(D6);//Rcal
InterruptIn encoderA(A2);

Timer t;
Timer bot;
Timer timerVel;
//Ticker tickerVel;
float velocidad=0;

float temperatura;
int contador=0;
float velocidad_relativa=0.0;
//int target=75; Para el control de velocidad

void encoderAIrq()// contador de vueltas
{
    contador++;
}

enum estados {reset, apagado, motorpalante,atras, estatico, emergencia };
estados estado;

//HCSR04  usensor(D7,D8); //(PinName TrigPin,PinName EchoPin):
void paso(int d)
{
    dir=d;
    step=1;
    wait_us(100);
    step=0;
    wait_us(900);
}
void estadoreset()// estado de seguridad, si el taladro esta situado en un sitio que no sea uno de los 2 finales de carrera, retrocederá hasta el principio dejandolo en el estado de apagado.
{
    if (final1!=1) {
        enableMotor=1;
        paso(0);
    } else if (final1 ==1) {// Una vez pisa el final de carrera 1 habilita un mensaje en pantalla dando el valor de la temperatura del motor  del taladro y la velocidad del mismo en RPM.
        gOled.clearDisplay();
        gOled.printf("La temperatura es de %.4f\n",temperatura);
        gOled.printf("La velocidad en rpm es de %.4f\r\n",velocidad);
        gOled.display();
        gOled.setTextCursor(0,0);
        estado = apagado;
        enableMotor =0;
    }
}
void estadoapagado()// Estado "inicial" en el que pulsando el boton de inicio comenzará su avance para iniciar la perforación.
{
    dirBMotor =0;

    if (boton_inicial==1) {
        enableMotor=1;
        t.reset();
        estado= motorpalante;
    }
}
void estadomotorpalante()// estado que hace funcionar el avance, el motor taladra a la vez que perfora. 
{
    if (boton_emergencia==1 || temperatura>80) {//es el boton de emergencia y de temperatura, en caso de pulsar la seta de emergencia y que la temperatura supere el valor de 80º, se parará automaticamente. 
        estado=emergencia;
    }
    if (boton_inicial==0&&final2==0) {
        paso(1);
        dirBMotor=1;
        rele =1;
    } else if (final2==1) {
       // int tiempo=t.read();
        //pc.printf("La temperatura es de %.4f\n",temperatura);
        gOled.clearDisplay();
        gOled.printf("La temperatura es de %.4f\n",temperatura);
        gOled.printf("La velocidad en rpm es de %f\r\n",velocidad);
        gOled.display();
        gOled.setTextCursor(0,0);

        // pc.printf("El tiempo transcurrido es de %d\n",tiempo);
        //pc.printf("La temperatura es de %.4f\n",temperatura);
        //dirAMotor=0;
        wait(2.0);
        //enableMotor=0;
        //rele=0;
        //if (final2==1) {
        estado=atras;
        //}
        //Print en pantalla con el Oled.
    } else if (final2!=1 && boton_inicial==1 && final1!=1) {
        enableMotor=0;
        rele=0;
        dirBMotor=1;//Esto hay que cambiarlo
        bot.reset();
        estado= estatico;
        
    }
}

void estadoatras()
{
    if (boton_emergencia==1 || temperatura>80) {//es el boton de emergencia y de temperatura, en caso de pulsar la seta de emergencia y que la temperatura supere el valor de 80º, se parará automaticamente. 
        estado=emergencia;
    }
    if (final2!=1 && boton_inicial==1 && final1!=1) {// si se pulsa el boton de inicio, el avance dejara de funcionar pero el motor seguirá funcionando
        enableMotor=0;
        rele=0;
        dirBMotor=1;
        bot.reset();
        estado= estatico;
    } else if (final1 ==1) {//si pisa el final de carrera 1, el motor irá hacia delante dirección final carrera 2 
        estado = motorpalante;
    } else {
        paso(0);//Va hacia la otra dirección
    }

}
void estadoestatico()
{
    if (boton_emergencia==1 || temperatura>80) {//es el boton de emergencia y de temperatura, en caso de pulsar la seta de emergencia y que la temperatura supere el valor de 80º, se parará automaticamente. 
        estado=emergencia;
    }
    if (boton_inicial ==0 ) {
        wait(0.5);
        //estado = apagado;

    } else if (boton_inicial==1 && bot>1) {
        dirBMotor=0;
        estado = reset;
    }
}
void muestraTemp()
{
    pc.printf("La temperatura es de %.4f\n",temperatura);
    gOled.clearDisplay();
    gOled.printf("La temperatura es de %.4f\n",temperatura);
    gOled.printf("%f\r\n",velocidad);
    gOled.display();
    gOled.setTextCursor(0,0);
}

void medir()
{
    float tension=senal.read()*3.3;
    float Rt= 100e3*((3.3-tension)/tension);
    temperatura = (3950/(log(Rt/100e3)+(3950/298)))-273.1;
}

void funcionVel(float tiempo)
{
    velocidad = contador*60/tiempo;//esto es en rpm haciendo *60seg para pasar a min.
    contador = 0;
    velocidad_relativa = temperatura*(96000/80);
    //diferencia_velocidad = velocidad - velocidad_relativa;
    if(velocidad_relativa-velocidad>0) {
        dirBMotor=dirBMotor+0.01;
    } else {
        dirBMotor=dirBMotor-0.01;
    }
}

void estadoemergencia()
{
    rele=0;
    paso(0);
    estado = apagado;
}

int main()
{
    pc.baud(115200);
    gOled.begin();
    gOled.clearDisplay();
    gOled.printf("Hola, bienvenid@ a la simulacion de un equipo de perforacion rotatoria\n");
    gOled.display();
    gOled.setTextCursor(0,0);
    //visualTemp.attach(&muestraTemp,1.0);
    //tickerMideDistancia.attach(&mideDistancia, 0.5);
    estado=reset;
    step=1;
    enableMotor =1;
    pc.printf("Estado cerrada\n");
    t.start();
    bot.start();
    encoderA.rise(&encoderAIrq);  // attach the address of the flip function to the rising edge
    // tickerVel.attach(&funcionVel,0.1);
    dirAMotor=0;
    //dirBMotor=0.5;
    timerVel.start();
    while(1) {
        medir();
        if(timerVel.read()>0.1) {
            funcionVel(timerVel.read());
            timerVel.reset();
            pc.printf("a");
        }
        //distancia=usensor.get_dist_cm();
        switch ( estado ) {

            case reset:
                estadoreset();
                pc.printf("Estado reset\n");
                break;
            case apagado:
                estadoapagado();
                pc.printf("Estado apagado\n");
                break;
            case motorpalante:
                estadomotorpalante();
                pc.printf("Estado alante\n");
                break;
            case atras:
                estadoatras();
                pc.printf("Estado atras\n");
                break;
            case estatico:
                pc.printf("Estado estatico\n");
                estadoestatico();
                break;
            case emergencia:
                pc.printf("Estado emergencia\n");
                estadoemergencia();
                break;
        }
    }
}