#include "mbed.h"
#include "math.h"
#include "TextLCD.h"

#define datoTension 725.331071
#define datoIntensidad 29.4943123
#define constanteTension 1.4709e-06
#define constanteIntensidad 1.423595702690060e-09
#define vectormuestras 100
#define offsetTension 0.50369472
#define offsetIntensidad 0.4152
#define eps 2.220446049250313e-016

void sacardatos();

TextLCD lcd(D8, D9, D2, D3, D4, D5, TextLCD::LCD16x2); // rs, e, d4-d7
Serial pc(USBTX, USBRX); // tx, rx

InterruptIn button(PC_13); 
AnalogIn tension(A2);
AnalogIn intensidad(A1);
    Ticker timerCaptura;
    Ticker timerVisualizacion;

struct Vectores{
    float  vTensionA[vectormuestras];
    float  vTensionB[vectormuestras];
    
    float  vIntensidadA[vectormuestras];
    float  vIntensidadB[vectormuestras];
}vectores;

    float flag=0;
    int bufferActivo=0;
    int contador=0;
    int pulsador=0;

struct Medidas{

    float VRMS;
    float IRMS;
    float P_activa;
    float P_reactiva;
    float P_aparente;
    float Consumo_Pact;
    float Consumo_Preact;
    float FP;
}medidas;



//Captura de valores mediante muestreo
void captura() //función muestreo
{
    
    float medidaTension=tension.read();
    medidaTension=(medidaTension-offsetTension)*datoTension;
    
    float medidaIntensidad=intensidad.read();
    medidaIntensidad=(medidaIntensidad-offsetIntensidad)*datoIntensidad;
    
    if(bufferActivo==1) {
        vectores.vTensionA[contador] = medidaTension;
        vectores.vIntensidadA[contador] = medidaIntensidad;
        
    } else {
        vectores.vTensionB[contador] = medidaTension;
        vectores.vIntensidadB[contador] = medidaIntensidad;
    }
    
    contador++;
    if(contador==vectormuestras){
        contador=0;
        bufferActivo=!bufferActivo;
        flag=1;//buffer lleno
    }
}

//Visualización por pantalla
void visualizacion()//función mostrar
{
    lcd.cls();
    if(pulsador==0){
        lcd.printf("VRMS:\n %f", medidas.VRMS);
    }
    
    else if (pulsador ==1) {
        lcd.printf("IRMS:\n %f", medidas.IRMS);
    }
        
    else if (pulsador ==2) {
        lcd.printf("Pot. activa:\n %f", medidas.P_activa);
    }
    
    else if (pulsador ==3) {
        lcd.printf("Pot. reactiva:\n %f", medidas.P_reactiva);
    }
    
    else if (pulsador ==4) {
        lcd.printf("Pot. aparente:\n %f", medidas.P_aparente);
    }
    
    else if (pulsador ==5) {
        lcd.printf("Consumo Pot. A:\n %f", medidas.Consumo_Pact);
    }
    
    else if (pulsador ==6) {
        lcd.printf("Consumo Pot. R:\n %f", medidas.Consumo_Preact);
    }
    
    else if (pulsador ==7) {
        lcd.printf("Factor de pot.:\n %f", medidas.FP);
    }
    
}

//Cambio de boton
void cambio_boton() 
{ 
    pulsador++; 
    if(pulsador>7) { 
    pulsador=0;
   } 
} 

int main()
{
    float measV=0;
    float measI=0;
    float producto=0;
    float sumatorioV=0;
    float sumatorioI=0;
    float sumatorioPA=0;
    medidas.Consumo_Pact=0.0;
    medidas.Consumo_Preact=0.0;
    

    timerCaptura.attach_us(&captura,200);//Hace que la función muestreo se ejecute cada 200us
    timerVisualizacion.attach(&visualizacion,1.0);//Hace que la función mostrar se ejecute cada segundo
    button.rise(&cambio_boton);//Hace que la función boton se ejecute cada vez que se pulse el botón
    
    while(1) {//bucle para siempre
        if(flag) {//mira si el buffer esta lleno
            flag=0;//Borra la variable buffer lleno
            measV=0;
            measI=0;
            producto=0;
            sumatorioV=0;
            sumatorioI=0;
            sumatorioPA=0;

            for (int b=0; b<vectormuestras; b++) {//VRMS
                if (!bufferActivo) {
                    measV=vectores.vTensionA[b];
                    measI=vectores.vIntensidadA[b];
                } else {
                    measV=vectores.vTensionB[b];
                    measI=vectores.vIntensidadB[b];
                }
                producto=measV*measV;
                sumatorioV+=producto;//calcula el valor VPP
                producto=measI*measI;
                sumatorioI+=producto;
                producto=measV*measI;
                sumatorioPA+=producto;
            }

            medidas.VRMS=sqrt(sumatorioV/vectormuestras);        
            medidas.IRMS=sqrt(sumatorioI/vectormuestras);
            medidas.P_activa=sumatorioPA/vectormuestras;
            medidas.P_aparente=medidas.VRMS*medidas.IRMS;
            medidas.P_reactiva=sqrt((medidas.P_aparente*medidas.P_aparente)-(medidas.P_activa*medidas.P_activa));
            medidas.Consumo_Pact=medidas.Consumo_Pact+medidas.P_activa*20e-3/(3600*1000);
            medidas.Consumo_Preact=medidas.Consumo_Preact+medidas.P_reactiva*20e-3/(3600*1000);
            medidas.FP=medidas.P_activa/(medidas.P_aparente+eps);
            //sacardatos();
        }
        wait(0.001);
    }        
}

void sacardatos(){
    timerCaptura.attach(&captura,100);
    for (int i=0;i<100;i++){
        printf("%f\r\n",vectores.vIntensidadB[i]);
    }
}