#include "mbed.h"

#ifndef MBED_TERMINAL_H
#define MBED_TERMINAL_H

/** Control and display on an ANSI/VT100 Terminal (puTTy or similar...)
 *
 * This allows you to control an ANSI serial terminal
 * Set TX pin and RX . also spesify bauderate if needed different than default 9600
 */ 
class SerialTerminal : public Serial {
public:
    /** Create the Terminal interface 
     * 
     * @param tx Serial transmit
     * @param rx Serial recieve
     * @param baud Serial baudreate speed (default 9600)
     */    
    SerialTerminal(PinName tx, PinName rx, int baudrate=9600);

#if DOXYGEN_ONLY
    /** Write a character to the terminal
     *
     * @param c The character to write to the display
     */
    int putc(int c);

    /** Write a formated string to the terminal
     *
     * @param format A printf-style format string, followed by the
     *               variables to use in formating the string.
     */
    int printf(const char* format, ...);
    
    // also baud etc
#endif

    /** Locate to a screen column and row
     *
     * @param column  The horizontal position from the left, indexed from 0
     * @param row     The vertical position from the top, indexed from 0
     */
    void locate(int column, int row);

    /** Clear the screen and locate to 0,0 */
    void cls();

    /** Set the foreground colour */
    void foreground(int colour);

    /** Set the background colour */
    void background(int colour);
    
    /** Hide Cursor from terminal*/
    void hideCursor();
    
    /** Hide Cursor from terminal*/
    void showCursor();
};

#endif
