#include "mbed.h"

Serial pc(USBTX, USBRX);
DigitalOut led(D7);
DigitalOut gnd(D4);

//0=dot,1=dash, 2=space
//1. The length of a dot is one unit.2. A dash is three units.3. The space between parts of the same letter is one unit.4. The space between letters is three units.5. The space between words is seven units.
int morseArray[37][5]={                
 {0,1,3,3,3},/*A*/  {1,0,0,0,3},/*B*/   {1,0,1,0,3},/*C*/   {0,3,3,3,3},/*D*/
 {0,0,0,0,3},/*E*/  {1,1,0,3,3},/*F*/   {1,1,0,3,3},/*G*/   {0,0,0,0,3},/*H*/
 {0,0,3,3,3},/*I*/  {0,1,1,1,3},/*J*/   {1,0,1,3,3},/*K*/   {0,1,0,0,3},/*L*/
 {1,1,3,3,3},/*M*/  {1,0,3,3,3},/*N*/   {1,1,1,3,3},/*O*/   {0,1,1,0,3},/*P*/
 {1,1,0,1,3},/*Q*/  {0,1,0,3,3},/*R*/   {0,0,0,3,3},/*S*/   {1,3,3,3,3},/*T*/
 {0,0,1,3,3},/*U*/  {0,0,0,1,3},/*V*/   {0,1,1,3,3},/*W*/   {1,0,0,1,3},/*X*/
 {1,0,1,1,3},/*Y*/  {1,1,0,0,3},/*Z*/   {1,1,1,1,1},/*0*/   {0,1,1,1,1},/*1*/
 {0,0,1,1,1},/*2*/  {0,0,0,1,1},/*3*/   {0,0,0,0,1},/*4*/   {0,0,0,0,0},/*5*/
 {1,0,0,0,0},/*6*/  {1,1,0,0,0},/*7*/   {1,1,1,0,0},/*8*/   {1,1,1,1,0},/*9*/
 {2,3,3,3,3}/*space */
};
float unitInSeconds=(float)0.05;
float dot=unitInSeconds;
float dash=unitInSeconds*(float)3;
float internalLetterSepeator=dot;
float letterSeperator=dash;
float space= unitInSeconds*(float)7;
char sentence[100];

void morse(char letter);

void beep(int type);


int main()
{
    gnd=0;
    led=0;
    printf("Enter the sentence you want to morse\r\n");
    int count = 0;
    while (count < (99)) {
        sentence[count] = pc.getc();
        if ((sentence[count] == 0x0a) || (sentence[count] == 0x0d)) // end on a carriage return or a line feed.
            break;
        count ++;
    }

    sentence[count] = 0;
    printf("you entered: %s\r\n",sentence);

    while (true) {

        for (int i =0; i < sizeof(sentence); i++) {
            morse(sentence[i]);
        }
        wait(10*space);

    }
}

void morse(char letter)
{
    switch (letter)
    {
        case 'A':case 'a':{for (int i=0;i<5;i++)beep(morseArray[0][i]);wait(dash); break;}
        case 'B':case 'b':{for (int i=0;i<5;i++)beep(morseArray[1][i]);wait(dash); break;}
        case 'C':case 'c':{for (int i=0;i<5;i++)beep(morseArray[2][i]);wait(dash); break;}
        case 'D':case 'd':{for (int i=0;i<5;i++)beep(morseArray[3][i]);wait(dash); break;}
        case 'E':case 'e':{for (int i=0;i<5;i++)beep(morseArray[4][i]);wait(dash); break;}
        case 'F':case 'f':{for (int i=0;i<5;i++)beep(morseArray[5][i]);wait(dash); break;}
        case 'G':case 'g':{for (int i=0;i<5;i++)beep(morseArray[6][i]);wait(dash); break;}
        case 'H':case 'h':{for (int i=0;i<5;i++)beep(morseArray[7][i]);wait(dash); break;}
        case 'I':case 'i':{for (int i=0;i<5;i++)beep(morseArray[8][i]);wait(dash); break;}
        case 'J':case 'j':{for (int i=0;i<5;i++)beep(morseArray[9][i]);wait(dash); break;}
        case 'K':case 'k':{for (int i=0;i<5;i++)beep(morseArray[10][i]);wait(dash); break;}
        case 'L':case 'l':{for (int i=0;i<5;i++)beep(morseArray[11][i]);wait(dash); break;}
        case 'M':case 'm':{for (int i=0;i<5;i++)beep(morseArray[12][i]);wait(dash); break;}
        case 'N':case 'n':{for (int i=0;i<5;i++)beep(morseArray[13][i]);wait(dash); break;}
        case 'O':case 'o':{for (int i=0;i<5;i++)beep(morseArray[14][i]);wait(dash); break;}
        case 'P':case 'p':{for (int i=0;i<5;i++)beep(morseArray[15][i]);wait(dash); break;}
        case 'Q':case 'q':{for (int i=0;i<5;i++)beep(morseArray[16][i]);wait(dash); break;}
        case 'R':case 'r':{for (int i=0;i<5;i++)beep(morseArray[17][i]);wait(dash); break;}
        case 'S':case 's':{for (int i=0;i<5;i++)beep(morseArray[18][i]);wait(dash); break;}
        case 'T':case 't':{for (int i=0;i<5;i++)beep(morseArray[19][i]);wait(dash); break;}
        case 'U':case 'u':{for (int i=0;i<5;i++)beep(morseArray[20][i]);wait(dash); break;}
        case 'V':case 'v':{for (int i=0;i<5;i++)beep(morseArray[21][i]);wait(dash); break;}
        case 'W':case 'w':{for (int i=0;i<5;i++)beep(morseArray[22][i]);wait(dash); break;}
        case 'X':case 'x':{for (int i=0;i<5;i++)beep(morseArray[23][i]);wait(dash); break;}
        case 'Y':case 'y':{for (int i=0;i<5;i++)beep(morseArray[24][i]);wait(dash); break;}
        case 'Z':case 'z':{for (int i=0;i<5;i++)beep(morseArray[25][i]);wait(dash); break;}
        case '0':{for (int i=0;i<5;i++)beep(morseArray[26][i]);wait(dash); break;} case '1':{for (int i=0;i<5;i++)beep(morseArray[27][i]);wait(dash); break;}
        case '2':{for (int i=0;i<5;i++)beep(morseArray[28][i]);wait(dash); break;} case '3':{for (int i=0;i<5;i++)beep(morseArray[29][i]);wait(dash); break;}
        case '4':{for (int i=0;i<5;i++)beep(morseArray[30][i]);wait(dash); break;} case '5':{for (int i=0;i<5;i++)beep(morseArray[31][i]);wait(dash); break;}
        case '6':{for (int i=0;i<5;i++)beep(morseArray[32][i]);wait(dash); break;} case '7':{for (int i=0;i<5;i++)beep(morseArray[33][i]);wait(dash); break;}
        case '8':{for (int i=0;i<5;i++)beep(morseArray[34][i]);wait(dash); break;} case '9':{for (int i=0;i<5;i++)beep(morseArray[35][i]);wait(dash); break;}
        case ' ':{for (int i=0;i<5;i++)beep(morseArray[36][i]);wait(dash); break;}
    
    }
}

void beep(int type)
{
    switch(type)
    {
        case 0:{
                led=1;
                printf("dot   ");
                wait(dot);
                led=0;
                wait(dot);
                break;
               }
        case 1:{
                led=1;
                printf("dash   ");
                wait(dash);
                led=0;
                wait(dot);
                break;
               }
        case 2:{
                led=0;
                printf("space   ");
                wait(space);
                break;
               }
        default:{
                break;
               }
    }
}