#include "mbed.h"

DigitalOut  userLed(PA_5);

DigitalOut Vcc(PA_0);
AnalogIn aInn(PA_1);
DigitalOut Gnd(PA_4);

PwmOut      servoMotor(PA_7);
DigitalOut  direction(PA_6);

int main()
{
    servoMotor.period(.01);

    Vcc=1;
    Gnd=0;
    direction=0;
    
    while(1) {
        float pot = aInn.read();
        if(pot > 0.45f && pot < 0.55f)
        {
            direction=0;
            servoMotor = 0;
            printf("NULL Pot er: %f Servo er: %f\n\r",pot, servoMotor.read());
        } 
        else if (pot < 0.45f) 
        {
            direction = 0;
            userLed = 0;
            servoMotor = 1-pot*2;
            printf("CCW Pot er: %f Servo er: %f\n\r",pot, servoMotor.read());
        } 
        else if (pot > 0.55f) 
        {
            direction = 1;
            userLed = 1;
            servoMotor = 2-pot*2;
            printf("CW Pot er: %f Servo er: %f\n\r",pot, servoMotor.read());
        }  
    }

}
