#include "mbed.h"

//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------

Serial pc(SERIAL_TX, SERIAL_RX);

Timeout    onTime;
Ticker     periodTimer;
Timeout    timedown;

DigitalOut led(PA_9); 
InterruptIn  SW7(PB_3);
InterruptIn  SW6(PA_10);

float periodTime=0.020;  // 20ms period time (50Hz)
float dutyCycle=.50;

void timeouttick()
{
    SW7.enable_irq();
    SW6.enable_irq();
}

void interruptSW7(){
   SW7.disable_irq();
   timedown.attach(&timeouttick, 0.03); //debounce
   if(dutyCycle < 1.00f)
   {
   dutyCycle += 0.05f;
   }
}  

void interruptSW6(){
   SW6.disable_irq();
   timedown.attach(&timeouttick, 0.03); //debounce
   if(dutyCycle > 0.10f)
   {
    dutyCycle -= 0.05f;
    }
}    

void TurnLightOff()
{   led=1;
}

void TurnLightOn()
{   led=0;
    onTime.attach(&TurnLightOff,(float)periodTime*dutyCycle);
}

int main()
{
    pc.printf("Velkommen\r\n");
    //attach interrup to faling edge
    SW7.fall(&interruptSW7);
    SW6.fall(&interruptSW6);
    
    periodTimer.attach(&TurnLightOn,periodTime);
    
    float dutyCycleprv = 0.00f;

    while(1) {
        if(dutyCycleprv != dutyCycle)
        {
            pc.printf("DutyCycle: %.0f%%\r\n", dutyCycle*100);
            dutyCycleprv =dutyCycle;
        }
    }
}
