#include "mbed.h"

//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
//------------------------------------

Serial pc(SERIAL_TX, SERIAL_RX);

Ticker toggle_led_ticker;
Timeout timedown;

//define pins
DigitalOut  led1(PA_9);
InterruptIn  SW7(PB_3);
InterruptIn  SW6(PA_10);
 
//Variables
static float tickertimer = 0.1;

//Prototypes
void toggle_led();
void timeouttick();
void interrupt();


void timeouttick()
{
    SW7.enable_irq();
    SW6.enable_irq();
}

void interruptSW7(){
   SW7.disable_irq();
   timedown.attach(&timeouttick, 0.03); //debounce
   if(tickertimer > 0.00f)
        tickertimer += 0.01f;
   if(tickertimer > 0.00f)
    {
        
        toggle_led_ticker.attach(&toggle_led, tickertimer);
    } 
    else 
    {
        toggle_led_ticker.detach();
    }
}  

void interruptSW6(){
   SW6.disable_irq();
   timedown.attach(&timeouttick, 0.03); //debounce
   
   tickertimer -= 0.01f;
   toggle_led_ticker.attach(&toggle_led, tickertimer);
}    
   
void toggle_led() {
    led1 = !led1;
}

int main() {
    
    pc.printf("Velkommen\r\n");
    //attach interrup to faling edge
    SW7.fall(&interruptSW7);
    SW6.fall(&interruptSW6);
    
    // Init the ticker with the address of the function (toggle_led) to be attached and the interval (100 ms)
    
    
    
    while (true) {
        pc.printf("tickertimer: %2.3f\r\n", tickertimer);
        pc.printf("t\r\n");
        // Do other things...
    }
}