 #include "mbed.h"
 #include "TextLCD.h"
 
TextLCD lcd(D11,D10,D9,D5,D4,D3,D2);

InterruptIn MenuButton(USER_BUTTON);
 
//Variables
static char cMessageToLcdDisplay[80];  // variables to store message from serial
static bool blink = false;
static int menu = 0;

//Prototypes
void BlinkCursor(bool);
void ClearDisplay(); 
void GetMessageFromSerial();
void PrintToLcd();

void trigger() 
{
    switch (menu)
    {
        case 0:
        {
         ClearDisplay();
         lcd.printf("Meny 1");
         printf("Du er na i meny %d\r\n", menu +1);
         menu++;
         break;    
        }   
        
        case 1:
        {
         ClearDisplay();
         lcd.printf("Meny 2");
         printf("Du er na i meny %d\r\n", menu +1);
         menu++;
         break;    
        }
          
        case 2:
        {
         ClearDisplay();
         lcd.printf("Meny 3");
         printf("Du er na i meny %d\r\n", menu +1);
         menu = 0;
         break;    
        }  
    }
    /*
    if(blink)
    {
        BlinkCursor(false);
        blink = false;
    }
    else
    {
         BlinkCursor(true);
         blink = true;
    }
*/
}
 
int main()
{    
    MenuButton.rise(&trigger);
    
    while(1) 
    {
        printf("Velkommen skriv inn tekst som skal vises pa lcd skejerm.\r\n");   
        
        GetMessageFromSerial();
        
        ClearDisplay();
        
        wait_ms(2);
        
        PrintToLcd();
        
        BlinkCursor(true);
       
       /*
       lcd.gotoxy(1,1);
        lcd.printf("Nr: %d", iCounter);
        lcd.gotoxy(1,2);
        lcd.printf("Nr: %d", iCounter+1);
        iCounter++;
        ClearDisplay();
        wait_ms(500);
        */
    }
 }
 
 
void BlinkCursor(bool OnOff)
{
    if(OnOff)lcd.lcdCommand(0x0F);
    else     lcd.lcdCommand(0x0C);
}

void ClearDisplay()
{
    lcd.lcdCommand(0x01); 
    wait_ms(2);  
}

void GetMessageFromSerial()
{
scanf("%[^\r\n]s", cMessageToLcdDisplay);    
getchar();
}

void PrintToLcd()
{
    lcd.printf(cMessageToLcdDisplay);
}