#include "mbed.h"

BusOut StepperMotor1(PA_7, PB_6, PC_7, PA_9);
InterruptIn User_Button(PC_13);


//Variables
Timer timer;
static int iValg = 6;


//Prototypes
void DriveStepperCW(int);
void DriveStepperCCW(int);

void Interrupt()
{
    printf("Interrupt\n");
    iValg = 6;    
}

int main() 
{
    printf("Welcome\r\n");
    
    
    //Start timer
    timer.start();
    User_Button.fall(&Interrupt);
    
    //Variables
    int first = 1;
    


    
    
    while(1) 
    {
           switch (iValg)
           {
               case 0:
               {
                   if(first)
                   {
                    printf("Rotate one round CW\r\n");
                    first=0;
                    }
                DriveStepperCW(1);
                   
               break;
               }
               
               case 1:
               {
                   if(first)
                   {
                    printf("Rotate one round CCW\r\n");
                    
                    first=0;
                    
                    }
               DriveStepperCCW(1);
                   
                   
               break;
               }
        
            
               
               
               default:
               {
                        printf("Option:\r\n");
                        printf("0 = Rotate one round CW\r\n");
                        printf("1 = Rotate one round CCW\r\n");
                        printf("\n\r\n");
                        
                        scanf("%d", &iValg); 
                        
                        first = 1;
                        break;   
                 }
               }
            }                                
    
}

void DriveStepperCW(int round)
{
    if(round == 0)
    {
        while(iValg <5)
        {  
                   StepperMotor1 = 0x3;
                   wait_ms(10);
                   StepperMotor1 = 0x6;
                   wait_ms(10);
                   StepperMotor1 = 0xc;
                   wait_ms(10);
                   StepperMotor1 = 0x9;
                   wait_ms(10);
        }
    }
    else
    {
     
     int step = 360/(5.625/64)/4/2*round;
     
     while(iValg <5)
        {
            for(int i = 0; i < step; i++)
             {
                       StepperMotor1 = 0x3;
                       wait_ms(10);
                       StepperMotor1 = 0x6;
                       wait_ms(10);
                       StepperMotor1 = 0xc;
                       wait_ms(10);
                       StepperMotor1 = 0x9;
                       wait_ms(10);
          } 
        iValg = 6;
      }
    }
}

void DriveStepperCCW(int round)
{
    if(round == 0)
    {
        
        
        while(iValg <5)
        {
            
                   StepperMotor1 = 0x9;
                   wait_ms(10);
                   StepperMotor1 = 0xC;
                   wait_ms(10);
                   StepperMotor1 = 0x6;
                   wait_ms(10);
                   StepperMotor1 = 0x3;
                   wait_ms(10);
        }
    }
    else
    {
     
     int step = 360/(5.625/64)/4/2*round;
     
     while(iValg <5)
        {
            for(int i = 0; i < step; i++)
             {
                       StepperMotor1 = 0x9;
                       wait_ms(10);
                       StepperMotor1 = 0xC;
                       wait_ms(10);
                       StepperMotor1 = 0x6;
                       wait_ms(10);
                       StepperMotor1 = 0x3;
                       wait_ms(10);
            }   
        iValg = 6;
      }
    }
}
