#include "mbed.h"
#include "SerialTerminal.h"
#include "variables.h"

SerialTerminal pc(USBTX, USBRX, 115200); // tx, rx


//Prototypes
void Beregn(void);
void FlaskeRegistrering(int);
void utskriftskjerm(void);
void utskriftskjermV2(void);
void UpdateTerminal(void);

int main() {

    /*  
    1. Type 1: 1/3 liter
    2. Type 2: 1/2 liter
    3. Type 3: 1 liter
    4. Type 4: 1 1/2 liter
    5. Type 5: Ukurante flasker
    */


    char cValg = -1;
    pc.cls();
    pc.locate(MENUPOSX, MENUPOSY);
    pc.hideCursor();
    UpdateTerminal();
    //term.printf("Velkommen skriv inn flaske type etterfolg av enter tast\n");
    while (1)
    {
    //while (iValg != 0)
    //{

       // scanf("%d", &iValg);
        cValg = getchar();
        if (cValg <= 57 || cValg >= 48)
        {
            if      (cValg == 49) FlaskeRegistrering(0);
            else if (cValg == 50) FlaskeRegistrering(1);
            else if (cValg == 51) FlaskeRegistrering(2);
            else if (cValg == 52) FlaskeRegistrering(3);
            else if (cValg != 48) FlaskeRegistrering(4);
        }
        else
        {
            //printf("ugyldig inntasting\n");
        }
     //}
        wait(0.03);
    }
}

void Beregn()
{
    char *ptr_antall_type = &menu[66 * 3 + 28];
    char *ptr_kr_type = ptr_antall_type + 10;
    char *ptr_total;
    int iTotalFlasker = 0;
    float fTotalFlaskePris = 0.00;
    char buffer[15];
    int iKr_Offset = 66;

    for (int i = 0; i < TYPES; i++, ptr_antall_type += iKr_Offset, ptr_kr_type += iKr_Offset)
    {
        iTotalFlasker += aiFlaskeType[i];
        fTotalFlaskePris += aiFlaskeType[i] * aiFlaskeTypePrice[i];

        if (i <= 3)
        {
            //Flaske antall
            sprintf(buffer, "%2d", aiFlaskeType[i]);
            memcpy(ptr_antall_type, buffer, 2);
            //Flaske pris
            sprintf(buffer, "%6.2f", (aiFlaskeType[i] * aiFlaskeTypePrice[i]));
            memcpy(ptr_kr_type, buffer, 6);

        }
        else
        {
            sprintf(buffer, "%2d", aiFlaskeType[i]);
            memcpy(ptr_antall_type, buffer, 2);
        }
    }

    ptr_total = ptr_antall_type + (46);

    //Flaske totoal antall
    sprintf(buffer, "%3d", iTotalFlasker);
    memcpy(ptr_total, buffer, 3);
    ptr_total += 19;
    sprintf(buffer, "%6.2f", fTotalFlaskePris);
    memcpy(ptr_total, buffer, 6);
}

void FlaskeRegistrering(int FlaskeType)
{
    aiFlaskeType[FlaskeType]++;
    UpdateTerminal();
}

void UpdateTerminal()
{
    Beregn();
    utskriftskjermV2(); 
}

void utskriftskjermV2()
{
    char *ptr_menu = menu;
    pc.cls();
    pc.locate(MENUPOSX, MENUPOSY);
    pc.foreground(0xFF0000);

    for (int i = 1; i <= MENULINES; i++)
    {
        for (int j = 1; j <= MENUWIDTH; j++, ptr_menu++)
        {
            pc.printf("%c", *ptr_menu);

        }
        pc.locate(MENUPOSX, i + MENUPOSY);
        //term.printf("\n");
    }
    //term.printf("\n");
}